/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.config.DescriptorSupport;
import com.sun.jbi.management.util.PropertyFilter;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.File;
import java.util.Properties;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class DeploymentConfigurationFactory
extends ConfigurationFactory {
    public static final String SERVICE_UNIT_TIMEOUT = "serviceUnitTimeout";
    public static final String DEPLOYMENT_TIMEOUT = "deploymentTimeout";
    public static final String ENABLE_AUTO_DEPLOY = "autoDeployEnabled";
    public static final String ENABLE_AUTO_REDEPLOY = "autoRedeployEnabled";
    public static final String ENABLE_AUTO_UNDEPLOY = "autoUndeployEnabled";
    public static final String START_ON_DEPLOY = "startOnDeploy";
    public static final String START_ON_VERIFY = "startOnVerify";
    public static final String AUTO_DEPLOY_DIR = "autoDeployDir";
    private static final String AUTO_DEPLOY_DIR_NAME = "autodeploy";
    private static final int sNumAttributes = 8;

    public DeploymentConfigurationFactory(Properties defProps) {
        super(defProps, ConfigurationCategory.Deployment);
    }

    @Override
    public ModelMBeanAttributeInfo[] createMBeanAttributeInfo() {
        ModelMBeanAttributeInfo[] attributeInfos = new ModelMBeanAttributeInfo[8];
        DescriptorSupport descr = new DescriptorSupport();
        String attrDescr = this.getString("SERVICE_UNIT_TIMEOUT_DESCR");
        descr.setAttributeName(SERVICE_UNIT_TIMEOUT);
        descr.setDisplayName(this.getString("SERVICE_UNIT_TIMEOUT_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("SERVICE_UNIT_TIMEOUT_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("SERVICE_UNIT_TIMEOUT_DESCR"));
        descr.setToolTip(this.getString("SERVICE_UNIT_TIMEOUT_TOOLTIP"));
        descr.setToolTipId(this.getToken("SERVICE_UNIT_TIMEOUT_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defValue = this.mDefaults.getProperty(this.getQualifiedKey(SERVICE_UNIT_TIMEOUT), "0");
        descr.setDefault(Integer.parseInt(defValue));
        descr.setMinValue(0);
        descr.setMaxValue(Integer.MAX_VALUE);
        descr.setUnit("milliseconds");
        attributeInfos[0] = new ModelMBeanAttributeInfo(SERVICE_UNIT_TIMEOUT, "int", attrDescr, true, true, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("DEPLOYMENT_TIMEOUT_DESCR");
        descr.setAttributeName(DEPLOYMENT_TIMEOUT);
        descr.setDisplayName(this.getString("DEPLOYMENT_TIMEOUT_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("DEPLOYMENT_TIMEOUT_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("DEPLOYMENT_TIMEOUT_DESCR"));
        descr.setToolTip(this.getString("DEPLOYMENT_TIMEOUT_TOOLTIP"));
        descr.setToolTipId(this.getToken("DEPLOYMENT_TIMEOUT_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        defValue = this.mDefaults.getProperty(this.getQualifiedKey(DEPLOYMENT_TIMEOUT), "0");
        descr.setDefault(Integer.parseInt(defValue));
        descr.setMinValue(0);
        descr.setMaxValue(Integer.MAX_VALUE);
        descr.setUnit("milliseconds");
        attributeInfos[1] = new ModelMBeanAttributeInfo(DEPLOYMENT_TIMEOUT, "int", attrDescr, true, true, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("ENABLE_AUTO_DEPLOY_DESCR");
        descr.setAttributeName(ENABLE_AUTO_DEPLOY);
        descr.setDisplayName(this.getString("ENABLE_AUTO_DEPLOY_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("ENABLE_AUTO_DEPLOY_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("ENABLE_AUTO_DEPLOY_DESCR"));
        descr.setToolTip(this.getString("ENABLE_AUTO_DEPLOY_TOOLTIP"));
        descr.setToolTipId(this.getToken("ENABLE_AUTO_DEPLOY_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defEnableAutoDeploy = this.mDefaults.getProperty(this.getQualifiedKey(ENABLE_AUTO_DEPLOY), "true");
        boolean autoDeployEnabled = Boolean.parseBoolean(defEnableAutoDeploy);
        descr.setDefault(autoDeployEnabled);
        attributeInfos[2] = new ModelMBeanAttributeInfo(ENABLE_AUTO_DEPLOY, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("ENABLE_AUTO_UNDEPLOY_DESCR");
        descr.setAttributeName(ENABLE_AUTO_UNDEPLOY);
        descr.setDisplayName(this.getString("ENABLE_AUTO_UNDEPLOY_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("ENABLE_AUTO_UNDEPLOY_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("ENABLE_AUTO_UNDEPLOY_DESCR"));
        descr.setToolTip(this.getString("ENABLE_AUTO_UNDEPLOY_TOOLTIP"));
        descr.setToolTipId(this.getToken("ENABLE_AUTO_UNDEPLOY_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defEnableAutoUndeploy = this.mDefaults.getProperty(this.getQualifiedKey(ENABLE_AUTO_UNDEPLOY), "true");
        boolean autoUndeployEnabled = Boolean.parseBoolean(defEnableAutoUndeploy) && autoDeployEnabled;
        descr.setDefault(autoUndeployEnabled);
        attributeInfos[3] = new ModelMBeanAttributeInfo(ENABLE_AUTO_UNDEPLOY, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("ENABLE_AUTO_REDEPLOY_DESCR");
        descr.setAttributeName(ENABLE_AUTO_REDEPLOY);
        descr.setDisplayName(this.getString("ENABLE_AUTO_REDEPLOY_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("ENABLE_AUTO_REDEPLOY_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("ENABLE_AUTO_REDEPLOY_DESCR"));
        descr.setToolTip(this.getString("ENABLE_AUTO_REDEPLOY_TOOLTIP"));
        descr.setToolTipId(this.getToken("ENABLE_AUTO_REDEPLOY_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defEnableAutoRedeploy = this.mDefaults.getProperty(this.getQualifiedKey(ENABLE_AUTO_REDEPLOY), "true");
        boolean autoRedeployEnabled = Boolean.parseBoolean(defEnableAutoRedeploy) && autoDeployEnabled && autoUndeployEnabled;
        descr.setDefault(autoRedeployEnabled);
        attributeInfos[4] = new ModelMBeanAttributeInfo(ENABLE_AUTO_REDEPLOY, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("AUTO_DEPLOY_DIR_DESCR");
        descr.setAttributeName(AUTO_DEPLOY_DIR);
        descr.setDisplayName(this.getString("AUTO_DEPLOY_DIR_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("AUTO_DEPLOY_DIR_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("AUTO_DEPLOY_DIR_DESCR"));
        descr.setToolTip(this.getString("AUTO_DEPLOY_DIR_TOOLTIP"));
        descr.setToolTipId(this.getToken("AUTO_DEPLOY_DIR_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(true);
        descr.setIsPassword(false);
        descr.setDefault(this.getAutoDeployDir());
        attributeInfos[5] = new ModelMBeanAttributeInfo(AUTO_DEPLOY_DIR, "java.lang.String", attrDescr, true, false, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("START_ON_DEPLOY_DESCR");
        descr.setAttributeName(START_ON_DEPLOY);
        descr.setDisplayName(this.getString("START_ON_DEPLOY_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("START_ON_DEPLOY_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("START_ON_DEPLOY_DESCR"));
        descr.setToolTip(this.getString("START_ON_DEPLOY_TOOLTIP"));
        descr.setToolTipId(this.getToken("START_ON_DEPLOY_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defStartOnDeploy = this.mDefaults.getProperty(this.getQualifiedKey(START_ON_DEPLOY), "true");
        descr.setDefault(Boolean.parseBoolean(defStartOnDeploy));
        descr.setDefault(true);
        attributeInfos[6] = new ModelMBeanAttributeInfo(START_ON_DEPLOY, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("START_ON_VERIFY_DESCR");
        descr.setAttributeName(START_ON_VERIFY);
        descr.setDisplayName(this.getString("START_ON_VERIFY_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("START_ON_VERIFY_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("START_ON_VERIFY_DESCR"));
        descr.setToolTip(this.getString("START_ON_VERIFY_TOOLTIP"));
        descr.setToolTipId(this.getToken("START_ON_VERIFY_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defStartOnVerify = this.mDefaults.getProperty(this.getQualifiedKey(START_ON_VERIFY), "true");
        descr.setDefault(Boolean.parseBoolean(defStartOnVerify));
        descr.setDefault(true);
        attributeInfos[7] = new ModelMBeanAttributeInfo(START_ON_VERIFY, "boolean", attrDescr, true, true, true, descr);
        return attributeInfos;
    }

    private String getAutoDeployDir() {
        EnvironmentContext envCtx = EnvironmentAccess.getContext();
        StringBuffer deployDir = new StringBuffer(envCtx.getJbiInstanceRoot());
        deployDir.append(File.separator);
        deployDir.append(AUTO_DEPLOY_DIR_NAME);
        String defDeployDir = this.mDefaults.getProperty(this.getQualifiedKey(AUTO_DEPLOY_DIR), deployDir.toString());
        String absDeployDir = PropertyFilter.filterProperties(defDeployDir);
        if (absDeployDir != null) {
            absDeployDir = absDeployDir.replace('\\', '/');
        }
        return absDeployDir;
    }
}

