/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.JarCache;
import com.sun.jbi.framework.StringTranslator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CustomClassLoader
extends URLClassLoader {
    private StringTranslator mTranslator;
    private boolean mSelfFirst = false;
    private ClassLoader mSystemLoader;
    private ClassLoader mParentLoader;
    private String[] mFilteredPkgs = new String[]{"java.", "javax.", "sun."};
    private Logger mLogger;
    private JarCache mJarCache;

    public CustomClassLoader(URL[] urls, ClassLoader parentCL, boolean selfFirst) {
        super(urls, parentCL);
        this.mSelfFirst = selfFirst;
        this.mSystemLoader = CustomClassLoader.getSystemClassLoader();
        this.mParentLoader = parentCL != null ? parentCL : this.mSystemLoader;
        EnvironmentContext ec = EnvironmentContext.getInstance();
        this.mTranslator = (StringTranslator)ec.getStringTranslatorFor(this);
        this.mLogger = ec.getLogger();
        this.initJarCache(urls);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> componentClass = null;
        this.mLogger.log(Level.FINEST, "Custom ClassLoader - loadClass: {0}", name);
        componentClass = this.findLoadedClass(name);
        if (componentClass != null) {
            if (resolve) {
                this.resolveClass(componentClass);
            }
            this.mLogger.log(Level.FINEST, "Class {0} will be loaded from cache", name);
            return componentClass;
        }
        boolean isFiltered = false;
        if (this.isFilteredClassOrResource(name)) {
            isFiltered = true;
            try {
                componentClass = this.mParentLoader.loadClass(name);
                return componentClass;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        try {
            if (!this.mSelfFirst && !isFiltered) {
                componentClass = this.mParentLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(componentClass);
                }
                this.mLogger.log(Level.FINEST, "Class {0} will be loaded using {1}", new Object[]{name, this.mParentLoader.toString()});
                return componentClass;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            componentClass = this.findClass(name);
            if (componentClass != null) {
                if (resolve) {
                    this.resolveClass(componentClass);
                }
                this.mLogger.log(Level.FINEST, "Class {0} will be loaded using {1}", new Object[]{name, this.toString()});
                return componentClass;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (this.mSelfFirst && !isFiltered) {
            try {
                componentClass = this.mParentLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(componentClass);
                }
                this.mLogger.log(Level.FINEST, "Class {0} will be loaded using {1}", new Object[]{name, this.mParentLoader.toString()});
                return componentClass;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        URL retURL = null;
        boolean isFiltered = false;
        if (this.isFilteredClassOrResource(name)) {
            isFiltered = true;
            retURL = this.mParentLoader.getResource(name);
            if (retURL != null) {
                return retURL;
            }
        }
        if (!this.mSelfFirst && !isFiltered && (retURL = this.mParentLoader.getResource(name)) != null) {
            return retURL;
        }
        retURL = this.mJarCache.findResource(name);
        if (retURL == null) {
            retURL = this.findResource(name);
        }
        if (retURL != null) {
            return retURL;
        }
        if (this.mSelfFirst && !isFiltered && (retURL = this.mParentLoader.getResource(name)) != null) {
            return retURL;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream retStream = null;
        boolean isFiltered = false;
        if (this.isFilteredClassOrResource(name)) {
            isFiltered = true;
            retStream = this.mParentLoader.getResourceAsStream(name);
            if (retStream != null) {
                return retStream;
            }
        }
        if (!this.mSelfFirst && !isFiltered && (retStream = this.mParentLoader.getResourceAsStream(name)) != null) {
            return retStream;
        }
        URL resURL = this.mJarCache.findResource(name);
        if (resURL == null) {
            resURL = this.findResource(name);
        }
        if (resURL != null) {
            try {
                return resURL.openStream();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (this.mSelfFirst && !isFiltered && (retStream = this.mParentLoader.getResourceAsStream(name)) != null) {
            return retStream;
        }
        return null;
    }

    private boolean isFilteredClassOrResource(String name) {
        boolean isFilteredPkg = false;
        String pkgPrefix = name.substring(0, name.indexOf(".") + 1);
        for (String mFilteredPkg : this.mFilteredPkgs) {
            String nextPkg = mFilteredPkg;
            if (!nextPkg.equalsIgnoreCase(pkgPrefix)) continue;
            isFilteredPkg = true;
            break;
        }
        return isFilteredPkg;
    }

    public void releaseResources() {
        this.mJarCache.close();
    }

    private void initJarCache(URL[] urls) {
        this.mJarCache = new JarCache();
        for (URL url : urls) {
            try {
                File file = new File(url.getFile());
                if (!file.exists() || !file.getName().endsWith(".jar")) continue;
                this.mJarCache.addJar(file.getPath());
            }
            catch (IOException ioEx) {
                this.mLogger.log(Level.FINE, this.mTranslator.getString("CU_CL_CREATE_IO_ERROR", url.getFile()), ioEx);
            }
        }
    }
}

