/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.util.ComponentConfigurationHelper;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ComponentConfiguration
implements com.sun.jbi.management.ComponentConfiguration {
    private String mComponentName;
    private EnvironmentContext mEnvCtx;
    private MessageBuilder mMsgBuilder;
    private StringTranslator mTranslator;
    private Logger mLog;
    private static final String MASKED_FIELD_VALUE = "*****";
    private static final String PASSWORD = "PASSWORD";
    private ComponentConfigurationHelper mCfgHlpr;

    public ComponentConfiguration(EnvironmentContext ctx, String compName) {
        this.mComponentName = compName;
        this.mEnvCtx = ctx;
        this.mTranslator = (StringTranslator)this.mEnvCtx.getStringTranslatorFor(this);
        this.mLog = this.mEnvCtx.getLogger();
        this.mCfgHlpr = new ComponentConfigurationHelper();
        try {
            this.mMsgBuilder = new MessageBuilder(this.mTranslator);
        }
        catch (ManagementException mex) {
            this.mLog.warning(mex.getMessage());
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if ("ApplicationVariables".equals(attribute)) {
            return this.getApplicationVariables();
        }
        if ("ApplicationConfigurations".equals(attribute)) {
            return this.getApplicationConfigurations();
        }
        AttributeList attribList = this.getAttributes(new String[]{attribute});
        if (!attribList.isEmpty()) {
            return ((Attribute)attribList.get(0)).getValue();
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            this.mEnvCtx.getMBeanServer().setAttribute(configMBeanName, attribute);
        }
        catch (InstanceNotFoundException iex) {
            throw new MBeanException(iex);
        }
        this.persistAttribute(attribute);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("addApplicationVariable")) {
            return this.addApplicationVariable((String)params[0], (CompositeData)params[1]);
        }
        if (actionName.equals("setApplicationVariable")) {
            return this.setApplicationVariable((String)params[0], (CompositeData)params[1]);
        }
        if (actionName.equals("deleteApplicationVariable")) {
            return this.deleteApplicationVariable((String)params[0]);
        }
        if (actionName.equals("getApplicationVariables")) {
            return this.getApplicationVariables();
        }
        if (actionName.equals("getApplicationConfigurations")) {
            return this.getApplicationConfigurations();
        }
        if (actionName.equals("addApplicationConfiguration")) {
            if (params[1] instanceof Properties) {
                return this.addApplicationConfiguration((String)params[0], (Properties)params[1]);
            }
            return this.addApplicationConfiguration((String)params[0], (CompositeData)params[1]);
        }
        if (actionName.equals("setApplicationConfiguration")) {
            if (params[1] instanceof Properties) {
                return this.setApplicationConfiguration((String)params[0], (Properties)params[1]);
            }
            return this.setApplicationConfiguration((String)params[0], (CompositeData)params[1]);
        }
        if (actionName.equals("deleteApplicationConfiguration")) {
            return this.deleteApplicationConfiguration((String)params[0]);
        }
        if (actionName.equals("queryApplicationConfigurationType")) {
            return this.queryApplicationConfigurationType();
        }
        if (actionName.equals("retrieveConfigurationDisplaySchema")) {
            return this.retrieveConfigurationDisplaySchema();
        }
        if (actionName.equals("retrieveConfigurationDisplayData")) {
            return this.retrieveConfigurationDisplayData();
        }
        if (actionName.equals("isAppVarsSupported")) {
            return this.isAppVarsSupported();
        }
        if (actionName.equals("isAppConfigSupported")) {
            return this.isAppConfigSupported();
        }
        if (actionName.equals("isComponentConfigSupported")) {
            return this.isComponentConfigSupported();
        }
        throw new UnsupportedOperationException(actionName);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        AttributeList attribs = new AttributeList();
        try {
            attribs = this.mEnvCtx.getMBeanServer().setAttributes(configMBeanName, attributes);
        }
        catch (Exception iex) {
            throw new RuntimeException(iex);
        }
        this.persistAttributes(attribs);
        return attribs;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo;
        MBeanInfo augInfo = mbeanInfo = this.getComponentMBeanInfo();
        try {
            Method[] methods = Class.forName("com.sun.jbi.management.ComponentConfiguration").getDeclaredMethods();
            MBeanOperationInfo[] opInfos = new MBeanOperationInfo[methods.length];
            int i = 0;
            for (Method mtd : methods) {
                opInfos[i++] = new MBeanOperationInfo(mtd.getName(), mtd);
            }
            augInfo = new MBeanInfo(mbeanInfo.getClassName(), mbeanInfo.getDescription(), mbeanInfo.getAttributes(), mbeanInfo.getConstructors(), this.merge(mbeanInfo.getOperations(), opInfos), mbeanInfo.getNotifications());
        }
        catch (Exception ex) {
            this.mLog.log(Level.FINEST, ex.getMessage(), ex);
        }
        return augInfo;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName != null && this.mEnvCtx.getMBeanServer().isRegistered(configMBeanName)) {
            try {
                AttributeList attribList = this.mEnvCtx.getMBeanServer().getAttributes(configMBeanName, attributes);
                return attribList;
            }
            catch (JMException iex) {
                this.mLog.warning(iex.getMessage());
            }
        }
        return new AttributeList();
    }

    public String setConfigurationAttribute(Attribute attrib) throws JBIException {
        throw new UnsupportedOperationException();
    }

    public String setConfigurationAttributes(AttributeList attribList) throws JBIException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isComponentConfigSupported() throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName == null) {
            return false;
        }
        MBeanInfo mbnInfo = this.getComponentMBeanInfo();
        MBeanAttributeInfo[] attrInfos = mbnInfo.getAttributes();
        int realAttrCount = 0;
        for (MBeanAttributeInfo attrInfo : attrInfos) {
            if ("ApplicationVariables".equals(attrInfo.getName()) || "ApplicationConfigurations".equals(attrInfo.getName()) || !attrInfo.isReadable() || !attrInfo.isWritable()) continue;
            ++realAttrCount;
        }
        return realAttrCount > 0;
    }

    @Override
    public boolean isAppVarsSupported() throws MBeanException {
        MBeanAttributeInfo[] attrInfos;
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName == null) {
            return false;
        }
        MBeanInfo mbnInfo = this.getComponentMBeanInfo();
        MBeanOperationInfo[] opInfos = mbnInfo.getOperations();
        int numOpsSupported = 0;
        for (MBeanOperationInfo opInfo : opInfos) {
            MBeanParameterInfo[] params;
            if (opInfo.getName().equals("addApplicationVariable")) {
                params = opInfo.getSignature();
                if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                ++numOpsSupported;
                continue;
            }
            if (opInfo.getName().equals("setApplicationVariable")) {
                params = opInfo.getSignature();
                if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                ++numOpsSupported;
                continue;
            }
            if (!opInfo.getName().equals("deleteApplicationVariable") || (params = opInfo.getSignature()).length != 1 || !params[0].getType().equals("java.lang.String")) continue;
            ++numOpsSupported;
        }
        boolean isAppVarsAttribSupported = false;
        for (MBeanAttributeInfo attrInfo : attrInfos = mbnInfo.getAttributes()) {
            if (!attrInfo.getName().equals("ApplicationVariables")) continue;
            isAppVarsAttribSupported = true;
        }
        return numOpsSupported == 3 && isAppVarsAttribSupported;
    }

    @Override
    public String addApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{name, appVar};
            String[] sign = new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"};
            this.operationSupportedCheck(configMBeanName, "addApplicationVariable", sign);
            this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "addApplicationVariable", params, sign);
            this.addApplicationVariable(appVar);
            response = this.mMsgBuilder.buildFrameworkMessage("addApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception iex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("addApplicationVariable", iex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new MBeanException(new Exception(mex.getMessage()));
            }
        }
        return response;
    }

    @Override
    public String setApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{name, appVar};
            String[] sign = new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"};
            this.operationSupportedCheck(configMBeanName, "setApplicationVariable", sign);
            this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "setApplicationVariable", params, sign);
            this.updateApplicationVariable(appVar);
            response = this.mMsgBuilder.buildFrameworkMessage("setApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception iex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("setApplicationVariable", iex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new MBeanException(new Exception(mex.getMessage()));
            }
        }
        return response;
    }

    @Override
    public String deleteApplicationVariable(String name) throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{name};
            String[] sign = new String[]{"java.lang.String"};
            this.operationSupportedCheck(configMBeanName, "deleteApplicationVariable", sign);
            this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "deleteApplicationVariable", params, sign);
            this.removeApplicationVariable(name);
            response = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception iex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("deleteApplicationVariable", iex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new MBeanException(new Exception(mex.getMessage()));
            }
        }
        return response;
    }

    @Override
    public TabularData getApplicationVariables() {
        TabularData appVars = null;
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName != null && this.mEnvCtx.getMBeanServer().isRegistered(configMBeanName)) {
            try {
                appVars = (TabularData)this.mEnvCtx.getMBeanServer().getAttribute(configMBeanName, "ApplicationVariables");
            }
            catch (JMException iex) {
                this.mLog.warning(iex.toString());
            }
        }
        if (appVars == null) {
            try {
                appVars = this.createEmptyAppVarTable();
            }
            catch (OpenDataException oex) {
                throw new RuntimeException(oex);
            }
        }
        return appVars;
    }

    @Override
    public boolean isAppConfigSupported() throws MBeanException {
        MBeanAttributeInfo[] attrInfos;
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName == null) {
            return false;
        }
        MBeanInfo mbnInfo = this.getComponentMBeanInfo();
        MBeanOperationInfo[] opInfos = mbnInfo.getOperations();
        int numOpsSupported = 0;
        for (MBeanOperationInfo opInfo : opInfos) {
            String returnType;
            MBeanParameterInfo[] params;
            if (opInfo.getName().equals("addApplicationConfiguration")) {
                params = opInfo.getSignature();
                if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                ++numOpsSupported;
                continue;
            }
            if (opInfo.getName().equals("setApplicationConfiguration")) {
                params = opInfo.getSignature();
                if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                ++numOpsSupported;
                continue;
            }
            if (opInfo.getName().equals("deleteApplicationConfiguration")) {
                params = opInfo.getSignature();
                if (params.length != 1 || !params[0].getType().equals("java.lang.String")) continue;
                ++numOpsSupported;
                continue;
            }
            if (!opInfo.getName().equals("queryApplicationConfigurationType") || (params = opInfo.getSignature()).length != 0 || !(returnType = opInfo.getReturnType()).equals("javax.management.openmbean.CompositeType")) continue;
            ++numOpsSupported;
        }
        boolean isAppConfigAttribSupported = false;
        for (MBeanAttributeInfo attrInfo : attrInfos = mbnInfo.getAttributes()) {
            if (!attrInfo.getName().equals("ApplicationConfigurations")) continue;
            isAppConfigAttribSupported = true;
        }
        return numOpsSupported == 4 && isAppConfigAttribSupported;
    }

    @Override
    public CompositeType queryApplicationConfigurationType() {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        CompositeType ct = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{};
            String[] sign = new String[]{};
            this.operationSupportedCheck(configMBeanName, "queryApplicationConfigurationType", sign);
            ct = (CompositeType)this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "queryApplicationConfigurationType", params, sign);
        }
        catch (Exception iex) {
            this.mLog.warning(MessageHelper.getMsgString(iex));
        }
        return ct;
    }

    @Override
    public String addApplicationConfiguration(String name, Properties appCfgProps) throws MBeanException {
        throw new UnsupportedOperationException("addApplicationConfiguration");
    }

    @Override
    public String addApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{name, appConfig};
            String[] sign = new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"};
            this.operationSupportedCheck(configMBeanName, "addApplicationConfiguration", sign);
            this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "addApplicationConfiguration", params, sign);
            this.addApplicationConfiguration(appConfig);
            response = this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception iex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("addApplicationConfiguration", iex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new MBeanException(new Exception(mex.getMessage()));
            }
        }
        return response;
    }

    @Override
    public String deleteApplicationConfiguration(String name) throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{name};
            String[] sign = new String[]{"java.lang.String"};
            this.operationSupportedCheck(configMBeanName, "deleteApplicationConfiguration", sign);
            this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "deleteApplicationConfiguration", params, sign);
            this.removeApplicationConfiguration(name);
            response = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception iex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("deleteApplicationConfiguration", iex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new MBeanException(new Exception(mex.getMessage()));
            }
        }
        return response;
    }

    @Override
    public String setApplicationConfiguration(String name, Properties appCfgProps) throws MBeanException {
        throw new UnsupportedOperationException("setApplicationConfiguration");
    }

    @Override
    public String setApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            Object[] params = new Object[]{name, appConfig};
            String[] sign = new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"};
            this.operationSupportedCheck(configMBeanName, "setApplicationConfiguration", sign);
            this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "setApplicationConfiguration", params, sign);
            this.updateApplicationConfiguration(appConfig);
            response = this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception iex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("updateApplicationConfiguration", iex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.warning(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new MBeanException(new Exception(mex.getMessage()));
            }
        }
        return response;
    }

    @Override
    public TabularData getApplicationConfigurations() {
        ObjectName configMBeanName;
        TabularData appConfigs = null;
        try {
            appConfigs = this.createEmptyAppConfigTable();
        }
        catch (OpenDataException oex) {
            throw new RuntimeException(oex);
        }
        if (appConfigs.isEmpty() && (configMBeanName = this.getComponentConfigurationMBeanName()) != null && this.mEnvCtx.getMBeanServer().isRegistered(configMBeanName)) {
            try {
                appConfigs = (TabularData)this.mEnvCtx.getMBeanServer().getAttribute(configMBeanName, "ApplicationConfigurations");
            }
            catch (JMException iex) {
                this.mLog.warning(iex.toString());
            }
        }
        return appConfigs;
    }

    @Override
    public String retrieveConfigurationDisplaySchema() {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            this.operationSupportedCheck(configMBeanName, "retrieveConfigurationDisplaySchema", new String[0]);
            response = (String)this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "retrieveConfigurationDisplaySchema", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            this.mLog.warning(MessageHelper.getMsgString(ex));
            throw new RuntimeException(ex.getMessage());
        }
        return response;
    }

    @Override
    public String retrieveConfigurationDisplayData() {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        String response = null;
        if (configMBeanName == null) {
            throw new RuntimeException(this.mTranslator.getString("CCFG_MISSING_COMPONENT_CONFIG_MBEAN", this.mComponentName));
        }
        try {
            String ns = this.getComponentConfigurationNS(this.mComponentName);
            if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
                response = this.getComponentConfigurationData(this.mComponentName);
            } else {
                this.operationSupportedCheck(configMBeanName, "retrieveConfigurationDisplayData", new String[0]);
                response = (String)this.mEnvCtx.getMBeanServer().invoke(configMBeanName, "retrieveConfigurationDisplayData", new Object[0], new String[0]);
            }
        }
        catch (Exception ex) {
            this.mLog.warning(MessageHelper.getMsgString(ex));
            throw new RuntimeException(ex.getMessage());
        }
        return response;
    }

    private MBeanInfo getComponentMBeanInfo() {
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName();
        if (configMBeanName != null) {
            try {
                return this.mEnvCtx.getMBeanServer().getMBeanInfo(configMBeanName);
            }
            catch (JMException jmx) {
                this.mLog.finest(jmx.getMessage());
            }
        }
        return new MBeanInfo(this.getClass().getName(), "Dynamic Component Configuration instance MBean", new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    }

    private ObjectName getComponentConfigurationMBeanName() {
        ObjectName configMBeanName = null;
        ObjectName standardPattern = this.mEnvCtx.getMBeanNames().getCustomComponentMBeanNameFilter(this.mEnvCtx.getPlatformContext().getInstanceName(), "Configuration", this.mComponentName);
        Set<ObjectName> names = this.mEnvCtx.getMBeanServer().queryNames(standardPattern, null);
        if (!names.isEmpty()) {
            if (names.size() > 1) {
                this.mLog.log(Level.FINEST, "More than one MBean matches ObjectName pattern {0}.  {1}", new Object[]{standardPattern, this.convertToString(names)});
            }
            configMBeanName = names.iterator().next();
        } else {
            ObjectName ebiPattern = null;
            try {
                ebiPattern = new ObjectName("com.sun.ebi:ServiceType=Configuration,IdentificationName=" + this.mComponentName + ",*");
            }
            catch (Exception ex) {
                this.mLog.warning(ex.getMessage());
            }
            Set<ObjectName> ebiNames = this.mEnvCtx.getMBeanServer().queryNames(ebiPattern, null);
            if (!ebiNames.isEmpty()) {
                if (ebiNames.size() > 1) {
                    this.mLog.log(Level.FINEST, "More than one MBean matches ObjectName pattern {0}.  {1}", new Object[]{standardPattern, this.convertToString(ebiNames)});
                }
                configMBeanName = ebiNames.iterator().next();
            }
        }
        return configMBeanName;
    }

    private String convertToString(Set set) {
        StringBuffer strBuf = new StringBuffer("[ ");
        if (!set.isEmpty()) {
            Iterator itr = set.iterator();
            while (itr.hasNext()) {
                strBuf.append(itr.next().toString());
                if (itr.hasNext()) {
                    strBuf.append(",  ");
                    continue;
                }
                strBuf.append("  ");
            }
        }
        strBuf.append(" ]");
        return strBuf.toString();
    }

    private MBeanOperationInfo[] merge(MBeanOperationInfo[] a1, MBeanOperationInfo[] a2) {
        int x;
        MBeanOperationInfo[] array = new MBeanOperationInfo[a1.length + a2.length];
        for (x = 0; x < a1.length; ++x) {
            array[x] = a1[x];
        }
        for (x = 0; x < a2.length; ++x) {
            array[x + a1.length] = a2[x];
        }
        return array;
    }

    private void persistAttribute(Attribute attrib) {
        try {
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            String attribValueToPersist = this.encryptCompConfigPasswordField(attrib.getName(), attrib.getValue().toString());
            updater.setComponentAttribute(this.mComponentName, attrib.getName(), attribValueToPersist);
        }
        catch (Exception rex) {
            String msg = this.mTranslator.getString("CCFG_PERSIST_ATTRIBUTE_FAILURE", this.mComponentName, attrib.getName(), rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private void persistAttributes(AttributeList attribs) {
        try {
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            Properties props = new Properties();
            for (Object attrib : attribs) {
                Attribute attribute = (Attribute)attrib;
                String value = attribute.getValue() == null ? "" : attribute.getValue().toString();
                String attribValueToPersist = this.encryptCompConfigPasswordField(attribute.getName(), value);
                props.put(attribute.getName(), attribValueToPersist);
            }
            updater.setComponentAttributes(this.mComponentName, props);
        }
        catch (Exception rex) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("[ ");
            int i = 0;
            for (Object attrib : attribs) {
                strBuf.append(((Attribute)attrib).getName());
                if (++i == attribs.size()) continue;
                strBuf.append(", ");
            }
            strBuf.append(" ]");
            String msg = this.mTranslator.getString("CCFG_PERSIST_ATTRIBUTE_FAILURE", this.mComponentName, strBuf.toString(), rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    protected MBeanAttributeInfo getAttributeInfo(String attribute) {
        MBeanInfo mbeanInfo = this.getMBeanInfo();
        MBeanAttributeInfo[] attribInfos = null;
        MBeanAttributeInfo aInfo = null;
        if (mbeanInfo != null) {
            for (MBeanAttributeInfo attribInfo : attribInfos = mbeanInfo.getAttributes()) {
                if (!attribInfo.getName().equals(attribute)) continue;
                aInfo = attribInfo;
            }
        }
        return aInfo;
    }

    private void addApplicationVariable(CompositeData appVar) throws RegistryException {
        ComponentInfo.Variable[] vars = new ComponentInfo.Variable[1];
        try {
            String appVarValue = (String)appVar.get("value");
            if (PASSWORD.equals((String)appVar.get("type"))) {
                appVarValue = this.mEnvCtx.getPlatformContext().getKeyStoreUtil().encrypt(appVarValue);
            }
            vars[0] = new ComponentInfo.Variable((String)appVar.get("name"), appVarValue, (String)appVar.get("type"));
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            updater.addComponentApplicationVariables(this.mComponentName, vars);
        }
        catch (Exception rex) {
            String msg = this.mTranslator.getString("CCFG_FAILED_ADD_APP_VAR_REG", vars[0].getName(), this.mComponentName, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private void updateApplicationVariable(CompositeData appVar) throws RegistryException {
        ComponentInfo.Variable[] vars = new ComponentInfo.Variable[1];
        try {
            String appVarValue = (String)appVar.get("value");
            if (PASSWORD.equals((String)appVar.get("type"))) {
                appVarValue = this.mEnvCtx.getPlatformContext().getKeyStoreUtil().encrypt(appVarValue);
            }
            vars[0] = new ComponentInfo.Variable((String)appVar.get("name"), appVarValue, (String)appVar.get("type"));
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            updater.updateComponentApplicationVariables(this.mComponentName, vars);
        }
        catch (Exception rex) {
            String msg = this.mTranslator.getString("CCFG_FAILED_UPDATE_APP_VAR_REG", vars[0].getName(), this.mComponentName, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private void removeApplicationVariable(String name) throws RegistryException {
        try {
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            updater.deleteComponentApplicationVariables(this.mComponentName, new String[]{name});
        }
        catch (RegistryException rex) {
            String msg = this.mTranslator.getString("CCFG_FAILED_DELETE_APP_VAR_REG", name, this.mComponentName, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private Registry getRegistry() {
        return (Registry)this.mEnvCtx.getRegistry();
    }

    private boolean operationSupportedCheck(ObjectName mbean, String op, String[] sign) {
        MBeanOperationInfo[] opInfos;
        MBeanInfo mbeanInfo = null;
        boolean found = false;
        try {
            if (this.mEnvCtx.getMBeanServer().isRegistered(mbean)) {
                mbeanInfo = this.mEnvCtx.getMBeanServer().getMBeanInfo(mbean);
            }
        }
        catch (Exception ex) {
            this.mLog.warning(ex.getMessage());
            return found;
        }
        for (MBeanOperationInfo opInfo : opInfos = mbeanInfo.getOperations()) {
            if (!opInfo.getName().equals(op)) continue;
            found = true;
            break;
        }
        if (!found) {
            String errMsg = this.mTranslator.getString("CCFG_UNSUPPORTED_OPERATION", op, mbean.toString());
            throw new UnsupportedOperationException(errMsg);
        }
        return found;
    }

    private void addApplicationConfiguration(CompositeData appConfig) throws RegistryException {
        try {
            Properties cfgProps = this.mCfgHlpr.convertCompositeDataToProperties(appConfig);
            cfgProps = this.encryptPasswordFields(cfgProps);
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            updater.addComponentApplicationConfiguration(this.mComponentName, cfgProps);
        }
        catch (Exception rex) {
            String msg = this.mTranslator.getString("CCFG_FAILED_ADD_APP_CFG_REG", appConfig.get("configurationName"), this.mComponentName, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private void updateApplicationConfiguration(CompositeData appConfig) throws RegistryException {
        try {
            Properties cfgProps = this.mCfgHlpr.convertCompositeDataToProperties(appConfig);
            cfgProps = this.encryptPasswordFields(cfgProps);
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            updater.updateComponentApplicationConfiguration(this.mComponentName, cfgProps);
        }
        catch (Exception rex) {
            String msg = this.mTranslator.getString("CCFG_FAILED_UPDATE_APP_CFG_REG", appConfig.get("configurationName"), this.mComponentName, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private void removeApplicationConfiguration(String name) throws RegistryException {
        try {
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            updater.deleteComponentApplicationConfiguration(this.mComponentName, name);
        }
        catch (RegistryException rex) {
            String msg = this.mTranslator.getString("CCFG_FAILED_DELETE_APP_CFG_REG", name, this.mComponentName, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private TabularData createEmptyAppConfigTable() throws OpenDataException {
        CompositeType appConfigCompositeType = this.queryApplicationConfigurationType();
        TabularDataSupport td = null;
        if (appConfigCompositeType != null) {
            TabularType tt = new TabularType("Applcation Configuration", "Table of Application configurations", appConfigCompositeType, new String[]{"configurationName"});
            td = new TabularDataSupport(tt);
        }
        return td;
    }

    protected TabularData createEmptyAppVarTable() throws OpenDataException {
        return new TabularDataSupport(this.mCfgHlpr.getApplicationVariableTabularType());
    }

    private Properties encryptPasswordFields(Properties cfgProps) throws Exception {
        Document configDoc = this.getConfigDoc();
        Set<Object> cfgNames = cfgProps.keySet();
        for (Object cfgName : cfgNames) {
            if (!this.mCfgHlpr.isPassword((String)cfgName, configDoc)) continue;
            String clearTxt = cfgProps.getProperty((String)cfgName);
            String encrTxt = this.mEnvCtx.getPlatformContext().getKeyStoreUtil().encrypt(clearTxt);
            cfgProps.setProperty((String)cfgName, encrTxt);
        }
        return cfgProps;
    }

    private Properties maskPasswordFields(Properties cfgProps) throws Exception {
        Document configDoc = this.getConfigDoc();
        Set<Object> cfgNames = cfgProps.keySet();
        for (Object cfgName : cfgNames) {
            if (!this.mCfgHlpr.isPassword((String)cfgName, configDoc)) continue;
            cfgProps.setProperty((String)cfgName, MASKED_FIELD_VALUE);
        }
        return cfgProps;
    }

    private String encryptCompConfigPasswordField(String cfgName, String cfgValue) throws Exception {
        Document configDoc = this.getConfigDoc();
        if (this.mCfgHlpr.isPassword(cfgName, configDoc)) {
            String encrTxt = this.mEnvCtx.getPlatformContext().getKeyStoreUtil().encrypt(cfgValue);
            return encrTxt;
        }
        return cfgValue;
    }

    private Properties maskCompConfigPasswordFields(Properties cfgProps) throws Exception {
        Document configDoc = this.getConfigDoc();
        Set<Object> cfgNames = cfgProps.keySet();
        for (Object cfgName : cfgNames) {
            if (!this.mCfgHlpr.isPassword((String)cfgName, configDoc)) continue;
            cfgProps.setProperty((String)cfgName, MASKED_FIELD_VALUE);
        }
        return cfgProps;
    }

    private Document getConfigDoc() throws Exception {
        String xmlConfigData = this.retrieveConfigurationDisplayData();
        Document doc = null;
        if (xmlConfigData != null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader reader = new StringReader(xmlConfigData);
            InputSource ipsrc = new InputSource(reader);
            doc = db.parse(ipsrc);
        }
        return doc;
    }

    protected String getComponentConfigurationNS(String compName) {
        String ns = "";
        Archive compArchive = this.getRegistry().getRepository().getArchive(ArchiveType.COMPONENT, compName);
        if (compArchive != null) {
            ComponentDescriptor descr = new ComponentDescriptor(compArchive.getJbiXml(true));
            ns = descr.getComponentConfigurationNS();
        }
        return ns;
    }

    protected String getComponentConfigurationData(String compName) {
        String xmlStr = null;
        Archive compArchive = this.getRegistry().getRepository().getArchive(ArchiveType.COMPONENT, compName);
        if (compArchive != null) {
            ComponentDescriptor descr = new ComponentDescriptor(compArchive.getJbiXml(true));
            xmlStr = descr.getComponentConfigurationXml();
        }
        return xmlStr;
    }
}

