/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.EndpointInformation;
import com.sun.esb.management.common.data.JavaEEVerifierReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class VerificationDataCreator {
    protected static String[] endpointDataItemNames = new String[]{"EndpointName", "ServiceUnitName", "ComponentName", "Status", "MissingApplicationVariables", "MissingApplicationConfigurations"};
    protected static String[] endpointDataItemDescriptions = new String[]{"Endpoint Name", "Service Unit Name", "Component Name", "Status of the endpoint", "Missing Application Variables", "Missing Application Configurations"};

    private VerificationDataCreator() {
    }

    public static CompositeData createCompositeData(ApplicationVerificationReport report) throws ManagementRemoteException {
        try {
            ArrayList<String> verifierReportItemNames = new ArrayList<String>();
            verifierReportItemNames.add("ServiceAssemblyName");
            verifierReportItemNames.add("ServiceAssemblyDescription");
            verifierReportItemNames.add("NumServiceUnits");
            verifierReportItemNames.add("AllComponentsInstalled");
            verifierReportItemNames.add("MissingComponentsList");
            verifierReportItemNames.add("EndpointInfo");
            verifierReportItemNames.add("TemplateZIPID");
            ArrayList<String> verifierReportItemDescriptions = new ArrayList<String>();
            verifierReportItemDescriptions.add("Name of the Service Assembly");
            verifierReportItemDescriptions.add("Description of the Service Assembly");
            verifierReportItemDescriptions.add("Number of Service Units");
            verifierReportItemDescriptions.add("Are all necessary components installed");
            verifierReportItemDescriptions.add("List of missing components");
            verifierReportItemDescriptions.add("Information about the endpoints");
            verifierReportItemDescriptions.add("Id for the zip file with configuration templates");
            ArrayList<OpenType> verifierReportItemTypes = new ArrayList<OpenType>();
            verifierReportItemTypes.add(SimpleType.STRING);
            verifierReportItemTypes.add(SimpleType.STRING);
            verifierReportItemTypes.add(SimpleType.INTEGER);
            verifierReportItemTypes.add(SimpleType.BOOLEAN);
            verifierReportItemTypes.add(new ArrayType(1, SimpleType.STRING));
            verifierReportItemTypes.add(new ArrayType(1, VerificationDataCreator.getEndpointInfoType()));
            verifierReportItemTypes.add(SimpleType.STRING);
            ArrayList<Object> verifierReportValues = new ArrayList<Object>();
            verifierReportValues.add(report.getServiceAssemblyName());
            verifierReportValues.add(report.getServiceAssemblyDescription());
            verifierReportValues.add(report.getNumberOfServiceUnits());
            verifierReportValues.add(report.getMissingComponentsList().size() == 0);
            verifierReportValues.add(report.getMissingComponentsArray());
            verifierReportValues.add(VerificationDataCreator.getEndpointsInformation(report));
            verifierReportValues.add(report.getTemplateZipId());
            CompositeType javaEEReportType = report.getJavaEEVerifierReportCompositeType();
            if (report.getJavaEEVerifierReports() != null && report.getJavaEEVerifierReports().size() > 0 && javaEEReportType != null) {
                verifierReportItemNames.add("JavaEEVerificationReport");
                verifierReportItemDescriptions.add("Java EE Verification Report");
                verifierReportItemTypes.add(new ArrayType(1, javaEEReportType));
                int i = 0;
                CompositeData[] cDataArray = new CompositeData[report.getJavaEEVerifierReports().size()];
                for (JavaEEVerifierReport verifierReport : report.getJavaEEVerifierReports()) {
                    cDataArray[i++] = verifierReport.getCompositeData();
                }
                verifierReportValues.add(cDataArray);
            }
            CompositeType verifierReportType = new CompositeType("VerifierReportType", "Type of the verification report", verifierReportItemNames.toArray(new String[0]), verifierReportItemDescriptions.toArray(new String[0]), verifierReportItemTypes.toArray(new OpenType[0]));
            return new CompositeDataSupport(verifierReportType, verifierReportItemNames.toArray(new String[0]), verifierReportValues.toArray(new Object[0]));
        }
        catch (OpenDataException ode) {
            throw new ManagementRemoteException(ode.getMessage());
        }
    }

    protected static CompositeData[] getEndpointsInformation(ApplicationVerificationReport report) throws ManagementRemoteException {
        HashMap<String, EndpointInformation> endpointInfoMap = null;
        CompositeData[] endpointArray = null;
        try {
            OpenType[] endpointDataItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)};
            CompositeType endpointInfoType = new CompositeType("EndpointInfoType", "Provides information about an endpoint", endpointDataItemNames, endpointDataItemDescriptions, endpointDataItemTypes);
            endpointInfoMap = new HashMap<String, EndpointInformation>();
            List<EndpointInformation> endpointInfoList = report.getEndpointInformationList();
            for (EndpointInformation info : endpointInfoList) {
                if (info == null) continue;
                endpointInfoMap.put(info.getEndpointName(), info);
            }
            endpointArray = new CompositeData[endpointInfoMap.keySet().size()];
            int counter = 0;
            for (Object key : endpointInfoMap.keySet()) {
                EndpointInformation info = (EndpointInformation)endpointInfoMap.get(key);
                Object[] endpointValues = new Object[]{info.getEndpointName(), info.getServiceUnitName(), info.getComponentName(), info.getStatus(), info.getMissingApplicationVariables(), info.getMissingApplicationConfigurations()};
                CompositeDataSupport endpointData = new CompositeDataSupport(endpointInfoType, endpointDataItemNames, endpointValues);
                endpointArray[counter++] = endpointData;
            }
        }
        catch (OpenDataException ode) {
            throw new ManagementRemoteException(ode.getMessage());
        }
        return endpointArray;
    }

    protected static CompositeType getEndpointInfoType() throws ManagementRemoteException {
        try {
            OpenType[] endpointDataItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)};
            return new CompositeType("EndpointInfoType", "Provides information about an endpoint", endpointDataItemNames, endpointDataItemDescriptions, endpointDataItemTypes);
        }
        catch (OpenDataException e) {
            throw new ManagementRemoteException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/verification/ApplicationVerificationReport.xml";
        try {
            ApplicationVerificationReport report = ApplicationVerificationReportReader.parseFromFile(uri);
            System.out.println(report.getDisplayString());
            CompositeData data = VerificationDataCreator.createCompositeData(report);
            System.out.println(data);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ManagementRemoteException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

