/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Response;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.ServiceAssemblyService;
import net.openesb.model.api.ServiceAssembly;
import net.openesb.model.api.manage.Task;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.ServiceAssemblyResource;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/assemblies")
@RequiresAuthentication
public class ServiceAssembliesResource
extends AbstractResource {
    @Inject
    private ServiceAssemblyService serviceAssemblyService;
    @Inject
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    public Set<ServiceAssembly> listServiceAssemblies(@QueryParam(value="state") String state, @QueryParam(value="component") String componentName) throws ManagementException {
        TreeSet<ServiceAssembly> assemblies = new TreeSet<ServiceAssembly>(new Comparator<ServiceAssembly>(){

            @Override
            public int compare(ServiceAssembly ass1, ServiceAssembly ass2) {
                return ass1.getName().compareTo(ass2.getName());
            }
        });
        assemblies.addAll(this.serviceAssemblyService.findServiceAssemblies(state, componentName));
        return assemblies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public Response deploy(@FormDataParam(value="assembly") InputStream is, @FormDataParam(value="assembly") FormDataContentDisposition fileDisposition) throws ManagementException {
        File assemblyArchive = null;
        try {
            assemblyArchive = this.createTemporaryFile(is, fileDisposition.getFileName());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "I/O errors while uploading the assembly archive.", e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        }
        if (assemblyArchive != null) {
            Task actionResult = this.serviceAssemblyService.deploy(assemblyArchive.toURI().toString());
            return Response.ok((Object)actionResult, (String)"application/json").build();
        }
        return Response.serverError().build();
    }

    @Path(value="{assembly}")
    public ServiceAssemblyResource getServiceAssemblyResource(@PathParam(value="assembly") String assemblyName) {
        return (ServiceAssemblyResource)this.resourceContext.initResource((Object)new ServiceAssemblyResource(assemblyName));
    }
}

