/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.openesb.management.api.EndpointService;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.StatisticsService;
import net.openesb.model.api.Endpoint;
import net.openesb.model.api.metric.Metric;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;

@RequiresAuthentication
public class EndpointsResource
extends AbstractResource {
    @Inject
    private EndpointService endpointService;
    @Inject
    private StatisticsService statisticsService;
    private final String owner;

    public EndpointsResource() {
        this.owner = null;
    }

    public EndpointsResource(String ownerId) {
        this.owner = ownerId;
    }

    @GET
    @Produces(value={"application/json"})
    public Set<Endpoint> findAllEndpoints() throws ManagementException {
        Set endpoints = this.endpointService.findEndpoints(this.owner, true);
        endpoints.addAll(this.endpointService.findEndpoints(this.owner, false));
        return endpoints;
    }

    @GET
    @Path(value="out")
    @Produces(value={"application/json"})
    public Set<Endpoint> findProvidingEndpoints() throws ManagementException {
        return this.endpointService.findEndpoints(this.owner, false);
    }

    @GET
    @Path(value="in")
    @Produces(value={"application/json"})
    public Set<Endpoint> findConsumingEndpoints() throws ManagementException {
        return this.endpointService.findEndpoints(this.owner, true);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Map<String, Metric> getStatistics(@FormParam(value="endpoint") String endpointName) throws ManagementException {
        return this.statisticsService.getEndpointStatistics(endpointName);
    }
}

