/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import net.openesb.management.api.ConfigurationService;
import net.openesb.management.api.ManagementException;
import net.openesb.model.api.ApplicationVariable;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;

@RequiresAuthentication
public class ComponentApplicationVariableResource
extends AbstractResource {
    @Inject
    private ConfigurationService configurationService;
    private final String componentName;

    public ComponentApplicationVariableResource(String componentName) {
        this.componentName = componentName;
    }

    @GET
    @Produces(value={"application/json"})
    public Set<ApplicationVariable> getApplicationVariables() throws ManagementException {
        TreeSet<ApplicationVariable> variables = new TreeSet<ApplicationVariable>(new Comparator<ApplicationVariable>(){

            @Override
            public int compare(ApplicationVariable var1, ApplicationVariable var2) {
                return var1.getName().compareTo(var2.getName());
            }
        });
        variables.addAll(this.configurationService.getApplicationVariables(this.componentName));
        return variables;
    }

    @DELETE
    @Produces(value={"application/json"})
    public Set<ApplicationVariable> deleteApplicationVariables(@QueryParam(value="name") String name) throws ManagementException {
        this.configurationService.deleteApplicationVariables(this.componentName, new String[]{name});
        return this.getApplicationVariables();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Set<ApplicationVariable> updateApplicationVariable(Set<ApplicationVariable> variables) throws ManagementException {
        this.configurationService.updateApplicationVariable(this.componentName, variables);
        return this.getApplicationVariables();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Set<ApplicationVariable> addApplicationVariable(Set<ApplicationVariable> variables) throws ManagementException {
        this.configurationService.addApplicationVariable(this.componentName, variables);
        return this.getApplicationVariables();
    }
}

