/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.command.utils.OutputUtils;
import net.openesb.model.api.SharedLibrary;
import net.openesb.sdk.model.GetSharedLibraryDescriptorRequest;
import net.openesb.sdk.model.GetSharedLibraryRequest;

@Parameters(separators="=", commandNames={"show-jbi-shared-library"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.show-jbi-shared-library.descr")
public class ShowSharedLibraryCommand
extends AbstractCommand {
    @Parameter(descriptionKey="cli.show-jbi-shared-library.param.sharedlibraryname", required=true, arity=1)
    private List<String> sharedLibraryNames;
    @Parameter(names={"--descriptor"}, descriptionKey="cli.show-jbi-shared-library.param.descriptor")
    private boolean descriptor = false;

    @Override
    protected void executeRequest() throws Exception {
        String sharedLibraryName = this.sharedLibraryNames.iterator().next();
        if (sharedLibraryName != null) {
            GetSharedLibraryRequest request = new GetSharedLibraryRequest(sharedLibraryName);
            SharedLibrary sharedLibrary = this.getClient().getSharedLibrary(request);
            String sharedLibraryVersion = sharedLibrary.getVersion();
            String sharedLibraryBuildNumber = sharedLibrary.getBuildNumber();
            String sharedLibraryDescription = OutputUtils.multiLineFormat(sharedLibrary.getDescription(), 70, 14).trim();
            String header = this.getLocalizedString("cli.sharedlibrary.header");
            this.printMessage(header);
            this.printMessage(OutputUtils.createFillString('-', header.length()));
            this.printMessage(this.getLocalizedString("cli.sharedlibrary.name", new Object[]{sharedLibraryName}));
            this.printMessage(this.getLocalizedString("cli.sharedlibrary.version", new Object[]{sharedLibraryVersion}));
            this.printMessage(this.getLocalizedString("cli.sharedlibrary.buildnumber", new Object[]{sharedLibraryBuildNumber}));
            this.printMessage(this.getLocalizedString("cli.sharedlibrary.description", new Object[]{sharedLibraryDescription}));
            if (this.descriptor) {
                this.displayOptionHeader("cli.component.descriptor.header", 0);
                GetSharedLibraryDescriptorRequest requestDescr = new GetSharedLibraryDescriptorRequest(sharedLibraryName);
                String result = this.getClient().getSharedLibraryDescriptor(requestDescr);
                this.displayDescriptor(result);
            }
        }
    }
}

