/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.model.api.ComponentConfiguration;
import net.openesb.sdk.model.SetComponentConfigurationRequest;

@Parameters(commandNames={"set-jbi-component-configuration"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.set-jbi-component-configuration.descr")
public class SetComponentConfigurationCommand
extends AbstractCommand {
    @Parameter(names={"--component"}, descriptionKey="cli.set-jbi-component-configuration.param.component", required=true, arity=1)
    private String componentName;
    @Parameter(descriptionKey="cli.set-jbi-component-configuration.param.value", required=true)
    private List<String> configurations;

    @Override
    protected void executeRequest() throws Exception {
        String values = this.configurations.get(0);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(values));
        }
        catch (IOException e) {
            properties = this.createPropertiesParam(values);
        }
        SetComponentConfigurationRequest request = new SetComponentConfigurationRequest(this.componentName);
        for (Map.Entry<Object, Object> config : properties.entrySet()) {
            String value = (String)config.getValue();
            Object objValue = value;
            if (this.isBoolean(value)) {
                objValue = Boolean.valueOf(value);
            } else if (this.isInteger(value)) {
                objValue = Integer.parseInt(value);
            }
            request.addComponentConfiguration(new ComponentConfiguration((String)config.getKey(), objValue));
        }
        this.getClient().setComponentConfigurations(request);
    }

    private boolean isBoolean(String value) {
        return value != null && (value.equalsIgnoreCase(Boolean.TRUE.toString()) || value.equalsIgnoreCase(Boolean.FALSE.toString()));
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

