/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jdbc;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class JdbcTransactionalResource
extends XATransactionalResource {
    private XADataSource xads_;
    private XAConnection conn_;
    private String user_;
    private String password_;

    public JdbcTransactionalResource(String serverName, XADataSource xads) {
        super(serverName);
        this.xads_ = xads;
        if (this.xads_ == null) {
            throw new RuntimeException("Null XADataSource argument");
        }
        this.conn_ = null;
    }

    public JdbcTransactionalResource(String serverName, XADataSource xads, XidFactory factory) {
        super(serverName, factory);
        this.xads_ = xads;
        this.conn_ = null;
    }

    private String getUser() {
        String ret = "";
        if (this.user_ != null) {
            ret = this.user_;
        }
        return ret;
    }

    private String getPassword() {
        String ret = "";
        if (this.password_ != null) {
            ret = this.password_;
        }
        return ret;
    }

    protected synchronized XAResource refreshXAConnection() throws ResourceException {
        XAResource res = null;
        if (this.conn_ != null) {
            try {
                this.conn_.close();
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        try {
            this.conn_ = this.createXAConnection();
            if (this.conn_ != null) {
                res = this.conn_.getXAResource();
            }
        }
        catch (SQLException sql) {
            Stack<SQLException> errors = new Stack<SQLException>();
            errors.push(sql);
            throw new ResourceException("Error in getting XA resource", errors);
        }
        return res;
    }

    public void setUser(String user) {
        this.user_ = user;
    }

    public void setPassword(String password) {
        this.password_ = password;
    }

    public void close() throws ResourceException {
        super.close();
        try {
            if (this.conn_ != null) {
                this.conn_.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private XAConnection createXAConnection() {
        XAConnection conn = null;
        try {
            conn = "".equals(this.getUser()) ? this.xads_.getXAConnection() : this.xads_.getXAConnection(this.getUser(), this.getPassword());
        }
        catch (SQLException noConnection) {
            conn = null;
        }
        return conn;
    }
}

