/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final char FIELD_SEPARATOR = ' ';
    private static final char NVPAIR_SEPARATOR = ';';
    private static final char NV_SEPARATOR = '=';
    private static final char SEPARATOR_BEGIN_MARKER = '[';
    private static final char SEPARATOR_END_MARKER = ']';
    private static final char SEPARATOR2_BEGIN_MARKER = '(';
    private static final char SEPARATOR2_END_MARKER = ')';
    private Date date = new Date();

    @Override
    public String format(LogRecord record) {
        StringBuilder recordBuffer = new StringBuilder();
        this.date.setTime(record.getMillis());
        recordBuffer.append(dateFormatter.format(this.date));
        recordBuffer.append(' ');
        recordBuffer.append(record.getLevel()).append(' ');
        recordBuffer.append('[').append(record.getLoggerName()).append(']').append(' ');
        recordBuffer.append('(').append(Thread.currentThread().getName()).append(')');
        Level level = record.getLevel();
        if (level.intValue() <= Level.FINE.intValue()) {
            recordBuffer.append("ClassName").append('=');
            recordBuffer.append(record.getSourceClassName());
            recordBuffer.append(';');
            recordBuffer.append("MethodName").append('=');
            recordBuffer.append(record.getSourceMethodName());
            recordBuffer.append(';');
        }
        recordBuffer.append(' ');
        recordBuffer.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            recordBuffer.append(LINE_SEPARATOR);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            recordBuffer.append(sw.toString());
        }
        recordBuffer.append(LINE_SEPARATOR);
        return recordBuffer.toString();
    }
}

