/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.naming.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import net.openesb.standalone.naming.jaxb.Context;
import net.openesb.standalone.naming.jaxb.DataSourcePoolProperties;
import net.openesb.standalone.naming.jaxb.JDBCResource;
import net.openesb.standalone.naming.jndi.AbstractContextFactory;
import net.openesb.standalone.naming.jndi.ds.DataSourcePoolFactory;
import net.openesb.standalone.naming.jndi.ds.tomcat.TomcatDataSourcePoolFactory;
import net.openesb.standalone.utils.I18NBundle;

public class InitialContexFactoryImpl
extends AbstractContextFactory
implements InitialContextFactory {
    private static final Logger LOG = Logger.getLogger(InitialContexFactoryImpl.class.getName());
    public static final String DATASOURCE_TYPE = "Datasource";
    public static final String XADATASOURCE_TYPE = "XADatasource";
    private final Map<String, DataSourcePoolProperties> mDSPMap = new HashMap<String, DataSourcePoolProperties>();
    private final DataSourcePoolFactory mDSPFactory = new TomcatDataSourcePoolFactory();

    @Override
    public javax.naming.Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        javax.naming.Context namingContext = this.getContext();
        String urlValue = (String)environment.get("java.naming.provider.url");
        if (urlValue == null) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("NAMING_CONTEXT_NO_CONTEXT_URL"));
        } else {
            Set<Context> contexts = this.loadContexts(urlValue);
            for (Context context : contexts) {
                try {
                    this.populate(context, namingContext);
                }
                catch (NamingException ne) {
                    LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("NAMING_CONTEXT_BIND_FAILURE"));
                }
            }
        }
        return namingContext;
    }

    private javax.naming.Context getContext() throws NamingException {
        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
        return new InitialContext();
    }

    private void populate(Context context, javax.naming.Context namingContext) throws NamingException {
        List<DataSourcePoolProperties> dataSourcePoolList = context.getDataSourcePoolProperties();
        int listSize = dataSourcePoolList.size();
        LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("number.dataSourcePoolProperties.found", listSize));
        for (DataSourcePoolProperties dspComplexType : dataSourcePoolList) {
            this.mDSPMap.put(dspComplexType.getDbConnectorName(), dspComplexType);
            LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("datasourcepoolproperties.found.in.context", dspComplexType.getDbConnectorName()));
        }
        List<JDBCResource> jdbcResourceList = context.getJdbcResources();
        listSize = jdbcResourceList.size();
        LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("number.jdbcResource.declaration.found", listSize));
        for (JDBCResource jdbcResource : jdbcResourceList) {
            String jndiName = jdbcResource.getJndiName();
            LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("in.process"));
            try {
                namingContext.lookup(jndiName);
                LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("jndi.value.already.defined", jndiName));
            }
            catch (NamingException ex) {
                HashMap<String, DataSource> datasourceMap = new HashMap<String, DataSource>();
                String dbConnectorName = jdbcResource.getDbConnectorName();
                if (datasourceMap.containsKey(dbConnectorName)) {
                    if (datasourceMap.get(dbConnectorName) instanceof XADataSource) {
                        namingContext.rebind(jndiName, (Object)((XADataSource)datasourceMap.get(dbConnectorName)));
                        continue;
                    }
                    namingContext.rebind(jndiName, datasourceMap.get(dbConnectorName));
                    continue;
                }
                DataSourcePoolProperties dspProperties = this.mDSPMap.get(dbConnectorName);
                if (dspProperties == null) continue;
                if (dspProperties.getResourceType().equals(DATASOURCE_TYPE)) {
                    LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("datasource.in.process", jndiName));
                    DataSource dataSource = this.mDSPFactory.getDataSource(dspProperties);
                    if (null == dataSource) continue;
                    datasourceMap.put(dbConnectorName, dataSource);
                    try {
                        namingContext.rebind(jndiName, (Object)dataSource);
                    }
                    catch (NamingException ex2) {
                        namingContext.bind(jndiName, (Object)dataSource);
                    }
                    LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("datasource.processed.bind.success", jndiName));
                    continue;
                }
                if (dspProperties.getResourceType().equals(XADATASOURCE_TYPE)) {
                    LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("xadatasource.in.process", jndiName));
                    XADataSource xaDataSource = this.mDSPFactory.getXADataSource(dspProperties);
                    if (null == xaDataSource) continue;
                    datasourceMap.put(dbConnectorName, (DataSource)((Object)xaDataSource));
                    namingContext.rebind(jndiName, (Object)xaDataSource);
                    LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("xadatasource.processed.bind.success", jndiName));
                    continue;
                }
                LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("bad.resource.type", dspProperties.getResourceType(), dspProperties.getDatabaseName()));
            }
        }
    }
}

