/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.inject;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.openesb.standalone.plugins.PluginsModule;

public class ModulesBuilder
implements Iterable<Module> {
    private final List<Module> modules = new ArrayList<Module>();

    public ModulesBuilder add(Module ... modules) {
        for (Module module : modules) {
            this.add(module);
        }
        return this;
    }

    public ModulesBuilder add(Module module) {
        this.modules.add(module);
        if (module instanceof PluginsModule) {
            Iterable<? extends Module> plugins = ((PluginsModule)module).childModules();
            for (Module module2 : plugins) {
                this.add(module2);
            }
        }
        return this;
    }

    @Override
    public Iterator<Module> iterator() {
        return this.modules.iterator();
    }

    public Injector createInjector() {
        Injector injector = Guice.createInjector(this.modules);
        return injector;
    }
}

