/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.StatisticsType;
import com.sun.jbi.ui.ant.util.TimeUtil;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIStatisticsItemNames;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.apache.tools.ant.BuildException;

public class JbiListStatisticsTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.statistics.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.statistics.failed";
    private static final String COMPONENT_STARTED_STATE = "Started";
    private static final String PROVIDER_ENDPOINT_TYPE_NAME = "ProviderEndpointStats";
    private static final String COMSUMER_ENDPOINT_TYPE_NAME = "ConsumerEndpointStats";
    private String mStatisticsType;
    private List mComponentList;
    private List mServiceAssemblyList;
    private List mEndpointList;

    public String getType() {
        return this.mStatisticsType;
    }

    public void setType(String statisticsType) {
        this.mStatisticsType = statisticsType;
    }

    public List getComponentList() {
        if (this.mComponentList == null) {
            this.mComponentList = new ArrayList();
        }
        return this.mComponentList;
    }

    public Component createComponent() {
        Component component = new Component();
        this.getComponentList().add(component);
        return component;
    }

    public List getServiceAssemblyList() {
        if (this.mServiceAssemblyList == null) {
            this.mServiceAssemblyList = new ArrayList();
        }
        return this.mServiceAssemblyList;
    }

    public ServiceAssembly createServiceAssembly() {
        ServiceAssembly sa = new ServiceAssembly();
        this.getServiceAssemblyList().add(sa);
        return sa;
    }

    public List getEndpointList() {
        if (this.mEndpointList == null) {
            this.mEndpointList = new ArrayList();
        }
        return this.mEndpointList;
    }

    public Endpoint createEndpoint() {
        Endpoint endpoint = new Endpoint();
        this.getEndpointList().add(endpoint);
        return endpoint;
    }

    @Override
    public void executeTask() throws BuildException {
        String target = this.getValidTarget();
        String theTypeStr = this.getType();
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter msgWriter = new PrintWriter(stringWriter);
            StatisticsType theType = null;
            try {
                theType = StatisticsType.valueOfString(theTypeStr);
            }
            catch (IllegalArgumentException exp) {
                String errMsg = null;
                errMsg = theTypeStr == null || theTypeStr.compareTo("") == 0 ? this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.statistics.error.empty.type", null) : this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.statistics.error.wrong.type", new String[]{theTypeStr});
                throw new Exception(errMsg);
            }
            catch (NullPointerException exp) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.statistics.error.empty.type", new String[]{theTypeStr});
                throw new Exception(errMsg);
            }
            TabularData result = null;
            switch (theType) {
                case FRAMEWORK: {
                    this.logDebug("Statistics for framework, the target is " + target);
                    result = this.getJBIAdminCommands().getFrameworkStats(target);
                    this.logDebug("Statistics for framework, the target is " + target);
                    this.printStatsForFramework(result, target, msgWriter);
                    break;
                }
                case COMPONENT: {
                    this.logDebug("Statistics for components, the target is " + target);
                    this.getStatsForComponentsAndPrintStats(this.getComponentList(), target, msgWriter, stringWriter);
                    break;
                }
                case SERVICEASSEMBLY: {
                    this.logDebug("Statistics for service assemblies, the target is " + target);
                    this.getStatsForServiceAssemblies(this.getServiceAssemblyList(), target, msgWriter, stringWriter);
                    break;
                }
                case ENDPOINT: {
                    this.logDebug("Statistics for endpoints, the target is " + target);
                    this.getStatsForEndpointsAndPrintStats(this.getEndpointList(), target, msgWriter, stringWriter);
                    break;
                }
                case NMR: {
                    this.logDebug("Statistics for NMR, the target is " + target);
                    result = this.getJBIAdminCommands().getNMRStats(target);
                    this.logDebug("Statistics for NMR, the result is " + result);
                    this.printStatsForNMR(result, target, msgWriter);
                    break;
                }
                case ALL: {
                    this.logDebug("Statistics for NMR, the target is " + target);
                    result = this.getJBIAdminCommands().getNMRStats(target);
                    this.logDebug("Statistics for NMR, the result is " + result);
                    this.printStatsForNMR(result, target, msgWriter);
                    this.logDebug("Statistics for framework, the target is " + target);
                    result = this.getJBIAdminCommands().getFrameworkStats(target);
                    this.logDebug("Statistics for framework, the target is " + target);
                    this.printStatsForFramework(result, target, msgWriter);
                    stringWriter.flush();
                    this.logDebug("Statistics for components, the target is " + target);
                    this.getStatsForComponentsAndPrintStats(this.getComponentList(), target, msgWriter, stringWriter);
                    this.logDebug("Statistics for service assemblies, the target is " + target);
                    this.getStatsForServiceAssemblies(this.getServiceAssemblyList(), target, msgWriter, stringWriter);
                    this.logDebug("Statistics for endpoints, the target is " + target);
                    this.getStatsForEndpointsAndPrintStats(this.getEndpointList(), target, msgWriter, stringWriter);
                    stringWriter.flush();
                    break;
                }
                default: {
                    String errMsg = null;
                    errMsg = theTypeStr == null || theTypeStr.compareTo("") == 0 ? this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.statistics.error.empty.type", new String[]{theTypeStr}) : this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.statistics.error.wrong.type", null);
                    throw new Exception(errMsg);
                }
            }
            msgWriter.close();
            this.printMessage(stringWriter.getBuffer().toString());
            stringWriter.close();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void printStatsForFramework(TabularData result, String target, PrintWriter msgWriter) {
        String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.framework.info.header", (Object[])new String[]{target});
        String headerSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.header.separator");
        String pageSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.separator");
        String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.framework.info.empty");
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (result == null || result.size() == 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
            return;
        }
        for (CompositeData compData : result.values()) {
            String instanceName = (String)compData.get(JBIStatisticsItemNames.INSTANCE_NAME);
            Long startupTime = (Long)compData.get(JBIStatisticsItemNames.FRAMEWORK_STARTUP_TIME);
            Long upTime = (Long)compData.get(JBIStatisticsItemNames.FRAMEWORK_UPTIME);
            startupTime = startupTime != null ? startupTime : 0L;
            upTime = upTime != null ? upTime : 0L;
            String instanceNameLine = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.framework.instance.name", (Object[])new String[]{instanceName});
            String formatString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.framework.up.time");
            TimeUtil timeUtil = new TimeUtil(upTime);
            String upTimeLine = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.framework.up.time", (Object[])new String[]{upTime.toString()});
            String startupTimeLine = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.framework.startup.time", (Object[])new String[]{startupTime.toString()});
            msgWriter.println(instanceNameLine);
            msgWriter.println(pageSeparator);
            msgWriter.format(formatString + "\n", timeUtil.getDays(), timeUtil.getHours(), timeUtil.getMins(), timeUtil.getSecs());
            msgWriter.println(startupTimeLine);
            msgWriter.println("");
        }
    }

    private void printStatsForComponent(String compName, TabularData result, String target, PrintWriter msgWriter, String pageSeparator, Boolean jUnitFlag) {
        if (compName == null) {
            return;
        }
        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.component.name", (Object[])new String[]{compName}));
        msgWriter.println(pageSeparator);
        if (result == null || result.values() == null || result.values().size() == 0) {
            String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.component.info.nostats");
            msgWriter.println(emptyResult);
            msgWriter.println("");
            msgWriter.println("");
            return;
        }
        Collection<?> collect = result.values();
        for (CompositeData compData : collect) {
            CompositeType compType = compData.getCompositeType();
            Set<String> compItemSet = compType.keySet();
            String instanceName = "";
            if (compItemSet.contains("ComponentUpTime (ms)")) {
                Long componentUpTime = (Long)compData.get("ComponentUpTime (ms)");
                String formatString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.component.up.time");
                TimeUtil timeUtil = new TimeUtil(componentUpTime);
                msgWriter.format(formatString + "\n", timeUtil.getDays(), timeUtil.getHours(), timeUtil.getMins(), timeUtil.getSecs());
            }
            if (compItemSet.contains("NumActivatedEndpoints")) {
                Long numActivatedEndpoints = (Long)compData.get("NumActivatedEndpoints");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.activated.endpoints", (Object[])new String[]{numActivatedEndpoints != null ? numActivatedEndpoints.toString() : ""}));
            }
            if (compItemSet.contains("NumReceivedRequests")) {
                Long numReceivedRequests = (Long)compData.get("NumReceivedRequests");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.requests", (Object[])new String[]{numReceivedRequests != null ? numReceivedRequests.toString() : ""}));
            }
            if (compItemSet.contains("NumSentRequests")) {
                Long numSentRequests = (Long)compData.get("NumSentRequests");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.requests", (Object[])new String[]{numSentRequests != null ? numSentRequests.toString() : ""}));
            }
            if (compItemSet.contains("NumReceivedReplies")) {
                Long numReceivedReplies = (Long)compData.get("NumReceivedReplies");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.replies", (Object[])new String[]{numReceivedReplies != null ? numReceivedReplies.toString() : ""}));
            }
            if (compItemSet.contains("NumSentReplies")) {
                Long numSentReplies = (Long)compData.get("NumSentReplies");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.replies", (Object[])new String[]{numSentReplies != null ? numSentReplies.toString() : ""}));
            }
            if (compItemSet.contains("NumReceivedDONEs")) {
                Long numReceivedDONEs = (Long)compData.get("NumReceivedDONEs");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.dones", (Object[])new String[]{numReceivedDONEs != null ? numReceivedDONEs.toString() : ""}));
            }
            if (compItemSet.contains("NumSentDONEs")) {
                Long numSentDONEs = (Long)compData.get("NumSentDONEs");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.dones", (Object[])new String[]{numSentDONEs != null ? numSentDONEs.toString() : ""}));
            }
            if (compItemSet.contains("NumReceivedFaults")) {
                Long numReceivedFaults = (Long)compData.get("NumReceivedFaults");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.faults", (Object[])new String[]{numReceivedFaults != null ? numReceivedFaults.toString() : ""}));
            }
            if (compItemSet.contains("NumSentFaults")) {
                Long numSentFaults = (Long)compData.get("NumSentFaults");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.faults", (Object[])new String[]{numSentFaults != null ? numSentFaults.toString() : ""}));
            }
            if (compItemSet.contains("NumReceivedErrors")) {
                Long numReceivedErrors = (Long)compData.get("NumReceivedErrors");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.errors", (Object[])new String[]{numReceivedErrors != null ? numReceivedErrors.toString() : ""}));
            }
            if (compItemSet.contains("NumSentErrors")) {
                Long numSentErrors = (Long)compData.get("NumSentErrors");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.errors", (Object[])new String[]{numSentErrors != null ? numSentErrors.toString() : ""}));
            }
            if (compItemSet.contains("NumCompletedExchanges")) {
                Long numCompletedExchanges = (Long)compData.get("NumCompletedExchanges");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.completed.exchanges", (Object[])new String[]{numCompletedExchanges != null ? numCompletedExchanges.toString() : ""}));
            }
            if (compItemSet.contains("NumActiveExchanges")) {
                Long numActiveExchanges = (Long)compData.get("NumActiveExchanges");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.active.exchanges", (Object[])new String[]{numActiveExchanges != null ? numActiveExchanges.toString() : ""}));
            }
            if (compItemSet.contains("NumErrorExchanges")) {
                Long numErrorExchanges = (Long)compData.get("NumErrorExchanges");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.error.exchanges", (Object[])new String[]{numErrorExchanges != null ? numErrorExchanges.toString() : ""}));
            }
            msgWriter.println("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.exchanges.statistics", null) + "\n");
            String valueNotAvailable = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.value.not.available", null);
            if (!compItemSet.contains("MessageExchangeNMRTime Avg (ns)") && !jUnitFlag.booleanValue()) {
                String msgString;
                if (!this.getMsgSvcTimingStatisticsEnabledFlag(target)) {
                    msgString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.timing.disabled.msg");
                    msgWriter.println("  " + msgString);
                } else {
                    msgString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.timing.data.not.available");
                    msgWriter.println("  " + msgString);
                }
            } else {
                if (compItemSet.contains("MessageExchangeResponseTime Avg (ns)")) {
                    Long mepResponseTime = (Long)compData.get("MessageExchangeResponseTime Avg (ns)");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.response.time", (Object[])new String[]{mepResponseTime == null ? valueNotAvailable : mepResponseTime.toString()}));
                }
                if (compItemSet.contains("MessageExchangeComponentTime Avg (ns)")) {
                    Long mepComponentTime = (Long)compData.get("MessageExchangeComponentTime Avg (ns)");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.component.time", (Object[])new String[]{instanceName, mepComponentTime == null ? valueNotAvailable : mepComponentTime.toString()}));
                }
                if (compItemSet.contains("MessageExchangeDeliveryTime Avg (ns)")) {
                    Long mepDeliveryChannelTime = (Long)compData.get("MessageExchangeDeliveryTime Avg (ns)");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.delivery.channel.time", (Object[])new String[]{mepDeliveryChannelTime == null ? valueNotAvailable : mepDeliveryChannelTime.toString()}));
                }
                if (compItemSet.contains("MessageExchangeNMRTime Avg (ns)")) {
                    Long mepMessageServiceTime = (Long)compData.get("MessageExchangeNMRTime Avg (ns)");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.message.service.time", (Object[])new String[]{mepMessageServiceTime == null ? valueNotAvailable : mepMessageServiceTime.toString()}));
                }
                if (compItemSet.contains("MessageExchangeStatusTime Avg (ns)")) {
                    Long mepStatusTime = (Long)compData.get("MessageExchangeStatusTime Avg (ns)");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.status.time", (Object[])new String[]{mepStatusTime == null ? valueNotAvailable : mepStatusTime.toString()}));
                }
            }
            if (compItemSet.contains("ComponentExtensionStats")) {
                msgWriter.println("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.provided.statistics", null) + "\n");
                CompositeData componentExtensionStats = (CompositeData)compData.get("ComponentExtensionStats");
                if (componentExtensionStats != null) {
                    this.printCompositeDataRecursively(componentExtensionStats, msgWriter, "\t");
                }
            }
            msgWriter.println("");
        }
        msgWriter.println("");
    }

    private void printStatsForServiceAssembly(TabularData result, String target, PrintWriter msgWriter, String pageSeparator) {
        String valueNotAvailable = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.value.not.available", null);
        Collection<?> collect = result.values();
        for (CompositeData saCompData : collect) {
            CompositeType saCompType = saCompData.getCompositeType();
            Set<String> saCompItemSet = saCompType.keySet();
            if (saCompItemSet.contains(JBIStatisticsItemNames.SERVICE_ASSEMBLY_NAME)) {
                String saName = (String)saCompData.get(JBIStatisticsItemNames.SERVICE_ASSEMBLY_NAME);
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.name", (Object[])new String[]{saName}));
                msgWriter.println(pageSeparator);
            }
            if (saCompItemSet.contains(JBIStatisticsItemNames.SERVICE_ASSEMBLY_LAST_STARTUP_TIME)) {
                Date saLastStartupTime = (Date)saCompData.get(JBIStatisticsItemNames.SERVICE_ASSEMBLY_LAST_STARTUP_TIME);
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.last.startup.time", (Object[])new String[]{saLastStartupTime != null ? saLastStartupTime.toString() : ""}));
            }
            if (saCompItemSet.contains("ShutdownTime Avg (ms)")) {
                Long saShutdownTime = (Long)saCompData.get("ShutdownTime Avg (ms)");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.shutdown.time", (Object[])new String[]{saShutdownTime == null ? valueNotAvailable : saShutdownTime.toString()}));
            }
            if (saCompItemSet.contains("StartupTime Avg (ms)")) {
                Long saStartupTime = (Long)saCompData.get("StartupTime Avg (ms)");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.startup.time", (Object[])new String[]{saStartupTime == null ? valueNotAvailable : saStartupTime.toString()}));
            }
            if (saCompItemSet.contains("StopTime Avg (ms)")) {
                Long saStopTime = (Long)saCompData.get("StopTime Avg (ms)");
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.stop.time", (Object[])new String[]{saStopTime == null ? valueNotAvailable : saStopTime.toString()}));
            }
            msgWriter.println("");
            String tab = "\t";
            if (saCompItemSet.contains("ServiceUnitStatistics")) {
                CompositeData[] suStatistics = (CompositeData[])saCompData.get("ServiceUnitStatistics");
                for (int i = 0; i < suStatistics.length; ++i) {
                    CompositeData suCompData = suStatistics[i];
                    CompositeType suCompType = suCompData.getCompositeType();
                    Set<String> suCompItemSet = suCompType.keySet();
                    if (suCompItemSet.contains(JBIStatisticsItemNames.SERVICE_UNIT_NAME)) {
                        String suName = (String)suCompData.get(JBIStatisticsItemNames.SERVICE_UNIT_NAME);
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.su.name", (Object[])new String[]{suName}));
                    }
                    if (suCompItemSet.contains(JBIStatisticsItemNames.SERVICE_UNIT_SHUTDOWN_TIME)) {
                        Long suShutdownTime = (Long)suCompData.get(JBIStatisticsItemNames.SERVICE_UNIT_SHUTDOWN_TIME);
                        msgWriter.println(tab + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.su.shutdown.time", (Object[])new String[]{suShutdownTime == null ? valueNotAvailable : suShutdownTime.toString()}));
                    }
                    if (suCompItemSet.contains(JBIStatisticsItemNames.SERVICE_UNIT_STARTUP_TIME)) {
                        Long suStartupTime = (Long)suCompData.get(JBIStatisticsItemNames.SERVICE_UNIT_STARTUP_TIME);
                        msgWriter.println(tab + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.su.startup.time", (Object[])new String[]{suStartupTime == null ? valueNotAvailable : suStartupTime.toString()}));
                    }
                    if (suCompItemSet.contains(JBIStatisticsItemNames.SERVICE_UNIT_STOP_TIME)) {
                        Long suStopTime = (Long)suCompData.get(JBIStatisticsItemNames.SERVICE_UNIT_STOP_TIME);
                        msgWriter.println(tab + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.su.stop.time", (Object[])new String[]{suStopTime == null ? valueNotAvailable : suStopTime.toString()}));
                    }
                    msgWriter.println("");
                }
                msgWriter.println("");
            }
            msgWriter.println("");
        }
    }

    private void printStatsForEndpoint(String endpointName, TabularData result, String target, PrintWriter msgWriter, String pageSeparator, Boolean jUnitFlag) {
        for (CompositeData endpointCompData : result.values()) {
            TabularData pfTbData;
            Long mepDeliveryChannelTime;
            String msgString;
            String valueNotAvailable;
            Long numSentErrors;
            Long numReceivedErrors;
            Long numSentFaults;
            Long numReceivedFaults;
            Long numSentDONEs;
            Long numReceivedDONEs;
            Long numReceivedRequests;
            CompositeType compType = endpointCompData.getCompositeType();
            Set<String> compItemSet = compType.keySet();
            String compTypeName = endpointCompData.getCompositeType().getTypeName();
            if (("" + compTypeName).compareTo(PROVIDER_ENDPOINT_TYPE_NAME) == 0) {
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.endpoint.provider.name", (Object[])new String[]{endpointName}));
                msgWriter.println(pageSeparator);
                if (compItemSet.contains("ActivationTime")) {
                    Date activationTime = (Date)endpointCompData.get("ActivationTime");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.endpoint.activation.time", (Object[])new String[]{activationTime.toString()}));
                }
                if (compItemSet.contains("EndpointUpTime (ms)")) {
                    Long upTime = (Long)endpointCompData.get("EndpointUpTime (ms)");
                    String formatString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.endpoint.up.time");
                    TimeUtil timeUtil = new TimeUtil(upTime);
                    msgWriter.format(formatString + "\n", timeUtil.getDays(), timeUtil.getHours(), timeUtil.getMins(), timeUtil.getSecs());
                }
                if (compItemSet.contains("NumActiveExchanges")) {
                    Long numActiveExchanges = (Long)endpointCompData.get("NumActiveExchanges");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.active.exchanges", (Object[])new String[]{numActiveExchanges.toString()}));
                }
                if (compItemSet.contains("NumReceivedRequests")) {
                    numReceivedRequests = (Long)endpointCompData.get("NumReceivedRequests");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.requests", (Object[])new String[]{numReceivedRequests.toString()}));
                }
                if (compItemSet.contains("NumSentReplies")) {
                    Long numSentReplies = (Long)endpointCompData.get("NumSentReplies");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.replies", (Object[])new String[]{numSentReplies.toString()}));
                }
                if (compItemSet.contains("NumReceivedDONEs")) {
                    numReceivedDONEs = (Long)endpointCompData.get("NumReceivedDONEs");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.dones", (Object[])new String[]{numReceivedDONEs.toString()}));
                }
                if (compItemSet.contains("NumSentDONEs")) {
                    numSentDONEs = (Long)endpointCompData.get("NumSentDONEs");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.dones", (Object[])new String[]{numSentDONEs.toString()}));
                }
                if (compItemSet.contains("NumReceivedFaults")) {
                    numReceivedFaults = (Long)endpointCompData.get("NumReceivedFaults");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.faults", (Object[])new String[]{numReceivedFaults.toString()}));
                }
                if (compItemSet.contains("NumSentFaults")) {
                    numSentFaults = (Long)endpointCompData.get("NumSentFaults");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.faults", (Object[])new String[]{numSentFaults.toString()}));
                }
                if (compItemSet.contains("NumReceivedErrors")) {
                    numReceivedErrors = (Long)endpointCompData.get("NumReceivedErrors");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.errors", (Object[])new String[]{numReceivedErrors.toString()}));
                }
                if (compItemSet.contains("NumSentErrors")) {
                    numSentErrors = (Long)endpointCompData.get("NumSentErrors");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.errors", (Object[])new String[]{numSentErrors.toString()}));
                }
                valueNotAvailable = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.value.not.available", null);
                msgWriter.println("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.exchanges.statistics", null) + "\n");
                if (!compItemSet.contains("MessageExchangeNMRTime Avg (ns)") && !jUnitFlag.booleanValue()) {
                    if (!this.getMsgSvcTimingStatisticsEnabledFlag(target)) {
                        msgString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.timing.disabled.msg");
                        msgWriter.println("  " + msgString);
                    } else {
                        msgString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.timing.data.not.available");
                        msgWriter.println("  " + msgString);
                    }
                } else {
                    if (compItemSet.contains("MessageExchangeResponseTime Avg (ns)")) {
                        Long mepResponseTime = (Long)endpointCompData.get("MessageExchangeResponseTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.response.time", (Object[])new String[]{mepResponseTime == null ? valueNotAvailable : mepResponseTime.toString()}));
                    }
                    if (compItemSet.contains("MessageExchangeComponentTime Avg (ns)")) {
                        String componentName = (String)endpointCompData.get("ComponentName");
                        Long mepComponentTime = (Long)endpointCompData.get("MessageExchangeComponentTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.component.time", (Object[])new String[]{componentName + "", mepComponentTime == null ? valueNotAvailable : mepComponentTime.toString()}));
                    }
                    if (compItemSet.contains("MessageExchangeDeliveryTime Avg (ns)")) {
                        mepDeliveryChannelTime = (Long)endpointCompData.get("MessageExchangeDeliveryTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.delivery.channel.time", (Object[])new String[]{mepDeliveryChannelTime == null ? valueNotAvailable : mepDeliveryChannelTime.toString()}));
                    }
                    if (compItemSet.contains("MessageExchangeNMRTime Avg (ns)")) {
                        Long mepMessageServiceTime = (Long)endpointCompData.get("MessageExchangeNMRTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.message.service.time", (Object[])new String[]{mepMessageServiceTime == null ? valueNotAvailable : mepMessageServiceTime.toString()}));
                    }
                }
                if (compItemSet.contains("PerformanceMeasurements")) {
                    msgWriter.println("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.perf.instr.dataline", null) + "\n");
                    pfTbData = (TabularData)endpointCompData.get("PerformanceMeasurements");
                    for (CompositeData pfCompData : pfTbData.values()) {
                        this.printCompositeDataRecursively(pfCompData, msgWriter, "");
                        msgWriter.println("");
                    }
                }
            } else if (("" + compTypeName).compareTo(COMSUMER_ENDPOINT_TYPE_NAME) == 0) {
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.endpoint.consumer.name", (Object[])new String[]{endpointName}));
                msgWriter.println(pageSeparator);
                if (compItemSet.contains("NumSentRequests")) {
                    Long numSentRequests = (Long)endpointCompData.get("NumSentRequests");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.requests", (Object[])new String[]{numSentRequests.toString()}));
                }
                if (compItemSet.contains("NumReceivedReplies")) {
                    numReceivedRequests = (Long)endpointCompData.get("NumReceivedReplies");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.replies", (Object[])new String[]{numReceivedRequests.toString()}));
                }
                if (compItemSet.contains("NumReceivedDONEs")) {
                    numReceivedDONEs = (Long)endpointCompData.get("NumReceivedDONEs");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.dones", (Object[])new String[]{numReceivedDONEs.toString()}));
                }
                if (compItemSet.contains("NumSentDONEs")) {
                    numSentDONEs = (Long)endpointCompData.get("NumSentDONEs");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.dones", (Object[])new String[]{numSentDONEs.toString()}));
                }
                if (compItemSet.contains("NumReceivedFaults")) {
                    numReceivedFaults = (Long)endpointCompData.get("NumReceivedFaults");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.faults", (Object[])new String[]{numReceivedFaults.toString()}));
                }
                if (compItemSet.contains("NumSentFaults")) {
                    numSentFaults = (Long)endpointCompData.get("NumSentFaults");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.faults", (Object[])new String[]{numSentFaults.toString()}));
                }
                if (compItemSet.contains("NumReceivedErrors")) {
                    numReceivedErrors = (Long)endpointCompData.get("NumReceivedErrors");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.received.errors", (Object[])new String[]{numReceivedErrors.toString()}));
                }
                if (compItemSet.contains("NumSentErrors")) {
                    numSentErrors = (Long)endpointCompData.get("NumSentErrors");
                    msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.num.sent.errors", (Object[])new String[]{numSentErrors.toString()}));
                }
                valueNotAvailable = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.value.not.available", null);
                msgWriter.println("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.message.exchanges.statistics", null) + "\n");
                if (!compItemSet.contains("MessageExchangeNMRTime Avg (ns)") && !jUnitFlag.booleanValue()) {
                    if (!this.getMsgSvcTimingStatisticsEnabledFlag(target)) {
                        msgString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.timing.disabled.msg");
                        msgWriter.println("  " + msgString);
                    } else {
                        msgString = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.timing.data.not.available");
                        msgWriter.println("  " + msgString);
                    }
                } else {
                    if (compItemSet.contains("MessageExchangeStatusTime Avg (ns)")) {
                        Long mepStatusTime = (Long)endpointCompData.get("MessageExchangeStatusTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.status.time", (Object[])new String[]{mepStatusTime == null ? valueNotAvailable : mepStatusTime.toString()}));
                    }
                    if (compItemSet.contains("MessageExchangeComponentTime Avg (ns)")) {
                        Long mepComponentTime = (Long)endpointCompData.get("MessageExchangeComponentTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.component.time.noname", (Object[])new String[]{mepComponentTime == null ? valueNotAvailable : mepComponentTime.toString()}));
                    }
                    if (compItemSet.contains("MessageExchangeDeliveryTime Avg (ns)")) {
                        mepDeliveryChannelTime = (Long)endpointCompData.get("MessageExchangeDeliveryTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.delivery.channel.time", (Object[])new String[]{mepDeliveryChannelTime == null ? valueNotAvailable : mepDeliveryChannelTime.toString()}));
                    }
                    if (compItemSet.contains("MessageExchangeNMRTime Avg (ns)")) {
                        Long mepNMRTime = (Long)endpointCompData.get("MessageExchangeNMRTime Avg (ns)");
                        msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.mep.message.service.time", (Object[])new String[]{mepNMRTime == null ? valueNotAvailable : mepNMRTime.toString()}));
                    }
                }
                msgWriter.println("\n" + this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.common.perf.instr.dataline", null) + "\n");
                if (compItemSet.contains("PerformanceMeasurements")) {
                    pfTbData = (TabularData)endpointCompData.get("PerformanceMeasurements");
                    for (CompositeData pfCompData : pfTbData.values()) {
                        this.printCompositeDataRecursively(pfCompData, msgWriter, "");
                        msgWriter.println("");
                    }
                }
            }
            msgWriter.println("");
        }
        msgWriter.println("");
    }

    private void printStatsForNMR(TabularData result, String target, PrintWriter msgWriter) {
        String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.nmr.info.header", (Object[])new String[]{target});
        String headerSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.header.separator");
        String pageSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.separator");
        String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.nmr.info.empty");
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (result == null || result.size() == 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
            return;
        }
        for (CompositeData compData : result.values()) {
            int i;
            String instanceName = (String)compData.get(JBIStatisticsItemNames.INSTANCE_NAME);
            String[] listActiveChannels = (String[])compData.get(JBIStatisticsItemNames.NMR_STATS_ACTIVE_CHANNELS);
            String[] listActiveEndpoints = (String[])compData.get(JBIStatisticsItemNames.NMR_STATS_ACTIVE_ENDPOINTS);
            String instanceNameLine = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.nmr.instance.name", (Object[])new String[]{instanceName});
            msgWriter.println(instanceNameLine);
            msgWriter.println(pageSeparator);
            if (listActiveChannels != null) {
                String activeChannelNumberLine = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.nmr.active.channel.number", (Object[])new String[]{Integer.toString(listActiveChannels.length)});
                msgWriter.println(activeChannelNumberLine);
                for (i = 0; i < listActiveChannels.length; ++i) {
                    msgWriter.println(listActiveChannels[i]);
                }
            }
            msgWriter.println("");
            if (listActiveEndpoints != null) {
                String activeEndpointNumberLine = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.nmr.active.endpoint.number", (Object[])new String[]{Integer.toString(listActiveEndpoints.length)});
                msgWriter.println(activeEndpointNumberLine);
                for (i = 0; i < listActiveEndpoints.length; ++i) {
                    msgWriter.println(listActiveEndpoints[i]);
                }
            }
            msgWriter.println("");
            msgWriter.println("");
        }
    }

    private void getStatsForComponentsAndPrintStats(List theList, String target, PrintWriter msgWriter, StringWriter stringWriter) {
        ArrayList<Component> componentList = new ArrayList<Component>(theList);
        for (Component comp : theList) {
            String compName;
            if (comp == null || (compName = comp.getName()) == null || compName.trim().compareTo("") != 0) continue;
            componentList.remove(comp);
        }
        try {
            if (componentList.size() == 0) {
                Iterator compIter = null;
                JBIComponentInfo compInfo2 = null;
                List bcList = JBIComponentInfo.readFromXmlText((String)this.getJBIAdminCommands().listBindingComponents(COMPONENT_STARTED_STATE, null, null, target));
                for (JBIComponentInfo compInfo2 : bcList) {
                    Component component = new Component();
                    component.setName(compInfo2.getName());
                    componentList.add(component);
                }
                List seList = JBIComponentInfo.readFromXmlText((String)this.getJBIAdminCommands().listServiceEngines(COMPONENT_STARTED_STATE, null, null, target));
                compIter = bcList.iterator();
                for (JBIComponentInfo compInfo2 : seList) {
                    Component component = new Component();
                    component.setName(compInfo2.getName());
                    componentList.add(component);
                }
            }
            String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.component.info.header", (Object[])new String[]{target});
            String headerSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.header.separator");
            String pageSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.separator");
            String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.component.info.empty");
            msgWriter.println(headerSeparator);
            msgWriter.println(header);
            msgWriter.println(headerSeparator);
            int results = 0;
            Iterator it = componentList.iterator();
            while (it.hasNext()) {
                String compName = ((Component)it.next()).getName();
                this.logDebug("The component name is: " + compName);
                TabularData result = this.getJBIAdminCommands().getComponentStats(compName, target);
                this.printStatsForComponent(compName, result, target, msgWriter, pageSeparator, false);
                stringWriter.flush();
                ++results;
            }
            if (results == 0) {
                msgWriter.println(emptyResult);
                msgWriter.println(pageSeparator);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    private void getStatsForServiceAssemblies(List theList, String target, PrintWriter msgWriter, StringWriter stringWriter) {
        ArrayList<ServiceAssembly> saNameList = new ArrayList<ServiceAssembly>(theList);
        for (ServiceAssembly sa : theList) {
            String saName;
            if (sa == null || (saName = sa.getName()) == null || saName.trim().compareTo("") != 0) continue;
            saNameList.remove(sa);
        }
        try {
            if (saNameList.size() == 0) {
                List saList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)this.getJBIAdminCommands().listServiceAssemblies(target));
                ServiceAssemblyInfo saInfo = null;
                Iterator saIter = saList.iterator();
                this.logDebug("Start to list sa names");
                while (saIter.hasNext()) {
                    saInfo = (ServiceAssemblyInfo)saIter.next();
                    ServiceAssembly sa = new ServiceAssembly();
                    sa.setName(saInfo.getName());
                    saNameList.add(sa);
                    this.logDebug("The sa name is: " + saInfo.getName());
                }
            }
            String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.info.header", (Object[])new String[]{target});
            String headerSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.header.separator");
            String pageSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.separator");
            String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.sa.info.empty");
            msgWriter.println(headerSeparator);
            msgWriter.println(header);
            msgWriter.println(headerSeparator);
            int results = 0;
            Iterator it = saNameList.iterator();
            while (it.hasNext()) {
                String saName = ((ServiceAssembly)it.next()).getName();
                TabularData result = this.getJBIAdminCommands().getServiceAssemblyStats(saName, target);
                if (result == null) continue;
                this.printStatsForServiceAssembly(result, target, msgWriter, pageSeparator);
                stringWriter.flush();
                ++results;
            }
            if (results == 0) {
                msgWriter.println(emptyResult);
                msgWriter.println(pageSeparator);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    private void getStatsForEndpointsAndPrintStats(List theList, String target, PrintWriter msgWriter, StringWriter stringWriter) {
        ArrayList<Endpoint> endpointNameList = new ArrayList<Endpoint>(theList);
        for (Endpoint endpoint : theList) {
            String endpointName;
            if (endpoint == null || (endpointName = endpoint.getName()) == null || endpointName.trim().compareTo("") != 0) continue;
            endpointNameList.remove(endpoint);
        }
        try {
            if (endpointNameList.size() == 0) {
                TabularData tbData = this.getJBIAdminCommands().getNMRStats(target);
                for (CompositeData compData : tbData.values()) {
                    String[] listActiveEndpoints = (String[])compData.get(JBIStatisticsItemNames.NMR_STATS_ACTIVE_ENDPOINTS);
                    for (int i = 0; i < listActiveEndpoints.length; ++i) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setName(listActiveEndpoints[i]);
                        endpointNameList.add(endpoint);
                    }
                }
            }
            String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.endpoint.info.header", (Object[])new String[]{target});
            String headerSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.header.separator");
            String pageSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.info.separator");
            String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.stats.endpoint.info.empty");
            msgWriter.println(headerSeparator);
            msgWriter.println(header);
            msgWriter.println(headerSeparator);
            int results = 0;
            Iterator it = endpointNameList.iterator();
            while (it.hasNext()) {
                String endpointName = ((Endpoint)it.next()).getName();
                this.logDebug("Statistics for endpoint, the endpoint is " + endpointName);
                this.logDebug("Statistics for endpoint, the target is " + target);
                TabularData result = this.getJBIAdminCommands().getEndpointStats(endpointName, target);
                if (result == null) continue;
                this.printStatsForEndpoint(endpointName, result, target, msgWriter, pageSeparator, false);
                stringWriter.flush();
                ++results;
            }
            if (results == 0) {
                msgWriter.println(emptyResult);
                msgWriter.println(pageSeparator);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    private boolean getMsgSvcTimingStatisticsEnabledFlag(String target) throws BuildException {
        try {
            Properties returnProps = this.getJBIAdminCommands().getRuntimeConfiguration(target);
            if (returnProps == null) {
                return false;
            }
            String theBooleanPropStr = returnProps.getProperty("msgSvcTimingStatisticsEnabled");
            if (theBooleanPropStr == null) {
                return false;
            }
            return Boolean.valueOf(theBooleanPropStr);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
            return false;
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    public class Endpoint {
        protected String mName = "";

        public String getName() {
            return this.mName;
        }

        public void setName(String theName) {
            this.mName = theName;
        }
    }

    public class ServiceAssembly {
        protected String mName = "";

        public String getName() {
            return this.mName;
        }

        public void setName(String theName) {
            this.mName = theName;
        }
    }

    public class Component {
        protected String mName = "";

        public String getName() {
            return this.mName;
        }

        public void setName(String theName) {
            this.mName = theName;
        }
    }
}

