/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;

public class JbiListComponentLoggersTask
extends JbiTargetTask {
    private static final String LOGGER_SUCCESS_STATUS_KEY = "jbi.ui.ant.list.logger.successful";
    private static final String LOGGER_FAILED_STATUS_KEY = "jbi.ui.ant.list.logger.failed";
    private static final String INSTANCE_ERROR_PROP = "com.sun.jbi.cluster.instance.error";
    private static final String APP_CONFIG_NAME_KEY = "configurationName";
    private String mComponentName = null;
    private List mLoggerList;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    private void executeListComponentLoggers(String componentName) throws BuildException {
        try {
            String target = this.getValidTarget();
            List tmpLoggerList = this.getLoggerList();
            ArrayList loggerList = new ArrayList(tmpLoggerList);
            for (Logger logger : tmpLoggerList) {
                String loggerName;
                if (logger == null || (loggerName = logger.getName()) == null || loggerName.trim().compareTo("") != 0) continue;
                loggerList.remove(logger);
            }
            this.logDebug("Before calling getJBIAdminCommands().getComponentLoggerLevels, the target is: " + target);
            Map resultLevels = this.getJBIAdminCommands().getComponentLoggerLevels(componentName, target, target);
            this.logDebug("After calling getJBIAdminCommands().getComponentLoggerLevels, the target is: " + target);
            if (resultLevels == null) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.no.logger.resolved", null);
                throw new BuildException(errMsg);
            }
            if (loggerList.size() == 0) {
                this.printComponentLoggerLevels(componentName, resultLevels, target);
            } else {
                Iterator it = loggerList.iterator();
                TreeMap<String, Level> theLevels = new TreeMap<String, Level>();
                while (it.hasNext()) {
                    Logger logger = (Logger)it.next();
                    String loggerName = logger.getName();
                    if (loggerName == null || loggerName.compareTo("") == 0) continue;
                    Level theLevel = (Level)resultLevels.get(logger.getName());
                    if (theLevel == null) {
                        String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.no.logger.resolved", null);
                        throw new BuildException(errMsg);
                    }
                    theLevels.put(logger.getName(), theLevel);
                }
                this.printComponentLoggerLevels(componentName, theLevels, target);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing List Configuration Task....");
        String compName = this.getComponentName();
        this.executeListComponentLoggers(compName);
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return LOGGER_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return LOGGER_SUCCESS_STATUS_KEY;
    }

    protected String getEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.empty" : "jbi.ui.ant.print.jbi.comp.config.info.empty";
    }

    protected String getLoggerEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.logger.info.empty" : "jbi.ui.ant.print.jbi.comp.logger.info.empty";
    }

    protected String getQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header" : "jbi.ui.ant.print.jbi.comp.config.info.header";
    }

    protected String getLoggerQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.logger.info.header" : "jbi.ui.ant.print.jbi.comp.logger.info.header";
    }

    protected String getQueryResultHeaderSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header.separator" : "jbi.ui.ant.print.jbi.comp.config.info.header.separator";
    }

    protected String getQueryResultPageSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.separator" : "jbi.ui.ant.print.jbi.comp.config.info.separator";
    }

    protected void printComponentLoggerLevels(String compName, Map<String, Level> theMap, String target) {
        this.logDebug("Printing Component Logger Levels....");
        if (theMap == null) {
            this.logDebug("List Component Logger Level map returns NULL");
        } else {
            this.logDebug("Size of Component Logger Level map: " + theMap.size());
        }
        boolean isRuntime = false;
        String header = this.getI18NBundle().getMessage(this.getLoggerQueryResultHeaderI18NKey(isRuntime), (Object[])new String[]{compName, target});
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey(isRuntime));
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey(isRuntime));
        String emptyResult = this.getI18NBundle().getMessage(this.getLoggerEmptyQueryResultI18NKey(isRuntime));
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (theMap == null || theMap.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            TreeSet<String> keys = new TreeSet<String>(theMap.keySet());
            for (Object e : keys) {
                String loggerName = (String)e;
                Level level = theMap.get(loggerName);
                String param = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.config.param", (Object)loggerName, (Object)(level == null ? "" : level.getLocalizedName()));
                msgWriter.println(param);
            }
            msgWriter.println(pageSeparator);
        }
        msgWriter.close();
        this.printMessage(stringWriter.getBuffer().toString());
    }

    protected List getLoggerList() {
        if (this.mLoggerList == null) {
            this.mLoggerList = new ArrayList();
        }
        return this.mLoggerList;
    }

    public Logger createLogger() {
        Logger logger = new Logger();
        this.getLoggerList().add(logger);
        return logger;
    }
}

