/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.client.ConnectionType;
import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.client.JMXConnectionProperties;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.JMXConnectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class JbiJmxTask
extends Task {
    public static final String DEF_USERNAME_PROP = "jbi.default.username";
    public static final String DEF_PASSWORD_PROP = "jbi.default.password";
    public static final String DEF_HOST_PROP = "jbi.default.host";
    public static final String DEF_PORT_PROP = "jbi.default.port";
    public static final String DEF_URL_PROP = "jbi.default.url";
    public static final String DEF_JMX_PROPERTIES_FILE = "jmx.default.properties.file";
    private static I18NBundle sI18NBundle = null;
    private Boolean mSecure = null;
    private String mHost = null;
    private String mPort = null;
    private String mUsername = null;
    private String mPassword = null;
    private File mPasswordFile = null;
    private boolean mFailOnError = true;
    private String mPropertiesFile = null;
    private JBIAdminCommands mJbiAdminCommands = null;

    public boolean isFailOnError() {
        return this.mFailOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.mFailOnError = failOnError;
    }

    public Boolean getSecure() {
        return this.mSecure;
    }

    public void setSecure(Boolean secure) {
        this.mSecure = secure;
    }

    private String getDefaultUsername() {
        return this.getProject().getProperty(DEF_USERNAME_PROP);
    }

    public String getUsername() {
        if (this.mUsername == null) {
            return this.getDefaultUsername();
        }
        return this.mUsername;
    }

    public void setUsername(String aUsername) {
        this.mJbiAdminCommands = null;
        this.mUsername = aUsername;
    }

    public String getDefaultPassword() {
        return this.getProject().getProperty(DEF_PASSWORD_PROP);
    }

    public String getPassword() {
        if (this.mPassword == null) {
            return this.getDefaultPassword();
        }
        return this.mPassword;
    }

    public void setPassword(String aPassword) {
        this.mJbiAdminCommands = null;
        this.mPassword = aPassword;
    }

    public File getPasswordfile() {
        return this.mPasswordFile;
    }

    public void setPasswordfile(File passwordFile) {
        this.mPasswordFile = passwordFile;
    }

    public String getDefaultHost() {
        return this.getProject().getProperty(DEF_HOST_PROP);
    }

    public String getHost() {
        if (this.mHost == null) {
            return this.getDefaultHost();
        }
        return this.mHost;
    }

    public void setHost(String aHost) {
        this.mJbiAdminCommands = null;
        this.mHost = aHost;
    }

    public void setJmxpropertiesfile(String propertiesfile) {
        this.mPropertiesFile = propertiesfile;
    }

    public String getJmxpropertiesfile() {
        if (this.mPropertiesFile == null || !new File(this.mPropertiesFile).exists()) {
            return this.getDefaultJmxpropertiesfile();
        }
        return this.mPropertiesFile;
    }

    public String getDefaultJmxpropertiesfile() {
        return this.getProject().getProperty(DEF_JMX_PROPERTIES_FILE);
    }

    public Properties getProviderProperties() {
        Properties conprops = new Properties();
        if (this.mPropertiesFile != null) {
            try {
                File f = new File(this.mPropertiesFile);
                FileInputStream fio = new FileInputStream(f);
                conprops.load(fio);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return conprops;
    }

    public String getDefaultPort() {
        String port = this.getProject().getProperty(DEF_PORT_PROP);
        return port;
    }

    public String getPort() {
        if (this.mPort == null) {
            return this.getDefaultPort();
        }
        return this.mPort;
    }

    public void setPort(String aPort) {
        this.mJbiAdminCommands = null;
        this.mPort = aPort;
    }

    private String getDefaultUrl() {
        return this.getProject().getProperty(DEF_URL_PROP);
    }

    protected Properties getJmxConnectionProperties() {
        String username = this.getUsername();
        String password = this.getPassword();
        String host = this.getHost();
        String port = this.getPort();
        String url = this.getDefaultUrl();
        Properties provprops = this.getProviderProperties();
        return JMXConnectionProperties.getJMXConnectionPropertyMap((Properties)provprops, (String)url, (String)host, (String)port, (String)username, (String)password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPasswordFromFile(File pwFile) throws IOException {
        String AS_ADMIN_PASSWORD_PROP = "AS_ADMIN_PASSWORD";
        String password = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(pwFile);
            Properties props = new Properties();
            props.load(in);
            password = props.getProperty("AS_ADMIN_PASSWORD");
            if (password == null) {
                throw new IOException(this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.password.not.found.in.file", new Object[]{pwFile.getName()}));
            }
            String string = password;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    this.logDebug(ex.getMessage());
                }
            }
        }
    }

    protected String getPasswordFromFileOrAttribute() throws IOException {
        String password = null;
        File pwFile = this.getPasswordfile();
        if (pwFile == null) {
            return this.getPassword();
        }
        this.logDebug("Getting password from the password file " + pwFile);
        if (!pwFile.exists()) {
            this.logDebug("Password file path not found " + pwFile.getPath());
            throw new IOException(this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.password.file.not.exist", new Object[]{pwFile.getName()}));
        }
        return password;
    }

    protected JBIAdminCommands getJBIAdminCommands() throws Exception {
        if (this.mJbiAdminCommands == null) {
            this.validateJmxConnectionPortValue(this.getPort());
            String portValue = this.getPort();
            if (portValue == null) {
                portValue = "4848";
            }
            int port = Integer.parseInt(portValue);
            String host = this.getHost();
            if (host == null) {
                host = "localhost";
            }
            String username = this.getUsername();
            String password = this.getPassword();
            ConnectionType connType = null;
            Boolean secure = this.getSecure();
            if (secure != null && secure.booleanValue()) {
                connType = ConnectionType.HTTPS;
                this.mJbiAdminCommands = JBIAdminCommandsClientFactory.getInstance((String)host, (int)port, (String)username, (String)password, (ConnectionType)connType);
            } else {
                this.mJbiAdminCommands = JBIAdminCommandsClientFactory.getInstance((String)host, (int)port, (String)username, (String)password);
            }
        }
        return this.mJbiAdminCommands;
    }

    private static I18NBundle getStandardI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.ant");
        }
        return sI18NBundle;
    }

    protected I18NBundle getI18NBundle() {
        return JbiJmxTask.getStandardI18NBundle();
    }

    protected abstract String getTaskSuccessStatusI18NKey();

    protected String getTaskWarningStatusI18NKey() {
        return null;
    }

    protected abstract String getTaskFailedStatusI18NKey();

    protected String getTaskPartialSuccessStatusI18NKey() {
        return null;
    }

    protected void logInfo(String anInfoMsg) {
        this.log(anInfoMsg, 2);
    }

    protected void logWarning(String aWarningMsg) {
        this.log(aWarningMsg, 1);
    }

    protected void logError(String aErrorMsg) {
        this.log(aErrorMsg, 0);
    }

    protected void logDebug(String aDebugMsg) {
        this.log(aDebugMsg, 4);
    }

    protected void logVerbose(String aVerboseMsg) {
        this.log(aVerboseMsg, 3);
    }

    private String formatSuccessMessage(String statusMsg) {
        String key = "jbi.ui.ant.task.msg.success.no.args.format";
        return JbiJmxTask.getStandardI18NBundle().getMessage(key, (Object)statusMsg);
    }

    private String formatSuccessMessage(String statusMsg, String causeMsg) {
        if (causeMsg == null) {
            return this.formatSuccessMessage(statusMsg);
        }
        String key = "jbi.ui.ant.task.msg.success.format";
        return JbiJmxTask.getStandardI18NBundle().getMessage(key, (Object)statusMsg, (Object)causeMsg);
    }

    private String formatFailedMessage(String statusMsg, String causeMsg) {
        String key = "jbi.ui.ant.task.msg.failed.format";
        return JbiJmxTask.getStandardI18NBundle().getMessage(key, (Object)statusMsg, (Object)causeMsg);
    }

    protected String formatTaskSuccessMessage() {
        String statusMsg = this.getI18NBundle().getMessage(this.getTaskSuccessStatusI18NKey());
        return this.formatSuccessMessage(statusMsg);
    }

    protected String formatTaskSuccessMessage(String causeMsg) {
        String statusMsg = this.getI18NBundle().getMessage(this.getTaskSuccessStatusI18NKey());
        return this.formatSuccessMessage(statusMsg, causeMsg);
    }

    protected String formatTaskFailedMessage(String causeMsg) {
        String statusMsg = this.getI18NBundle().getMessage(this.getTaskFailedStatusI18NKey());
        return this.formatFailedMessage(statusMsg, causeMsg);
    }

    protected void throwBuildException(String causeMsg) throws BuildException {
        String expMsg = this.formatTaskFailedMessage(causeMsg);
        throw new BuildException(expMsg, this.location);
    }

    protected void throwBuildException(Throwable aCause) throws BuildException {
        String causeMsg = aCause.getMessage();
        if (causeMsg == null) {
            causeMsg = aCause.toString();
        }
        String expMsg = this.formatTaskFailedMessage(causeMsg);
        throw new BuildException(expMsg, aCause, this.location);
    }

    protected void throwBuildException(JBIManagementMessage aCauseMgmtMsg) throws BuildException {
        String causeMsg = aCauseMgmtMsg.getMessage();
        if (causeMsg == null) {
            causeMsg = aCauseMgmtMsg.toString();
        }
        String expMsg = this.formatTaskFailedMessage(causeMsg);
        JBIManagementMessage.JBIManagementMessageException aCauseMgmtMsgEx = new JBIManagementMessage.JBIManagementMessageException(expMsg, aCauseMgmtMsg);
        throw new BuildException(expMsg, (Throwable)aCauseMgmtMsgEx, this.location);
    }

    protected void throwTaskBuildException(String aCauseKey) throws BuildException {
        String aCauseMsg = this.createFailedFormattedJbiAdminResult(aCauseKey, null);
        this.throwBuildException(aCauseMsg);
    }

    protected void throwTaskBuildException(String aCauseKey, String aCauseArg1) throws BuildException {
        String aCauseMsg = this.createFailedFormattedJbiAdminResult(aCauseKey, new Object[]{aCauseArg1});
        this.throwBuildException(aCauseMsg);
    }

    protected void printTaskSuccess(String result) {
        if (result == null || result.trim().length() <= 0) {
            this.logWarning(this.formatTaskSuccessMessage());
        } else {
            this.logWarning(this.formatTaskSuccessMessage(result));
        }
    }

    protected void printTaskPartialSuccess(String result) {
        String statusMsg = this.getI18NBundle().getMessage(this.getTaskPartialSuccessStatusI18NKey());
        String formatterKey = "jbi.ui.ant.task.msg.success.format";
        String formattedResult = null;
        if (result == null || result.trim().length() <= 0) {
            formatterKey = "jbi.ui.ant.task.msg.success.no.args.format";
            formattedResult = JbiJmxTask.getStandardI18NBundle().getMessage(formatterKey, (Object)statusMsg);
        } else {
            formattedResult = JbiJmxTask.getStandardI18NBundle().getMessage(formatterKey, (Object)statusMsg, (Object)result);
        }
        this.logWarning(formattedResult);
    }

    protected void printTaskSuccess(JBIManagementMessage mgmtMsg) {
        String msg = mgmtMsg.getMessage();
        String partialSuccessI18NKey = this.getTaskPartialSuccessStatusI18NKey();
        if (partialSuccessI18NKey != null && mgmtMsg.isWarningMsg()) {
            this.printTaskPartialSuccess(msg);
        } else {
            this.printTaskSuccess(msg);
        }
    }

    protected void printMessage(String aMsg) {
        this.logWarning(aMsg);
    }

    protected JBIManagementMessage extractJBIManagementMessage(Exception ex) {
        JBIManagementMessage mgmtMsg = null;
        if (ex instanceof JBIRemoteException) {
            JBIRemoteException rEx = (JBIRemoteException)ex;
            mgmtMsg = rEx.extractJBIManagementMessage();
        } else {
            String exMessage = ex.getMessage();
            mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)exMessage);
        }
        return mgmtMsg;
    }

    protected void processTaskException(Exception ex) throws BuildException {
        JBIManagementMessage mgmtMsg = this.extractJBIManagementMessage(ex);
        if (mgmtMsg == null) {
            this.throwBuildException(ex);
        } else if (mgmtMsg.isFailedMsg()) {
            this.throwBuildException(mgmtMsg);
        } else {
            this.printTaskSuccess(mgmtMsg);
        }
    }

    protected void processTaskResult(String result) throws BuildException {
        JBIManagementMessage mgmtMsg = null;
        if (result != null) {
            mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)result);
        }
        if (mgmtMsg == null) {
            this.printTaskSuccess(result);
            return;
        }
        if (mgmtMsg.isFailedMsg()) {
            this.throwBuildException(mgmtMsg);
        } else {
            this.printTaskSuccess(mgmtMsg);
        }
    }

    protected abstract void executeTask() throws BuildException;

    protected void logDebugConnectionAttributes() {
        this.logDebug("values of jbi task connection attributes: ( host=" + this.getHost() + ", port=" + this.getPort() + ", secure=" + this.getSecure() + ", username=" + this.getUsername() + ")");
    }

    public void execute() throws BuildException {
        this.logDebugConnectionAttributes();
        try {
            this.executeTask();
        }
        catch (BuildException bEx) {
            if (this.isFailOnError()) {
                throw bEx;
            }
            this.logWarning(bEx.getMessage());
        }
    }

    protected String createFailedFormattedJbiAdminResult(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASKS_VALIDATION", false, "ERROR", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        if (mgmtMsg != null) {
            return mgmtMsg.getMessage();
        }
        return msg;
    }

    protected void validateJmxConnectionPortValue(String port) throws JMXConnectionException {
        if (port == null) {
            return;
        }
        int portValue = -1;
        try {
            portValue = Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            throw new JMXConnectionException(this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.invalid.jmx.port", new Object[]{port}), null);
        }
    }

    protected String getValidName(String name, String errorMsgI18nKey) throws BuildException {
        String validName = name;
        if (validName != null) {
            validName = validName.trim();
        }
        if (validName == null || validName.length() == 0) {
            this.throwTaskBuildException(errorMsgI18nKey);
        }
        return name;
    }

    protected String getValidComponentName(String compName) throws BuildException {
        return this.getValidName(compName, "jbi.ui.ant.task.error.nullCompName");
    }

    protected String getValidSharedLibraryName(String slibName) throws BuildException {
        return this.getValidName(slibName, "jbi.ui.ant.task.error.nullSLibName");
    }

    protected String getValidServiceAssemblyName(String saName) throws BuildException {
        return this.getValidName(saName, "jbi.ui.ant.task.error.nullSAName");
    }

    protected void printTabularData(TabularData statsReport, PrintWriter msgWriter, String tabStr) {
        Set<?> names = statsReport.keySet();
        for (Object name : names) {
            Object[] key = ((List)name).toArray();
            CompositeData compData = statsReport.get(key);
            this.printMessage("");
            this.printCompositeDataRecursively(compData, msgWriter, tabStr);
        }
    }

    protected void printCompositeDataRecursively(CompositeData compositeData, PrintWriter msgWriter, String tabStr) {
        if (compositeData == null) {
            return;
        }
        CompositeType compType = compositeData.getCompositeType();
        Set<String> openTypes = compType.keySet();
        for (String itemName : openTypes) {
            OpenType<?> openType = compType.getType(itemName);
            if (openType == null) continue;
            if (openType instanceof SimpleType) {
                msgWriter.println(tabStr + itemName + ": " + compositeData.get(itemName));
                continue;
            }
            if (openType instanceof TabularType) {
                TabularData theTabularData = (TabularData)compositeData.get(itemName);
                this.printTabularData(theTabularData, msgWriter, tabStr + "\t");
                continue;
            }
            if (openType instanceof CompositeType) {
                msgWriter.println(tabStr + itemName + ":");
                this.printCompositeDataRecursively((CompositeData)compositeData.get(itemName), msgWriter, tabStr + "\t");
                continue;
            }
            if (!(openType instanceof ArrayType)) continue;
            msgWriter.println(tabStr + itemName + ":");
            OpenType<?> arrayElementType = ((ArrayType)openType).getElementOpenType();
            Object[] arrayData = (Object[])compositeData.get(itemName);
            for (int i = 0; i < arrayData.length; ++i) {
                if (arrayElementType instanceof SimpleType) {
                    msgWriter.println(tabStr + "\t" + arrayData[i]);
                    continue;
                }
                if (arrayElementType instanceof TabularType) {
                    TabularData theTbData = (TabularData)arrayData[i];
                    this.printTabularData(theTbData, msgWriter, tabStr + "\t");
                    continue;
                }
                if (arrayElementType instanceof CompositeType) {
                    this.printCompositeDataRecursively((CompositeData)arrayData[i], msgWriter, tabStr + "\t");
                    continue;
                }
                if (!(arrayElementType instanceof ArrayType)) continue;
                this.printArrayDataRecursively((Object[])arrayData[i], arrayElementType, msgWriter, tabStr + "\t");
            }
        }
    }

    protected void printArrayDataRecursively(Object[] arrayData, OpenType elementType, PrintWriter msgWriter, String tabStr) {
        for (int i = 0; i < arrayData.length; ++i) {
            if (elementType instanceof SimpleType) {
                msgWriter.println(tabStr + arrayData[i].toString());
                continue;
            }
            if (elementType instanceof TabularType) {
                msgWriter.println(tabStr + arrayData[i].toString());
                continue;
            }
            if (elementType instanceof CompositeType) {
                this.printCompositeDataRecursively((CompositeData)arrayData[i], msgWriter, tabStr);
                continue;
            }
            if (!(elementType instanceof ArrayType)) continue;
            msgWriter.println(tabStr + ((ArrayType)elementType).getTypeName() + ":");
            this.printArrayDataRecursively((Object[])arrayData[i], elementType, msgWriter, tabStr + "\t");
        }
    }
}

