/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.jta;

import com.atomikos.icatch.jta.UserTransactionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import net.openesb.standalone.Lifecycle;
import net.openesb.standalone.LifecycleException;
import net.openesb.standalone.jta.TransactionManagerProvider;

public class TransactionManagerService
implements Lifecycle {
    private static final Logger LOG = Logger.getLogger(TransactionManagerService.class.getName());
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private InitialContext initialContext;

    @Override
    public void start() throws LifecycleException {
        UserTransactionManager utm = this.getTransactionManager();
        try {
            try {
                utm.init();
            }
            catch (SystemException ex) {
                Logger.getLogger(TransactionManagerProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.initialContext.createSubcontext("java:comp");
            this.initialContext.bind("java:comp/UserTransaction", (Object)utm);
        }
        catch (NamingException ex) {
            Logger.getLogger(TransactionManagerProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        UserTransactionManager utm = this.getTransactionManager();
        utm.close();
    }

    private UserTransactionManager getTransactionManager() {
        return (UserTransactionManager)this.transactionManager;
    }
}

