/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.http.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.openesb.standalone.env.Environment;
import net.openesb.standalone.http.handlers.Handler;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeType;

public class SitePluginHandler
implements Handler<HttpHandler> {
    private final Environment environment;

    public SitePluginHandler(Environment environment) {
        this.environment = environment;
    }

    @Override
    public HttpHandler getHandler() {
        return new LocalPluginHandler(this.path(), this.environment);
    }

    @Override
    public String path() {
        return "/plugin";
    }

    static class LocalPluginHandler
    extends HttpHandler {
        private final String root;
        private final Environment environment;

        public LocalPluginHandler(String root, Environment environment) {
            this.root = root;
            this.environment = environment;
        }

        public void service(Request request, Response response) throws Exception {
            String path = request.getRequestURI().substring(this.root.length() + 1);
            int i1 = path.indexOf(47);
            if (i1 == -1) {
                response.sendRedirect(request.getRequestURI() + "/");
                return;
            }
            String pluginName = path.substring(0, i1);
            String sitePath = path.substring(i1 + 1);
            if (sitePath.length() == 0) {
                sitePath = "/index.html";
            }
            sitePath = sitePath.replace('/', File.separatorChar);
            File siteFile = new File(new File(this.environment.pluginsFile(), pluginName), "_site");
            File file = new File(siteFile, sitePath);
            if (!file.exists() || file.isHidden()) {
                response.setStatus(HttpStatus.NOT_FOUND_404);
                return;
            }
            if (!file.isFile()) {
                if (!file.isDirectory()) {
                    response.setStatus(HttpStatus.FORBIDDEN_403);
                    return;
                }
                if (!(file = new File(file, "index.html")).exists() || file.isHidden() || !file.isFile()) {
                    response.setStatus(HttpStatus.FORBIDDEN_403);
                    return;
                }
            }
            if (!file.getAbsolutePath().startsWith(siteFile.getAbsolutePath())) {
                response.setStatus(HttpStatus.FORBIDDEN_403);
                return;
            }
            this.sendFile(response, file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendFile(Response response, File file) throws IOException {
            String path = file.getPath();
            FileInputStream fis = new FileInputStream(file);
            try {
                int rd;
                String substr;
                response.setStatus(HttpStatus.OK_200);
                int dot = path.lastIndexOf(46);
                if (dot < 0) {
                    substr = file.toString();
                    dot = substr.lastIndexOf(46);
                } else {
                    substr = path;
                }
                if (dot > 0) {
                    String ext = substr.substring(dot + 1);
                    String ct = MimeType.get((String)ext);
                    if (ct != null) {
                        response.setContentType(ct);
                    }
                } else {
                    response.setContentType(MimeType.get((String)"html"));
                }
                long length = file.length();
                response.setContentLengthLong(length);
                OutputBuffer outputBuffer = response.getOutputBuffer();
                byte[] b = new byte[8192];
                while ((rd = fis.read(b)) > 0) {
                    outputBuffer.write(b, 0, rd);
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

