/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.mbeans;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.api.performance.PerformanceMeasurementService;
import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.impl.administration.AdministrationServiceImpl;
import com.sun.esb.management.impl.configuration.ConfigurationServiceImpl;
import com.sun.esb.management.impl.deployment.DeploymentServiceImpl;
import com.sun.esb.management.impl.installation.InstallationServiceImpl;
import com.sun.esb.management.impl.performance.PerformanceMeasurementServiceImpl;
import com.sun.esb.management.impl.runtime.RuntimeManagementServiceImpl;
import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.common.Util;
import com.sun.jbi.ui.runtime.ComponentConfiguration;
import com.sun.jbi.ui.runtime.ComponentConfigurationParser;
import com.sun.jbi.ui.runtime.DisplayInformation;
import com.sun.jbi.util.ComponentConfigurationHelper;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AbstractUIMBeanImpl {
    protected static final String STARTED_STATE = "Started";
    protected static final String RUNNING_STATE = "Running";
    private static final String EQUAL = "=";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final char PASSWORD_MASK_CHARACTER = '*';
    private static final String ENVIRONMENT_VARIABLES_KEY = "EnvironmentVariables";
    protected static final String COMPONENT_CONFIG_INSTANCE_ERROR_KEY = "com.sun.jbi.cluster.instance.error";
    protected static final int ANY_FRAMEWORK_COMPONENT_STATE = -1;
    protected static final String FRAMEWORK_SA_STARTED_STATE = "Started";
    protected static final String FRAMEWORK_SA_STOPPED_STATE = "Stopped";
    protected static final String FRAMEWORK_SA_SHUTDOWN_STATE = "Shutdown";
    protected static final String FRAMEWORK_SA_ANY_STATE = "any";
    protected static final String FRAMEWORK_SU_STARTED_STATE = "started";
    protected static final String FRAMEWORK_SU_STOPPED_STATE = "stopped";
    protected static final String FRAMEWORK_SU_SHUTDOWN_STATE = "shutdown";
    protected static final String FRAMEWORK_SU_UNKNOWN_STATE = "unknown";
    private static I18NBundle sI18NBundle = null;
    protected EnvironmentContext mEnvContext;
    protected ComponentConfigurationHelper mCfgHlpr;
    protected transient AdministrationService administrationService;
    protected transient ConfigurationService configurationService;
    protected transient DeploymentService deploymentService;
    protected transient InstallationService installationService;
    protected transient RuntimeManagementService runtimeManagementService;
    protected transient PerformanceMeasurementService performanceMeasurementService;
    protected static final String COMPONENT_VERSION_NS = "http://www.sun.com/jbi/descriptor/identification";
    protected static final String COMPONENT_VERSION_NS_NEW = "http://www.sun.com/jbi/descriptor/identification/V1.0";
    protected static final String COMPONENT_VERSION_XPATH_QUERY = "/jbi:jbi/jbi:component/jbi:identification/identification:VersionInfo";
    protected static final String SHARED_LIBRARY_VERSION_XPATH_QUERY = "/jbi:jbi/jbi:shared-library/jbi:identification/identification:VersionInfo";

    public AbstractUIMBeanImpl(EnvironmentContext anEnvContext) {
        this.mEnvContext = anEnvContext;
        this.mCfgHlpr = new ComponentConfigurationHelper();
    }

    protected AdministrationService getAdministrationService() {
        if (this.administrationService == null) {
            MBeanServer server = this.mEnvContext.getMBeanServer();
            boolean isRemoteConnection = false;
            this.administrationService = new AdministrationServiceImpl(server, isRemoteConnection);
        }
        return this.administrationService;
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            boolean isRemoteConnection = false;
            MBeanServer server = this.mEnvContext.getMBeanServer();
            this.configurationService = new ConfigurationServiceImpl(server, isRemoteConnection);
        }
        return this.configurationService;
    }

    protected DeploymentService getDeploymentService() {
        if (this.deploymentService == null) {
            MBeanServer server = this.mEnvContext.getMBeanServer();
            boolean isRemoteConnection = false;
            this.deploymentService = new DeploymentServiceImpl(server, isRemoteConnection);
        }
        return this.deploymentService;
    }

    protected InstallationService getInstallationService() {
        if (this.installationService == null) {
            MBeanServer server = this.mEnvContext.getMBeanServer();
            boolean isRemoteConnection = false;
            this.installationService = new InstallationServiceImpl(server, isRemoteConnection);
        }
        return this.installationService;
    }

    protected RuntimeManagementService getRuntimeManagementService() {
        if (this.runtimeManagementService == null) {
            MBeanServer server = this.mEnvContext.getMBeanServer();
            boolean isRemoteConnection = false;
            this.runtimeManagementService = new RuntimeManagementServiceImpl(server, isRemoteConnection);
        }
        return this.runtimeManagementService;
    }

    protected PerformanceMeasurementService getPerformanceMeasurementService() {
        if (this.performanceMeasurementService == null) {
            MBeanServer server = this.mEnvContext.getMBeanServer();
            boolean isRemoteConnection = false;
            this.performanceMeasurementService = new PerformanceMeasurementServiceImpl(server, isRemoteConnection);
        }
        return this.performanceMeasurementService;
    }

    public static void log(String aMsg) {
        ToolsLogManager.getRuntimeLogger().info(aMsg);
    }

    public static void logDebug(String aMsg) {
        ToolsLogManager.getRuntimeLogger().fine(aMsg);
    }

    public static void logDebug(Exception ex) {
        ToolsLogManager.getRuntimeLogger().log(Level.FINER, ex.getMessage(), ex);
    }

    public static void logError(Exception ex) {
        ToolsLogManager.getRuntimeLogger().log(Level.SEVERE, ex.getMessage(), ex);
    }

    public static void logWarning(Exception ex) {
        ToolsLogManager.getRuntimeLogger().log(Level.WARNING, ex.getMessage(), ex);
    }

    protected PlatformContext getPlatformContext() {
        PlatformContext platformContext = null;
        EnvironmentContext context = AbstractUIMBeanImpl.getEnvironmentContext();
        if (context != null) {
            platformContext = context.getPlatformContext();
        }
        return platformContext;
    }

    protected static EnvironmentContext getEnvironmentContext() {
        return EnvironmentAccess.getContext();
    }

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.runtime.mbeans");
        }
        return sI18NBundle;
    }

    protected Object getAttributeValue(MBeanServer mbeanServer, ObjectName objectName, String attributeName) throws JBIRemoteException {
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    protected Object getAttributeValue(ObjectName objectName, String attributeName) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    protected void setAttributeValue(ObjectName objectName, String attributeName, Object attributeValue) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Attribute attribute = null;
        attribute = new Attribute(attributeName, attributeValue);
        try {
            mbeanServer.setAttribute(objectName, attribute);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.invoke(objectName, operationName, params, signature);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, String param) throws JBIRemoteException {
        Object[] params = new Object[]{param};
        String[] signature = new String[]{"java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName) throws JBIRemoteException {
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    protected Object getMBeanAttribute(ObjectName objectName, String attributeName) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    protected MBeanInfo getMBeanInfo(ObjectName mbeanName) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        try {
            return mbeanServer.getMBeanInfo(mbeanName);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    boolean isMBeanRegistered(ObjectName objectName) throws JBIRemoteException {
        boolean result = false;
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        try {
            result = mbeanServer.isRegistered(objectName);
        }
        catch (RuntimeException exception) {
            throw JBIRemoteException.filterJmxExceptions(exception);
        }
        return result;
    }

    boolean isValidTarget(ObjectName objectName) throws JBIRemoteException {
        boolean result = false;
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        try {
            result = mbeanServer.isRegistered(objectName);
        }
        catch (RuntimeException exception) {
            // empty catch block
        }
        return result;
    }

    boolean isValidTarget(String target) throws JBIRemoteException {
        if (this.getPlatformContext().isStandaloneServer(target)) {
            return true;
        }
        if (this.getPlatformContext().isCluster(target)) {
            return true;
        }
        if (this.getPlatformContext().isClusteredServer(target)) {
            return true;
        }
        return true == "domain".equals(target);
    }

    protected void setMBeanAttribute(ObjectName objectName, String attributeName, Object attributeValue) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        try {
            Attribute attr = new Attribute(attributeName, attributeValue);
            mbeanServer.setAttribute(objectName, attr);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    protected void setMBeanAttributes(ObjectName objectName, AttributeList attrList) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        try {
            mbeanServer.setAttributes(objectName, attrList);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    protected String setMBeanConfigAttributes(ObjectName objectName, AttributeList attrList) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        return this.setMBeanConfigAttributes(mbeanServer, objectName, attrList);
    }

    protected String setMBeanConfigAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, AttributeList attrList) throws JBIRemoteException {
        try {
            return (String)mbeanServer.invoke(objectName, "setConfigurationAttributes", new Object[]{attrList}, new String[]{"javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    protected AttributeList setMBeanAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, AttributeList attrList) throws JBIRemoteException {
        try {
            return mbeanServer.setAttributes(objectName, attrList);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    protected Properties getConfigurationAttributeValues(ObjectName objectName) throws JBIRemoteException {
        Properties properties = new Properties();
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        try {
            properties = this.getMBeanAttributeValues(mbeanServer, objectName);
        }
        catch (JBIRemoteException exception) {
            properties = new Properties();
            JBIManagementMessage mgmtMsg = null;
            mgmtMsg = exception.extractJBIManagementMessage();
            properties.setProperty(COMPONENT_CONFIG_INSTANCE_ERROR_KEY, mgmtMsg.getMessage());
        }
        return properties;
    }

    protected Properties getMBeanAttributeValues(MBeanServer mbeanServer, ObjectName objectName) throws JBIRemoteException {
        Properties properties = new Properties();
        ArrayList<String> keyList = new ArrayList<String>();
        MBeanInfo mbeanInfo = null;
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                Object value;
                String key = attributeInfo.getName();
                if (key == null || (value = this.getAttributeValue(objectName, key)) == null || key.equals("ApplicationVariables") || key.equals("ApplicationConfigurations")) continue;
                properties.put(key, value + "");
                keyList.add(key);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (IntrospectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        return properties;
    }

    protected Map<String, Descriptor> getConfigurationDescriptors(ObjectName objectName) throws JBIRemoteException {
        HashMap<String, Descriptor> descrMap = new HashMap<String, Descriptor>();
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        MBeanInfo mbeanInfo = null;
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo)) continue;
                ModelMBeanAttributeInfo modelAttrInfo = (ModelMBeanAttributeInfo)attributeInfo;
                descrMap.put(modelAttrInfo.getName(), modelAttrInfo.getDescriptor());
            }
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (IntrospectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        return descrMap;
    }

    protected AttributeList constructMBeanAttributes(ObjectName objectName, Properties params) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        AttributeList attrList = new AttributeList();
        try {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> attribInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (int i = 0; i < mbeanAttrInfoArray.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mbeanAttrInfoArray[i];
                attribInfoMap.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
            }
            for (String string : params.keySet()) {
                String stringValue = params.getProperty(string);
                Object attrValueObj = null;
                if (attribInfoMap.isEmpty()) {
                    attrValueObj = stringValue;
                } else {
                    MBeanAttributeInfo attrInfo = (MBeanAttributeInfo)attribInfoMap.get(string);
                    if (attrInfo == null) {
                        String[] args = new String[]{string};
                        Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.info.not.found", args, null);
                        throw new JBIRemoteException(exception);
                    }
                    String type = attrInfo.getType();
                    try {
                        attrValueObj = Util.newInstance(type, stringValue);
                    }
                    catch (Exception ex) {
                        String[] args = new String[]{stringValue, type, string};
                        Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                        throw new JBIRemoteException(exception);
                    }
                }
                Attribute attr = new Attribute(string, attrValueObj);
                attrList.add(attr);
            }
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return attrList;
    }

    protected AttributeList constructMBeanAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, Properties params) throws JBIRemoteException {
        AttributeList attrList = new AttributeList();
        try {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> attribInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (int i = 0; i < mbeanAttrInfoArray.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mbeanAttrInfoArray[i];
                attribInfoMap.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
            }
            for (String string : params.keySet()) {
                String stringValue = params.getProperty(string);
                Object attrValueObj = null;
                MBeanAttributeInfo attrInfo = (MBeanAttributeInfo)attribInfoMap.get(string);
                if (attrInfo == null) {
                    String[] args = new String[]{string};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.info.not.found", args, null);
                    throw new JBIRemoteException(exception);
                }
                String type = attrInfo.getType();
                try {
                    attrValueObj = Util.newInstance(type, stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, string};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
                Attribute attr = new Attribute(string, attrValueObj);
                attrList.add(attr);
            }
            return attrList;
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    Exception createManagementException(String bundleKey, String[] args, Exception sourceException) {
        Exception exception = null;
        String xmlManagementMessage = JBIResultXmlBuilder.createJbiResultXml(AbstractUIMBeanImpl.getI18NBundle(), bundleKey, args, sourceException);
        exception = new Exception(xmlManagementMessage);
        return exception;
    }

    String createManagementMessage(String taskId, boolean successResult, String msgType, String msgCode, Object[] args) {
        String msg = AbstractUIMBeanImpl.getI18NBundle().getMessage(msgCode, args);
        String xmlManagementMessage = JBIResultXmlBuilder.getInstance().createJbiResultXml(taskId, successResult, msgType, msgCode, msg, args);
        return xmlManagementMessage;
    }

    public boolean isSharedLibraryArchive(String zipPath) {
        try {
            JBIArchive jbiZip = new JBIArchive(zipPath);
            return jbiZip.isSharedLibraryArchive();
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.logDebug(ex);
            return false;
        }
    }

    protected String getComponentNameFromJmxObjectName(ObjectName jmxObjectName) {
        String componentName = null;
        try {
            componentName = jmxObjectName.getKeyProperty("ComponentName");
        }
        catch (NullPointerException nullEx) {
            componentName = null;
        }
        return componentName;
    }

    public ObjectName getAdminServiceMBeanObjectName() throws JBIRemoteException {
        try {
            MBeanNames mbeanNames = this.mEnvContext.getMBeanNames();
            return mbeanNames.getSystemServiceMBeanName("AdminService", "AdministrationService");
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
    }

    public ObjectName getInstallationServiceMBeanObjectName() {
        MBeanNames mbeanNames = this.mEnvContext.getMBeanNames();
        return mbeanNames.getSystemServiceMBeanName("InstallationService", "InstallationService");
    }

    public ObjectName getInstallationServiceMBeanObjectName(String targetName) {
        MBeanNames mbeanNames = this.mEnvContext.getMBeanNames();
        return mbeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, targetName);
    }

    public ObjectName getDeploymentServiceMBeanObjectName(String targetName) {
        MBeanNames mbeanNames = this.mEnvContext.getMBeanNames();
        return mbeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, targetName);
    }

    public ObjectName getLoggingServiceMBeanObjectName(String targetName) {
        MBeanNames mbeanNames = this.mEnvContext.getMBeanNames();
        ObjectName loggingMBeanObjectName = mbeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, MBeanNames.ServiceType.Logger, targetName);
        return loggingMBeanObjectName;
    }

    public ObjectName[] getSystemLoggerMBeans(String instanceName) {
        MBeanNames mbn = this.mEnvContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + COLON + "JbiName" + EQUAL + instanceName;
        tmp = tmp + COMMA + "ComponentType" + EQUAL + "System";
        tmp = tmp + COMMA + "ControlType" + EQUAL + "Logger";
        tmp = tmp + ",*";
        ObjectName mbeanPattern = null;
        try {
            mbeanPattern = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException mex) {
            AbstractUIMBeanImpl.logDebug(mex.getMessage());
            return new ObjectName[0];
        }
        Set<ObjectName> resultSet = this.mEnvContext.getMBeanServer().queryNames(mbeanPattern, null);
        ObjectName[] names = new ObjectName[]{};
        if (!resultSet.isEmpty()) {
            names = resultSet.toArray(names);
        } else {
            AbstractUIMBeanImpl.logDebug("Logger MBeans with ObjectName pattern " + tmp + " not found.");
        }
        return names;
    }

    public ObjectName getConfigurationMBeanObjectName(String targetName, String configurationType) throws JBIRemoteException {
        ObjectName configurationMBeanObjectName = null;
        String objectNameString = "com.sun.jbi:Target=" + targetName + COMMA + "ServiceName" + EQUAL + "ConfigurationService" + COMMA + "ServiceType" + EQUAL + configurationType;
        try {
            configurationMBeanObjectName = new ObjectName(objectNameString);
        }
        catch (MalformedObjectNameException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (NullPointerException exception) {
            throw new JBIRemoteException(exception);
        }
        return configurationMBeanObjectName;
    }

    List getComponentConfigurationPasswordFields(String xmlDataString, String[] keys) throws JBIRemoteException {
        ArrayList<String> passwordFieldList = new ArrayList<String>();
        ComponentConfiguration configuration = null;
        ComponentConfigurationParser parser = null;
        try {
            parser = ComponentConfigurationParser.parseFromString(xmlDataString, keys);
            configuration = parser.getComponentConfiguration();
            if (configuration != null) {
                Map.Entry<String, DisplayInformation> entry2 = null;
                String key = null;
                DisplayInformation value = null;
                Set<Map.Entry<String, DisplayInformation>> set = configuration.getDisplayDetailsMap().entrySet();
                for (Map.Entry<String, DisplayInformation> entry2 : set) {
                    if (entry2 == null) continue;
                    key = entry2.getKey();
                    value = entry2.getValue();
                    if (value == null || !value.isPasswordField()) continue;
                    passwordFieldList.add(key);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new JBIRemoteException(e);
        }
        catch (ParserConfigurationException e) {
            throw new JBIRemoteException(e);
        }
        catch (SAXException e) {
            throw new JBIRemoteException(e);
        }
        catch (URISyntaxException e) {
            throw new JBIRemoteException(e);
        }
        catch (IOException e) {
            throw new JBIRemoteException(e);
        }
        return passwordFieldList;
    }

    String getComponentConfigurationDisplayData(MBeanServer server, ObjectName objectName) throws JBIRemoteException {
        Object[] params = null;
        String[] signature = null;
        String xmlDataString = "";
        try {
            xmlDataString = (String)server.invoke(objectName, "retrieveConfigurationDisplayData", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        return xmlDataString;
    }

    String getComponentConfigurationDisplaySchema(MBeanServer server, ObjectName objectName) throws JBIRemoteException {
        Object[] params = null;
        String[] signature = null;
        String xmlSchemaString = "";
        try {
            xmlSchemaString = (String)server.invoke(objectName, "retrieveConfigurationDisplaySchema", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        return xmlSchemaString;
    }

    String getComponentConfigurationDisplayData(MBeanServerConnection connection, ObjectName objectName) throws JBIRemoteException {
        Object[] params = null;
        String[] signature = null;
        String xmlDataString = "";
        try {
            xmlDataString = (String)connection.invoke(objectName, "retrieveConfigurationDisplayData", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (IOException e) {
            throw new JBIRemoteException(e);
        }
        return xmlDataString;
    }

    String getComponentConfigurationDisplaySchema(MBeanServerConnection connection, ObjectName objectName) throws JBIRemoteException {
        Object[] params = null;
        String[] signature = null;
        String xmlSchemaString = "";
        try {
            xmlSchemaString = (String)connection.invoke(objectName, "retrieveConfigurationDisplaySchema", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (IOException e) {
            throw new JBIRemoteException(e);
        }
        return xmlSchemaString;
    }

    protected Properties getMBeanAttributeValues(MBeanServerConnection connection, ObjectName objectName) throws JBIRemoteException {
        Properties properties = new Properties();
        ArrayList<String> keyList = new ArrayList<String>();
        MBeanInfo mbeanInfo = null;
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            mbeanInfo = connection.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                String key = attributeInfo.getName();
                if (key == null) continue;
                Object value = null;
                try {
                    value = connection.getAttribute(objectName, key);
                }
                catch (AttributeNotFoundException e) {
                    throw new JBIRemoteException(e);
                }
                catch (InstanceNotFoundException e) {
                    throw new JBIRemoteException(e);
                }
                catch (MBeanException e) {
                    throw new JBIRemoteException(e);
                }
                catch (ReflectionException e) {
                    throw new JBIRemoteException(e);
                }
                if (value == null || key.equals("ApplicationVariables") || key.equals("ApplicationConfigurations")) continue;
                properties.put(key, value + "");
                keyList.add(key);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (IntrospectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        catch (IOException e) {
            throw new JBIRemoteException(e);
        }
        return properties;
    }

    String convertToEnvironmentVariableString(Object valueObject) {
        String result = "";
        TabularData tabularData = null;
        if (valueObject instanceof TabularData) {
            tabularData = (TabularData)valueObject;
            for (CompositeData compositeData : tabularData.values()) {
                CompositeType compositeType = compositeData.getCompositeType();
                Iterator<String> itemIterator = compositeType.keySet().iterator();
                while (itemIterator.hasNext()) {
                    String keyName = itemIterator.next();
                    String keyType = itemIterator.next();
                    String keyValue = itemIterator.next();
                    String name = (String)compositeData.get(keyName);
                    String type = (String)compositeData.get(keyType);
                    String value = (String)compositeData.get(keyValue);
                    result = result + "Name=" + name + ", Type=" + type + ", Value=" + value + "; ";
                }
            }
        }
        return result;
    }

    TabularData getEnvironmentVariables(Map<String, String[]> environmentVariableMap, CompositeType environmentVariableRowType) throws OpenDataException {
        TabularData tabularData = this.createEnvironmentVariableTabularStructure();
        for (String name : environmentVariableMap.keySet()) {
            String[] metadata = environmentVariableMap.get(name);
            String value = metadata[0];
            String type = metadata[1];
            Object[] data = new Object[]{name, value, type};
            CompositeDataSupport rowData = new CompositeDataSupport(environmentVariableRowType, new String[]{"name", "value", "type"}, data);
            tabularData.put(rowData);
        }
        return tabularData;
    }

    Map<String, String[]> setEnvironmentVariables(TabularData tabularDataIn) throws InvalidAttributeValueException, OpenDataException, MBeanException {
        String attrName = ENVIRONMENT_VARIABLES_KEY;
        HashMap<String, String[]> environmentVariableMap = new HashMap<String, String[]>();
        String mapKey = null;
        TabularData newTabularData = tabularDataIn;
        ArrayList<String> items = new ArrayList<String>();
        CompositeType rowType = tabularDataIn.getTabularType().getRowType();
        try {
            newTabularData = tabularDataIn;
        }
        catch (Exception ex) {
            throw new InvalidAttributeValueException("Invalid arguments");
        }
        for (String item : rowType.keySet()) {
            items.add(item);
        }
        int itemSize = items.size();
        if (itemSize != 3) {
            throw new InvalidAttributeValueException("Invalid Item Size: " + itemSize);
        }
        List<String> rowIndex = tabularDataIn.getTabularType().getIndexNames();
        int rowIndexSize = rowIndex.size();
        if (rowIndexSize > 1) {
            throw new InvalidAttributeValueException("Invalid Row Index Size: " + rowIndexSize);
        }
        if (rowIndex.size() <= 0) {
            throw new InvalidAttributeValueException("Invalid Row Index Size: " + rowIndexSize);
        }
        mapKey = rowIndex.get(0);
        if (mapKey == null || "".equals(mapKey)) {
            throw new InvalidAttributeValueException("Invalid Row Index Key: " + mapKey);
        }
        for (CompositeData rowData : tabularDataIn.values()) {
            String name = null;
            String value = null;
            String type = null;
            ListIterator itemIt = items.listIterator();
            while (itemIt.hasNext()) {
                String item = (String)itemIt.next();
                if (mapKey.equals(item)) {
                    name = (String)rowData.get(item);
                    continue;
                }
                if ("value".equals(item)) {
                    value = (String)rowData.get(item);
                    continue;
                }
                type = (String)rowData.get(item);
            }
            environmentVariableMap.put(name, new String[]{value, type});
        }
        return environmentVariableMap;
    }

    TabularData createEnvironmentVariableTabularStructure() throws OpenDataException {
        TabularDataSupport tabularData = null;
        CompositeType mEnvVarRowType = null;
        TabularType mEnvVarTabularType = null;
        String[] envVarRowAttrNames = new String[]{"name", "value", "type"};
        String[] envVarRowAttrDesc = new String[]{"Environment variable name", "Environment variable value", "Environment variable type"};
        OpenType[] envVarRowAttrTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        String[] envVarRowIndex = new String[]{"name"};
        if (mEnvVarRowType == null) {
            mEnvVarRowType = new CompositeType("NameValuePair", "Environment variable name and value pair", envVarRowAttrNames, envVarRowAttrDesc, envVarRowAttrTypes);
        }
        if (mEnvVarTabularType == null) {
            mEnvVarTabularType = new TabularType("EnvironmentVariableList", "List of environment name and value pairs", mEnvVarRowType, envVarRowIndex);
        }
        tabularData = new TabularDataSupport(mEnvVarTabularType);
        return tabularData;
    }

    String maskSensitiveString(String sensitiveString, char maskCharacter) {
        String result = "";
        if (sensitiveString == null) {
            return result;
        }
        for (int index = 0; index < sensitiveString.length(); ++index) {
            result = result + maskCharacter;
        }
        return result;
    }

    Map<String, Properties> getComponentConfigurationProperties(String componentName, String targetName) {
        Map<String, Map<MBeanServerConnection, ObjectName>> targetInstanceMap = null;
        Map<MBeanServerConnection, ObjectName> serverObjectNameMap = null;
        HashMap<String, Properties> result = null;
        result = new HashMap<String, Properties>();
        try {
            targetInstanceMap = this.getComponentConfigurationMBeanNamesPerTargetInstance(componentName, targetName);
            for (Map.Entry<String, Map<MBeanServerConnection, ObjectName>> entry : targetInstanceMap.entrySet()) {
                String targetInstanceName = entry.getKey();
                if (targetInstanceName == null || (serverObjectNameMap = entry.getValue()) == null) continue;
                MBeanServerConnection connection = null;
                ObjectName objectName = null;
                for (Map.Entry<MBeanServerConnection, ObjectName> innerEntry : serverObjectNameMap.entrySet()) {
                    connection = innerEntry.getKey();
                    objectName = innerEntry.getValue();
                    if (connection == null || objectName == null) continue;
                    Properties properties = null;
                    try {
                        properties = this.getMBeanAttributeValues(connection, objectName);
                        result.put(targetInstanceName, properties);
                    }
                    catch (JBIRemoteException exception) {
                        properties = new Properties();
                        JBIManagementMessage mgmtMsg = null;
                        mgmtMsg = exception.extractJBIManagementMessage();
                        properties.setProperty(COMPONENT_CONFIG_INSTANCE_ERROR_KEY, mgmtMsg.getMessage());
                        result.put(targetInstanceName, properties);
                    }
                }
            }
        }
        catch (IOException e) {
        }
        catch (JBIRemoteException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    Properties setComponentConfigurationProperties(String componentName, Properties configurationValues, String targetName) throws JBIRemoteException {
        Map<String, Map<MBeanServerConnection, ObjectName>> targetInstanceMap = null;
        Map<MBeanServerConnection, ObjectName> serverObjectNameMap = null;
        AttributeList list = null;
        Properties result = new Properties();
        try {
            targetInstanceMap = this.getComponentConfigurationMBeanNamesPerTargetInstance(componentName, targetName);
            for (Map.Entry<String, Map<MBeanServerConnection, ObjectName>> entry : targetInstanceMap.entrySet()) {
                String targetInstanceName = entry.getKey();
                if (targetInstanceName == null || (serverObjectNameMap = entry.getValue()) == null) continue;
                MBeanServerConnection connection = null;
                ObjectName objectName = null;
                for (Map.Entry<MBeanServerConnection, ObjectName> innerEntry : serverObjectNameMap.entrySet()) {
                    connection = innerEntry.getKey();
                    objectName = innerEntry.getValue();
                    if (connection == null || objectName == null) continue;
                    try {
                        list = this.constructMBeanAttributes(connection, objectName, configurationValues);
                        this.setMBeanAttributes(connection, objectName, list);
                        result.put(targetInstanceName, componentName);
                    }
                    catch (Exception ex) {
                        Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.set.attrs.error", null, ex);
                        JBIRemoteException remoteException = new JBIRemoteException(exception);
                        result.put(targetInstanceName, remoteException.getMessage());
                    }
                }
            }
        }
        catch (IOException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (Exception exception) {
            throw new JBIRemoteException(exception);
        }
        return result;
    }

    private Map<String, Map<MBeanServerConnection, ObjectName>> getComponentConfigurationMBeanNamesPerTargetInstance(String componentName, String targetName) throws IOException, Exception {
        HashMap<String, Map<MBeanServerConnection, ObjectName>> result;
        block3: {
            Set<ObjectName> objectNameSet;
            MBeanServerConnection server;
            PlatformContext platformContext;
            ObjectName objectNameFilter;
            HashMap<MBeanServerConnection, ObjectName> serverObjectNameMap;
            block4: {
                result = null;
                serverObjectNameMap = null;
                result = new HashMap<String, Map<MBeanServerConnection, ObjectName>>();
                serverObjectNameMap = new HashMap<MBeanServerConnection, ObjectName>();
                String name = "com.sun.ebi:ServiceType=Configuration,IdentificationName=" + componentName + ",*";
                objectNameFilter = new ObjectName(name);
                platformContext = this.getPlatformContext();
                server = null;
                objectNameSet = null;
                if (platformContext == null || !platformContext.isValidTarget(targetName)) break block3;
                if (!platformContext.isStandaloneServer(targetName)) break block4;
                server = platformContext.getMBeanServerConnection(targetName);
                if (server == null) break block3;
                objectNameSet = server.queryNames(objectNameFilter, null);
                for (ObjectName objectName : objectNameSet) {
                    if (objectName == null) continue;
                    serverObjectNameMap.put(server, objectName);
                    result.put(targetName, serverObjectNameMap);
                    break block3;
                }
                break block3;
            }
            Set<String> targetInstanceNames = platformContext.getServersInCluster(targetName);
            block1: for (String targetInstanceName : targetInstanceNames) {
                if (targetInstanceName == null || (server = platformContext.getMBeanServerConnection(targetInstanceName)) == null) continue;
                objectNameSet = server.queryNames(objectNameFilter, null);
                for (ObjectName objectName : objectNameSet) {
                    if (objectName == null) continue;
                    serverObjectNameMap.put(server, objectName);
                    result.put(targetInstanceName, serverObjectNameMap);
                    continue block1;
                }
            }
        }
        return result;
    }

    public ObjectName getExtensionMBeanObjectName(String componentName, String targetName) throws JBIRemoteException {
        ObjectName extensionMBeanObjectNamePattern = null;
        MBeanNames mbeanNames = this.mEnvContext.getMBeanNames();
        String objectNamePatternString = "com.sun.jbi:Target=" + targetName + COMMA + "ComponentName" + EQUAL + componentName + COMMA + "ServiceType" + EQUAL + (Object)((Object)MBeanNames.ComponentServiceType.Extension);
        try {
            extensionMBeanObjectNamePattern = new ObjectName(objectNamePatternString);
        }
        catch (MalformedObjectNameException exception) {
            return null;
        }
        catch (NullPointerException exception) {
            return null;
        }
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(extensionMBeanObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            String[] args = new String[]{componentName, extensionMBeanObjectNamePattern.toString()};
            Exception exception = this.createManagementException("ui.mbean.extension.mbean.not.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        if (objectNames.size() > 1) {
            String[] args = new String[]{componentName, extensionMBeanObjectNamePattern.toString()};
            Exception exception = this.createManagementException("ui.mbean.extension.mbean.not.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        ObjectName extensionMBeanObjectName = null;
        extensionMBeanObjectName = objectNames.iterator().next();
        AbstractUIMBeanImpl.logDebug("extensionMBeanObjectName Found : " + extensionMBeanObjectName);
        return extensionMBeanObjectName;
    }

    Map<String, Properties> getRuntimeConfigurationMetadataInternal(String targetName) throws JBIRemoteException {
        Object value;
        String[] fields;
        Descriptor descriptor;
        String attributeName;
        Properties properties = null;
        HashMap<String, Properties> result = null;
        result = new HashMap<String, Properties>();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        Object attributeValueObject = null;
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        MBeanAttributeInfo[] installationAttributes = mbeanInstallationInfo.getAttributes();
        MBeanAttributeInfo[] deploymentAttributes = mbeanDeploymentInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName = attributeInfo.getName();
                if (attributeName == null) continue;
                properties = new Properties();
                if (attributeInfo instanceof ModelMBeanAttributeInfo) {
                    descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor();
                    for (String fieldName : fields = descriptor.getFieldNames()) {
                        value = descriptor.getFieldValue(fieldName);
                        if (fieldName == null || value == null) continue;
                        properties.setProperty(fieldName, value + "");
                    }
                }
                result.put(attributeName, properties);
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName = attributeInfo.getName();
                if (attributeName == null) continue;
                properties = new Properties();
                if (attributeInfo instanceof ModelMBeanAttributeInfo) {
                    descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor();
                    for (String fieldName : fields = descriptor.getFieldNames()) {
                        value = descriptor.getFieldValue(fieldName);
                        if (fieldName == null || value == null) continue;
                        properties.setProperty(fieldName, value + "");
                    }
                }
                result.put(attributeName, properties);
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName = attributeInfo.getName();
                if (attributeName == null) continue;
                properties = new Properties();
                if (attributeInfo instanceof ModelMBeanAttributeInfo) {
                    descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor();
                    for (String fieldName : fields = descriptor.getFieldNames()) {
                        value = descriptor.getFieldValue(fieldName);
                        if (fieldName == null || value == null) continue;
                        properties.setProperty(fieldName, value + "");
                    }
                }
                result.put(attributeName, properties);
            }
        }
        return result;
    }

    boolean setRuntimeConfigurationInternal(Properties properties, String targetName) throws JBIRemoteException {
        String type;
        String stringValue;
        String attributeName;
        String type2;
        String stringValue2;
        String attributeName2;
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, "System");
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, "Installation");
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, "Deployment");
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        Object attributeValueObject = null;
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        MBeanAttributeInfo[] installationAttributes = mbeanInstallationInfo.getAttributes();
        MBeanAttributeInfo[] deploymentAttributes = mbeanDeploymentInfo.getAttributes();
        HashMap<String, Object> attributeNameTypeMap = new HashMap<String, Object>();
        Properties metaDataProperties = null;
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName2 = attributeInfo.getName();
                stringValue2 = properties.getProperty(attributeName2);
                if (stringValue2 == null) continue;
                type2 = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance(type2, stringValue2);
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue2, type2, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName2 = attributeInfo.getName();
                stringValue2 = properties.getProperty(attributeName2);
                if (stringValue2 == null) continue;
                type2 = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance(type2, stringValue2);
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue2, type2, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName2 = attributeInfo.getName();
                stringValue2 = properties.getProperty(attributeName2);
                if (stringValue2 == null) continue;
                type2 = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance(type2, stringValue2);
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue2, type2, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
            }
        }
        Set<Object> keySet = properties.keySet();
        Set attributeSet = attributeNameTypeMap.keySet();
        for (Object keyObject : keySet) {
            String key = (String)keyObject;
            if (attributeSet.contains(key)) continue;
            String[] args = new String[]{key};
            Exception exception = this.createManagementException("ui.mbean.runtime.config.mbean.attrib.key.invalid.error", args, null);
            throw new JBIRemoteException(exception);
        }
        String IS_STATIC_KEY = "isStatic";
        boolean isRestartRequired = false;
        Map<String, Properties> metadata = null;
        metadata = this.getRuntimeConfigurationMetadataInternal(targetName);
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName = attributeInfo.getName();
                stringValue = properties.getProperty(attributeName);
                if (stringValue == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance(type, stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, attributeName};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
                this.setAttributeValue(systemObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName = attributeInfo.getName();
                stringValue = properties.getProperty(attributeName);
                if (stringValue == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance(type, stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, attributeName};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
                this.setAttributeValue(installationObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName = attributeInfo.getName();
                stringValue = properties.getProperty(attributeName);
                if (stringValue == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance(type, stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, attributeName};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new JBIRemoteException(exception);
                }
                this.setAttributeValue(deploymentObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        return isRestartRequired;
    }

    Properties getDefaultRuntimeConfigurationInternal(String targetName) throws JBIRemoteException {
        MBeanAttributeInfo[] deploymentAttributes;
        MBeanAttributeInfo[] installationAttributes;
        String DEFAULT_VALUE_KEY = "default";
        Properties properties = new Properties();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo)) continue;
                Descriptor descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor();
                for (String fieldName : fields = descriptor.getFieldNames()) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.setProperty(attributeName, value + "");
                }
            }
        }
        if ((installationAttributes = mbeanInstallationInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo)) continue;
                Descriptor descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor();
                for (String fieldName : fields = descriptor.getFieldNames()) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.setProperty(attributeName, value + "");
                }
            }
        }
        if ((deploymentAttributes = mbeanDeploymentInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo)) continue;
                Descriptor descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor();
                for (String fieldName : fields = descriptor.getFieldNames()) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.setProperty(attributeName, value + "");
                }
            }
        }
        return properties;
    }

    Properties getRuntimeConfigurationInternal(String targetName) throws JBIRemoteException {
        MBeanAttributeInfo[] deploymentAttributes;
        MBeanAttributeInfo[] installationAttributes;
        Properties properties = new Properties();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (IntrospectionException exception) {
            throw new JBIRemoteException(exception);
        }
        catch (ReflectionException exception) {
            throw new JBIRemoteException(exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(systemObjectName, attributeName);
                properties.setProperty(attributeName, attributeValue + "");
            }
        }
        if ((installationAttributes = mbeanInstallationInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(installationObjectName, attributeName);
                properties.setProperty(attributeName, attributeValue + "");
            }
        }
        if ((deploymentAttributes = mbeanDeploymentInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(deploymentObjectName, attributeName);
                properties.setProperty(attributeName, attributeValue + "");
            }
        }
        return properties;
    }

    public ObjectName findDeployerMBean(String componentName) throws JBIRemoteException {
        ObjectName deployerObjectNamePattern = null;
        try {
            deployerObjectNamePattern = JBIJMXObjectNames.getComponentDeployerMBeanObjectNamePattern(componentName);
        }
        catch (MalformedObjectNameException ex) {
            throw new JBIRemoteException(ex);
        }
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(deployerObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            String[] args = new String[]{componentName, deployerObjectNamePattern.toString()};
            Exception exception = this.createManagementException("ui.mbean.deployer.mbean.not.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        if (objectNames.size() > 1) {
            String[] args = new String[]{componentName, deployerObjectNamePattern.toString()};
            Exception exception = this.createManagementException("ui.mbean.multiple.deployer.mbeans.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        ObjectName deployerObjectName = objectNames.iterator().next();
        AbstractUIMBeanImpl.logDebug("DeployerMBean Found : " + deployerObjectName);
        return deployerObjectName;
    }

    public ObjectName getComponentLifeCycleMBeanObjectName(String componentName, String targetName) throws JBIRemoteException {
        if (!this.isExistingComponent(componentName, targetName)) {
            String[] args = new String[]{componentName, targetName};
            Exception exception = this.createManagementException("ui.mbean.lifecycle.mbean.not.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        ObjectName lifecycleObjectNamePattern = null;
        try {
            lifecycleObjectNamePattern = JBIJMXObjectNames.getComponentLifeCycleMBeanObjectNamePattern(componentName, targetName);
        }
        catch (MalformedObjectNameException ex) {
            throw new JBIRemoteException(ex);
        }
        MBeanServer mbeanServer = this.mEnvContext.getMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(lifecycleObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            String[] args = new String[]{componentName, targetName};
            Exception exception = this.createManagementException("ui.mbean.lifecycle.mbean.not.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        if (objectNames.size() > 1) {
            String[] args = new String[]{componentName, targetName};
            Exception exception = this.createManagementException("ui.mbean.multiple.lifecycle.mbeans.found.with.query", args, null);
            throw new JBIRemoteException(exception);
        }
        ObjectName lifecyleObjectName = objectNames.iterator().next();
        AbstractUIMBeanImpl.logDebug("LifecyleMBean : " + lifecyleObjectName);
        return lifecyleObjectName;
    }

    protected ComponentQuery getFrameworkComponentQuery(String targetName) {
        ComponentQuery componentQuery = null;
        componentQuery = this.mEnvContext.getComponentQuery(targetName);
        return componentQuery;
    }

    public boolean isExistingComponent(String componentName, String targetName) {
        List list = new ArrayList();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        if (componentQuery != null) {
            list = componentQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        }
        return list.contains(componentName);
    }

    public boolean isExistingSharedLibrary(String sharedLibraryName, String targetName) {
        List list = new ArrayList();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        if (componentQuery != null) {
            list = componentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        }
        return list.contains(sharedLibraryName);
    }

    public Collection getComponentNamesDependentOnSharedLibrary(String slibName, String targetName) {
        List<Object> componentNames = new ArrayList();
        try {
            ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                componentNames = componentQuery.getDependentComponentIds(slibName);
            }
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.logDebug(ex);
        }
        return componentNames;
    }

    public Collection getComponentNamesDependentOnServiceAssembly(String saId, String targetName) {
        try {
            String[] componentNames = (String[])this.invokeMBeanOperation(this.getDeploymentServiceMBeanObjectName(targetName), "getComponentsForDeployedServiceAssembly", saId);
            if (componentNames == null) {
                componentNames = new String[]{};
            }
            return new HashSet<String>(Arrays.asList(componentNames));
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.logDebug(ex);
            return new HashSet();
        }
    }

    public Set getComponentNamesWithStatus(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String targetName) {
        List<Object> componentIdList = new ArrayList();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        if (componentQuery != null) {
            componentIdList = frameworkCompStatus == ComponentState.UNKNOWN ? componentQuery.getComponentIds(frameworkCompType) : componentQuery.getComponentIds(frameworkCompType, frameworkCompStatus);
        }
        return new HashSet(componentIdList);
    }

    public Collection getComponentNamesDependentOnServiceAssembly(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String saName, String targetName) {
        HashSet compNameSet = new HashSet(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus, targetName));
        HashSet saNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnServiceAssembly(saName, targetName));
        compNameSet.retainAll(saNameDepCompNameSet);
        return compNameSet;
    }

    public Collection getComponentNamesDependentOnSharedLibrary(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String slibName, String targetName) {
        HashSet compNameSet = new HashSet(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus, targetName));
        HashSet slibNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnSharedLibrary(slibName, targetName));
        compNameSet.retainAll(slibNameDepCompNameSet);
        return compNameSet;
    }

    public Collection getComponentNamesDependentOnSharedLibraryAndServiceAssembly(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String slibName, String saName, String targetName) {
        HashSet compNameSet = new HashSet(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus, targetName));
        HashSet slibNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnSharedLibrary(slibName, targetName));
        HashSet saNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnServiceAssembly(saName, targetName));
        slibNameDepCompNameSet.retainAll(saNameDepCompNameSet);
        compNameSet.retainAll(slibNameDepCompNameSet);
        return compNameSet;
    }

    protected void updateServiceUnitInfoState(ServiceUnitInfo suInfo, ObjectName deploymentServiceMBean) {
        suInfo.setState("Unknown");
        String compName = suInfo.getDeployedOn();
        String suName = suInfo.getName();
        try {
            if (deploymentServiceMBean == null) {
                AbstractUIMBeanImpl.logDebug("DeployerMBean not found for component " + compName);
                return;
            }
            Object[] params = new Object[]{compName, suName};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            String frameworkState = (String)this.invokeMBeanOperation(deploymentServiceMBean, "getServiceUnitState", params, signature);
            AbstractUIMBeanImpl.logDebug("Framework State = " + frameworkState + " for Service UNIT = " + suName);
            String uiState = AbstractUIMBeanImpl.toUiServiceUnitState(frameworkState);
            suInfo.setState(uiState);
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.log(this.getI18NBundle().getMessage("ui.mbean.exception.getting.service.unit.state", suName, compName, ex.getMessage()));
            AbstractUIMBeanImpl.logDebug(ex);
        }
    }

    protected void updateEachServiceUnitInfoStateInServiceAssemblyInfo(ServiceAssemblyInfo saInfo, String targetName) throws JBIRemoteException {
        List list = saInfo.getServiceUnitInfoList();
        if (list == null) {
            return;
        }
        ObjectName deploymentServiceMBean = this.getDeploymentServiceMBeanObjectName(targetName);
        for (ServiceUnitInfo suInfo : list) {
            this.updateServiceUnitInfoState(suInfo, deploymentServiceMBean);
        }
    }

    protected void updateServiceAssemblyInfoState(ServiceAssemblyInfo saInfo, String targetName) throws JBIRemoteException {
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        String saName = saInfo.getName();
        String frameworkState = FRAMEWORK_SA_ANY_STATE;
        try {
            frameworkState = (String)this.invokeMBeanOperation(deploymentServiceObjectName, "getState", saName);
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.logDebug("issue 30: state invalid: " + ex.getMessage());
            frameworkState = "Unknown";
        }
        AbstractUIMBeanImpl.logDebug("Framework State = " + frameworkState + " for Service Assembly = " + saName);
        String uiState = AbstractUIMBeanImpl.toUiServiceAssemblyState(frameworkState);
        saInfo.setState(uiState);
    }

    protected List getServiceAssemblyInfoList(String frameworkState, String componentName, String targetName) throws JBIRemoteException {
        String compName = null;
        if (componentName != null) {
            compName = componentName.trim();
        }
        String[] saNames = new String[]{};
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        if (compName == null || compName.length() <= 0) {
            AbstractUIMBeanImpl.logDebug("getting all the deployed service assemblies with state " + frameworkState);
            saNames = (String[])this.getMBeanAttribute(deploymentServiceObjectName, "DeployedServiceAssemblies");
        } else {
            AbstractUIMBeanImpl.logDebug("getting all the deployed service assemblies for the comp " + compName);
            if (!this.isExistingComponent(compName, targetName)) {
                String[] args = new String[]{compName};
                Exception exception = this.createManagementException("ui.mbean.component.id.does.not.exist", args, null);
                throw new JBIRemoteException(exception);
            }
            saNames = (String[])this.invokeMBeanOperation(deploymentServiceObjectName, "getDeployedServiceAssembliesForComponent", compName);
        }
        ArrayList<ServiceAssemblyInfo> saInfoByCompNameList = new ArrayList<ServiceAssemblyInfo>();
        for (int i = 0; i < saNames.length; ++i) {
            String saName = saNames[i];
            AbstractUIMBeanImpl.logDebug("getting deployment descriptor for " + saName);
            String saDDText = (String)this.invokeMBeanOperation(deploymentServiceObjectName, "getServiceAssemblyDescriptor", saName);
            ServiceAssemblyInfo saInfo = ServiceAssemblyInfo.createFromServiceAssemblyDD(new StringReader(saDDText));
            this.updateServiceAssemblyInfoState(saInfo, targetName);
            saInfoByCompNameList.add(saInfo);
        }
        ArrayList<ServiceAssemblyInfo> saInfoList = new ArrayList<ServiceAssemblyInfo>();
        if (frameworkState.equalsIgnoreCase(FRAMEWORK_SA_ANY_STATE)) {
            saInfoList.addAll(saInfoByCompNameList);
        } else {
            String uiState = AbstractUIMBeanImpl.toUiServiceAssemblyState(frameworkState);
            for (ServiceAssemblyInfo saInfo : saInfoByCompNameList) {
                if (!uiState.equalsIgnoreCase(saInfo.getState())) continue;
                saInfoList.add(saInfo);
            }
        }
        for (ServiceAssemblyInfo saInfo : saInfoList) {
            this.updateEachServiceUnitInfoStateInServiceAssemblyInfo(saInfo, targetName);
        }
        return saInfoList;
    }

    public List getUiComponentInfoList(ComponentType frameworkCompType, String targetName) throws JBIRemoteException {
        Set compNameSet = this.getComponentNamesWithStatus(frameworkCompType, ComponentState.UNKNOWN, targetName);
        List frameworkCompList = this.getFrameworkComponentInfoList(new ArrayList(compNameSet), targetName);
        ArrayList<JBIComponentInfo> uiCompList = new ArrayList<JBIComponentInfo>();
        for (ComponentInfo frameworkCompInfo : frameworkCompList) {
            JBIComponentInfo uiCompInfo = this.toUiComponentInfo(frameworkCompInfo, targetName);
            uiCompList.add(uiCompInfo);
        }
        return uiCompList;
    }

    public List toUiComponentInfoList(List frameworkCompList, String targetName) throws JBIRemoteException {
        ArrayList<JBIComponentInfo> uiCompList = new ArrayList<JBIComponentInfo>();
        for (ComponentInfo frameworkCompInfo : frameworkCompList) {
            JBIComponentInfo uiCompInfo = this.toUiComponentInfo(frameworkCompInfo, targetName);
            uiCompList.add(uiCompInfo);
        }
        return uiCompList;
    }

    public JBIComponentInfo toUiComponentInfo(ComponentInfo frameworkCompInfo, String targetName) throws JBIRemoteException {
        String state = "Unknown";
        String componentName = frameworkCompInfo.getName();
        String componentDescription = frameworkCompInfo.getDescription();
        ComponentState componentStatus = ComponentState.UNKNOWN;
        ComponentType componentType = frameworkCompInfo.getComponentType();
        if (!(ComponentType.BINDING.equals((Object)componentType) || ComponentType.ENGINE.equals((Object)componentType) || ComponentType.BINDINGS_AND_ENGINES.equals((Object)componentType))) {
            componentStatus = frameworkCompInfo.getStatus();
            state = AbstractUIMBeanImpl.toUiComponentInfoState(componentStatus);
        } else {
            try {
                ObjectName lifeCycleMBeanObjectName = null;
                lifeCycleMBeanObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
                state = (String)this.getMBeanAttribute(lifeCycleMBeanObjectName, "CurrentState");
            }
            catch (JBIRemoteException exception) {
                componentStatus = ComponentState.UNKNOWN;
                state = "Unknown";
            }
        }
        if (RUNNING_STATE.equals(state)) {
            state = "Started";
        }
        String type = AbstractUIMBeanImpl.toUiComponentInfoType(componentType);
        String componentVersion = "";
        String buildNumber = "";
        try {
            String descriptorXml = frameworkCompInfo.getInstallationDescriptor();
            InputSource inputSource = new InputSource(new StringReader(descriptorXml));
            String queryString = "";
            if (ComponentType.BINDING.equals((Object)componentType) || ComponentType.ENGINE.equals((Object)componentType) || ComponentType.BINDINGS_AND_ENGINES.equals((Object)componentType)) {
                queryString = COMPONENT_VERSION_XPATH_QUERY;
            } else if (ComponentType.SHARED_LIBRARY.equals((Object)componentType)) {
                queryString = SHARED_LIBRARY_VERSION_XPATH_QUERY;
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new IdentificationNSContext());
            Node rtnNode = (Node)xpath.evaluate(queryString, inputSource, XPathConstants.NODE);
            if (rtnNode != null) {
                Node buildAttr;
                NamedNodeMap attrs = rtnNode.getAttributes();
                Node verAttr = attrs.getNamedItem("specification-version");
                if (verAttr != null) {
                    componentVersion = verAttr.getNodeValue();
                }
                if ((buildAttr = attrs.getNamedItem("build-number")) != null) {
                    buildNumber = buildAttr.getNodeValue();
                }
            } else {
                inputSource = new InputSource(new StringReader(descriptorXml));
                xpath.setNamespaceContext(new IdentificationNewNSContext());
                rtnNode = (Node)xpath.evaluate(queryString, inputSource, XPathConstants.NODE);
                if (rtnNode != null) {
                    Node buildAttr;
                    NamedNodeMap attrs = rtnNode.getAttributes();
                    Node verAttr = attrs.getNamedItem("component-version");
                    if (verAttr != null) {
                        componentVersion = verAttr.getNodeValue();
                    }
                    if ((buildAttr = attrs.getNamedItem("build-number")) != null) {
                        buildNumber = buildAttr.getNodeValue();
                    }
                }
            }
        }
        catch (Exception exp) {
            throw new JBIRemoteException(exp);
        }
        JBIComponentInfo compInfo = new JBIComponentInfo(type, state, componentName, componentDescription);
        compInfo.setComponentVersion(componentVersion);
        compInfo.setBuildNumber(buildNumber);
        return compInfo;
    }

    public static String toFrameworkServiceAssemblyState(String uiState) {
        if (uiState == null) {
            return FRAMEWORK_SA_ANY_STATE;
        }
        String saState = uiState.trim();
        if (saState.length() <= 0) {
            return FRAMEWORK_SA_ANY_STATE;
        }
        if ("Started".equalsIgnoreCase(saState)) {
            return "Started";
        }
        if (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_STOPPED_STATE;
        }
        if (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_SHUTDOWN_STATE;
        }
        return FRAMEWORK_SA_ANY_STATE;
    }

    public static String toUiServiceAssemblyState(String frameworkState) {
        String uiState = "Unknown";
        if (frameworkState == null) {
            return "Unknown";
        }
        String saState = frameworkState.trim();
        if (saState.length() <= 0) {
            return "Unknown";
        }
        uiState = "Started".equalsIgnoreCase(saState) ? "Started" : (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_STOPPED_STATE : (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_SHUTDOWN_STATE : "Unknown"));
        return uiState;
    }

    public static String toUiServiceUnitState(String frameworkState) {
        String uiState = "Unknown";
        if (frameworkState == null) {
            return "Unknown";
        }
        String suState = frameworkState.trim();
        if (suState.length() <= 0) {
            return "Unknown";
        }
        uiState = FRAMEWORK_SU_STARTED_STATE.equalsIgnoreCase(suState) ? "Started" : (FRAMEWORK_SU_STOPPED_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_STOPPED_STATE : (FRAMEWORK_SU_SHUTDOWN_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_SHUTDOWN_STATE : "Unknown"));
        return uiState;
    }

    public static String toUiComponentInfoState(ComponentState frameworkCompState) {
        String uiState = "Unknown";
        switch (frameworkCompState) {
            case SHUTDOWN: {
                uiState = FRAMEWORK_SA_SHUTDOWN_STATE;
                break;
            }
            case STARTED: {
                uiState = "Started";
                break;
            }
            case STOPPED: {
                uiState = FRAMEWORK_SA_STOPPED_STATE;
                break;
            }
            default: {
                uiState = "Unknown";
            }
        }
        return uiState;
    }

    public static ComponentType toFrameworkComponentInfoType(String uiCompType) {
        if ("binding-component".equalsIgnoreCase(uiCompType)) {
            return ComponentType.BINDING;
        }
        if ("service-engine".equalsIgnoreCase(uiCompType)) {
            return ComponentType.BINDING;
        }
        if ("shared-library".equalsIgnoreCase(uiCompType)) {
            return ComponentType.SHARED_LIBRARY;
        }
        return ComponentType.BINDINGS_AND_ENGINES;
    }

    public static String toUiComponentInfoType(ComponentType frameworkCompType) {
        String uiType = FRAMEWORK_SU_UNKNOWN_STATE;
        switch (frameworkCompType) {
            case BINDING: {
                uiType = "binding-component";
                break;
            }
            case ENGINE: {
                uiType = "service-engine";
                break;
            }
            case SHARED_LIBRARY: {
                uiType = "shared-library";
                break;
            }
            default: {
                uiType = FRAMEWORK_SU_UNKNOWN_STATE;
            }
        }
        return uiType;
    }

    public void validateUiJBIComponentInfoState(String state) throws JBIRemoteException {
        if (state == null || state.length() == 0) {
            return;
        }
        String stateValue = state.toString();
        if (!("Started".equalsIgnoreCase(stateValue) || FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(stateValue) || FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(stateValue) || "Unknown".equalsIgnoreCase(stateValue))) {
            String[] args = new String[]{state};
            Exception exception = this.createManagementException("ui.mbean.list.error.invalid.state", args, null);
            throw new JBIRemoteException(exception);
        }
    }

    public void validateUiServiceAssemblyInfoState(String state) throws JBIRemoteException {
        if (state == null || state.length() == 0) {
            return;
        }
        String stateValue = state;
        if (!("Started".equalsIgnoreCase(stateValue) || FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(stateValue) || FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(stateValue) || "Unknown".equalsIgnoreCase(stateValue))) {
            String[] args = new String[]{state};
            Exception exception = this.createManagementException("ui.mbean.list.error.invalid.state", args, null);
            throw new JBIRemoteException(exception);
        }
    }

    public static ComponentState toFrameworkComponentInfoState(String uiCompState) {
        if (uiCompState == null) {
            return ComponentState.UNKNOWN;
        }
        String compState = uiCompState.trim();
        if (compState.length() <= 0) {
            return ComponentState.UNKNOWN;
        }
        if (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.SHUTDOWN;
        }
        if ("Started".equalsIgnoreCase(compState)) {
            return ComponentState.STARTED;
        }
        if (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.STOPPED;
        }
        return ComponentState.UNKNOWN;
    }

    protected List getFrameworkComponentInfoListForEnginesAndBindings(ComponentType frameworkCompType, ComponentState frameworkCompState, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String slibName = null;
        String saName = null;
        if (sharedLibraryName != null && sharedLibraryName.trim().length() > 0) {
            slibName = sharedLibraryName.trim();
        }
        if (serviceAssemblyName != null && serviceAssemblyName.trim().length() > 0) {
            saName = serviceAssemblyName.trim();
        }
        AbstractUIMBeanImpl.logDebug("getFrameworkComponentInfoForEnginesAndBindings : Params : " + (Object)((Object)frameworkCompType) + ", " + (Object)((Object)frameworkCompState) + ", " + slibName + ", " + saName);
        Collection componentNames = new HashSet();
        componentNames = slibName == null && saName == null ? this.getComponentNamesWithStatus(frameworkCompType, frameworkCompState, targetName) : (slibName == null && saName != null ? this.getComponentNamesDependentOnServiceAssembly(frameworkCompType, frameworkCompState, saName, targetName) : (slibName != null && saName == null ? this.getComponentNamesDependentOnSharedLibrary(frameworkCompType, frameworkCompState, slibName, targetName) : (slibName != null && saName != null ? this.getComponentNamesDependentOnSharedLibraryAndServiceAssembly(frameworkCompType, frameworkCompState, slibName, saName, targetName) : new HashSet())));
        return this.getFrameworkComponentInfoList(componentNames, targetName);
    }

    public List getFrameworkComponentInfoList(Collection compNameList, String targetName) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        try {
            ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                Iterator itr = compNameList.iterator();
                while (itr.hasNext()) {
                    ComponentInfo componentInfo = componentQuery.getComponentInfo((String)itr.next());
                    if (componentInfo == null) continue;
                    compInfoList.add(componentInfo);
                }
            }
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.logDebug(ex);
        }
        return compInfoList;
    }

    protected List getFrameworkComponentInfoListForSharedLibraries(String componentName, String targetName) throws JBIRemoteException {
        String compName = null;
        if (componentName != null && componentName.trim().length() > 0) {
            compName = componentName.trim();
        }
        AbstractUIMBeanImpl.logDebug("getFrameworkComponentInfoForSharedLibraries: Params : " + compName);
        List<Object> slibNames = new ArrayList();
        ArrayList uiCompInfoList = new ArrayList();
        List frameworkCompInfoList = new ArrayList();
        ComponentQuery componentQuery = null;
        if (compName == null) {
            AbstractUIMBeanImpl.logDebug("Listing All Shared Libraries in the schemaorg_apache_xmlbeans.system");
            componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                slibNames = componentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
            }
        } else {
            AbstractUIMBeanImpl.logDebug("Listing Shared Libraries for the component " + compName);
            componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                ComponentInfo componentInfo = componentQuery.getComponentInfo(compName);
                if (componentInfo == null) {
                    String[] args = new String[]{compName};
                    Exception exception = this.createManagementException("ui.mbean.component.id.does.not.exist", args, null);
                    throw new JBIRemoteException(exception);
                }
                slibNames = componentInfo.getSharedLibraryNames();
            }
        }
        frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraryNames(slibNames, targetName);
        return frameworkCompInfoList;
    }

    public List getFrameworkComponentInfoListForSharedLibraryNames(Collection slibNameList, String targetName) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        try {
            ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                Iterator itr = slibNameList.iterator();
                while (itr.hasNext()) {
                    ComponentInfo componentInfo = componentQuery.getSharedLibraryInfo((String)itr.next());
                    if (componentInfo == null) continue;
                    compInfoList.add(componentInfo);
                }
            }
        }
        catch (Exception ex) {
            AbstractUIMBeanImpl.logDebug(ex);
        }
        return compInfoList;
    }

    public String getInstallationDescriptor(String componentName, String targetName) {
        ComponentQuery componentQuery = null;
        ComponentInfo componentInfo = null;
        String jbiXml = null;
        componentQuery = this.mEnvContext.getComponentQuery(targetName);
        if (componentQuery != null && (componentInfo = componentQuery.getComponentInfo(componentName)) != null) {
            jbiXml = componentInfo.getInstallationDescriptor();
        }
        return jbiXml;
    }

    public String getSharedLibraryDescriptor(String libraryName, String targetName) {
        ComponentQuery componentQuery = null;
        ComponentInfo componentInfo = null;
        String jbiXml = null;
        componentQuery = this.mEnvContext.getComponentQuery(targetName);
        if (componentQuery != null && (componentInfo = componentQuery.getSharedLibraryInfo(libraryName)) != null) {
            jbiXml = componentInfo.getInstallationDescriptor();
        }
        return jbiXml;
    }

    class IdentificationNewNSContext
    implements NamespaceContext {
        IdentificationNewNSContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("identification")) {
                return AbstractUIMBeanImpl.COMPONENT_VERSION_NS_NEW;
            }
            return "http://java.sun.com/xml/ns/jbi";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }

    class IdentificationNSContext
    implements NamespaceContext {
        IdentificationNSContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("identification")) {
                return AbstractUIMBeanImpl.COMPONENT_VERSION_NS;
            }
            return "http://java.sun.com/xml/ns/jbi";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

