/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.ConnectionManager;
import com.sun.jbi.messaging.EndpointListener;
import com.sun.jbi.messaging.ExternalEndpoint;
import com.sun.jbi.messaging.InternalEndpoint;
import com.sun.jbi.messaging.Link;
import com.sun.jbi.messaging.LinkedEndpoint;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.util.Translator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

public class EndpointRegistry
implements ConnectionManager {
    private static EndpointRegistry mMe;
    private long mTotalEndpoints;
    private ConcurrentHashMap<Endpoint, RegisteredEndpoint> mInternalEndpoints;
    private ConcurrentHashMap<QName, VectorArray> mIEbyService;
    private ConcurrentHashMap<QName, VectorArray> mIEbyInterface;
    private ConcurrentHashMap<String, RegisteredEndpoint> mInternalEndpointNames;
    private LinkedList<RegisteredEndpoint> mPendingInternalInterfaces;
    private long mTotalInternalEndpoints;
    private ConcurrentHashMap<Endpoint, RegisteredEndpoint> mExternalEndpoints;
    private ConcurrentHashMap<QName, VectorArray> mEEbyService;
    private ConcurrentHashMap<QName, VectorArray> mEEbyInterface;
    private LinkedList<RegisteredEndpoint> mPendingExternalInterfaces;
    private long mTotalExternalEndpoints;
    private ConcurrentHashMap<Endpoint, LinkedEndpoint> mLinkedEndpoints;
    private ConcurrentHashMap<String, RegisteredEndpoint> mLinkedEndpointNames;
    private long mTotalLinkedEndpoints;
    private ConcurrentHashMap<QName, Endpoint> mInterfaceConnections;
    private MessageService mMsgSvc;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    private EndpointRegistry() {
        this.mInternalEndpoints = new ConcurrentHashMap();
        this.mIEbyService = new ConcurrentHashMap();
        this.mIEbyInterface = new ConcurrentHashMap();
        this.mInternalEndpointNames = new ConcurrentHashMap();
        this.mPendingInternalInterfaces = new LinkedList();
        this.mExternalEndpoints = new ConcurrentHashMap();
        this.mEEbyService = new ConcurrentHashMap();
        this.mEEbyInterface = new ConcurrentHashMap();
        this.mPendingExternalInterfaces = new LinkedList();
        this.mLinkedEndpoints = new ConcurrentHashMap();
        this.mLinkedEndpointNames = new ConcurrentHashMap();
        this.mInterfaceConnections = new ConcurrentHashMap();
    }

    static final synchronized EndpointRegistry getInstance() {
        if (mMe == null) {
            mMe = new EndpointRegistry();
        }
        return mMe;
    }

    synchronized void setMessageService(MessageService ms) {
        this.mMsgSvc = ms;
    }

    boolean statisticsEnabled() {
        return this.mMsgSvc.areStatisticsEnabled();
    }

    void zeroStatistics() {
        for (RegisteredEndpoint re : this.mInternalEndpoints.values()) {
            re.zeroStatistics();
        }
        for (LinkedEndpoint le : this.mLinkedEndpoints.values()) {
            le.zeroStatistics();
        }
    }

    public synchronized RegisteredEndpoint registerExternalEndpoint(ServiceEndpoint endpoint, String ownerId) throws MessagingException {
        Endpoint ep = new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName());
        RegisteredEndpoint re = this.mExternalEndpoints.get(ep);
        if (re != null) {
            throw new MessagingException(Translator.translate("DUPLICATE_ENDPOINT", new Object[]{re.toExternalName(), re.getOwnerId()}));
        }
        re = new ExternalEndpoint(endpoint, ownerId);
        this.mEEbyService.put(endpoint.getServiceName(), new VectorArray(this.mEEbyService.get(endpoint.getServiceName()), re));
        this.mExternalEndpoints.put(ep, re);
        this.mPendingExternalInterfaces.add(re);
        ++this.mTotalEndpoints;
        if (this.mLog.isLoggable(Level.FINE)) {
            this.mLog.log(Level.FINE, "Registered External endpoint: {0}", re.toExternalName());
        }
        return re;
    }

    public RegisteredEndpoint getExternalEndpoint(QName service, String endpoint) {
        return this.mExternalEndpoints.get(new Endpoint(service, endpoint));
    }

    public RegisteredEndpoint[] getExternalEndpointsForService(QName service) {
        VectorArray va = this.mEEbyService.get(service);
        return va == null ? new RegisteredEndpoint[]{} : va.mArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredEndpoint[] getExternalEndpointsForInterface(QName interfaceName) {
        RegisteredEndpoint[] endpoints;
        if (interfaceName != null) {
            RegisteredEndpoint ep;
            Endpoint link = this.mInterfaceConnections.get(interfaceName);
            endpoints = link != null ? ((ep = this.mExternalEndpoints.get(new Endpoint(link.mServiceName, link.mEndpointName))) == null ? new RegisteredEndpoint[]{} : new RegisteredEndpoint[]{ep}) : this.getEndpointsForInterface(interfaceName, 30);
        } else {
            EndpointRegistry endpointRegistry = this;
            synchronized (endpointRegistry) {
                endpoints = new RegisteredEndpoint[this.mExternalEndpoints.size()];
                this.mExternalEndpoints.values().toArray(endpoints);
            }
        }
        return endpoints;
    }

    public synchronized RegisteredEndpoint registerInternalEndpoint(QName service, String endpoint, String ownerId) throws MessagingException {
        Endpoint ep = new Endpoint(service, endpoint);
        RegisteredEndpoint re = this.mInternalEndpoints.get(ep);
        if (re != null) {
            if (!re.getOwnerId().equals(ownerId)) {
                throw new MessagingException(Translator.translate("DUPLICATE_ENDPOINT", new Object[]{re.toExternalName(), re.getOwnerId()}));
            }
            return re;
        }
        re = new InternalEndpoint(service, endpoint, ownerId);
        this.mIEbyService.put(service, new VectorArray(this.mIEbyService.get(service), re));
        this.mInternalEndpoints.put(ep, re);
        this.mPendingInternalInterfaces.add(re);
        this.mInternalEndpointNames.put(re.toExternalName(), re);
        ++this.mTotalEndpoints;
        if (this.mLog.isLoggable(Level.FINE)) {
            this.mLog.log(Level.FINE, "Registered Internal endpoint: {0}", re.toExternalName());
        }
        return re;
    }

    public RegisteredEndpoint getInternalEndpoint(QName service, String endpoint) {
        Endpoint e = new Endpoint(service, endpoint);
        RegisteredEndpoint re = this.mLinkedEndpoints.get(e);
        if (re == null) {
            re = this.mInternalEndpoints.get(e);
        }
        return re;
    }

    public RegisteredEndpoint getInternalEndpointByName(String epName) {
        return this.mInternalEndpointNames.get(epName);
    }

    public RegisteredEndpoint getLinkedEndpointByName(String epName) {
        return this.mLinkedEndpointNames.get(epName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLinkedEndpointsByChannel(String dcName) {
        LinkedEndpoint[] linkedEndpoints;
        LinkedList<String> ll = new LinkedList<String>();
        EndpointRegistry endpointRegistry = this;
        synchronized (endpointRegistry) {
            linkedEndpoints = new LinkedEndpoint[this.mLinkedEndpoints.size()];
            this.mLinkedEndpoints.values().toArray(linkedEndpoints);
        }
        for (LinkedEndpoint linkedEndpoint : linkedEndpoints) {
            if (!linkedEndpoint.getOwnerId().equals(dcName)) continue;
            ll.add(linkedEndpoint.toExternalName());
        }
        return ll.toArray(new String[ll.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegisteredEndpoint[] getInternalEndpointsForService(QName service, boolean convertLinks) {
        RegisteredEndpoint[] endpoints;
        Object va;
        boolean cloned = false;
        if (service != null) {
            va = this.mIEbyService.get(service);
            endpoints = va == null ? new RegisteredEndpoint[]{} : ((VectorArray)va).mArray;
        } else {
            va = this;
            synchronized (va) {
                endpoints = new RegisteredEndpoint[this.mInternalEndpoints.size()];
                this.mInternalEndpoints.values().toArray(endpoints);
            }
        }
        if (convertLinks) {
            RegisteredEndpoint re;
            for (int i = 0; i < endpoints.length && (re = endpoints[i]) instanceof LinkedEndpoint; ++i) {
                LinkedEndpoint le;
                if (!cloned) {
                    endpoints = (RegisteredEndpoint[])endpoints.clone();
                    cloned = true;
                }
                if ((re = this.mInternalEndpoints.get(new Endpoint((le = (LinkedEndpoint)re).getServiceLink(), le.getEndpointLink()))) == null) continue;
                endpoints[i] = re;
            }
        }
        return endpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredEndpoint[] getInternalEndpointsForInterface(QName interfaceName) {
        RegisteredEndpoint[] endpoints;
        if (interfaceName != null) {
            RegisteredEndpoint ep;
            Endpoint link = this.mInterfaceConnections.get(interfaceName);
            endpoints = link != null ? ((ep = this.mInternalEndpoints.get(new Endpoint(link.mServiceName, link.mEndpointName))) == null ? new RegisteredEndpoint[]{} : new RegisteredEndpoint[]{ep}) : this.getEndpointsForInterface(interfaceName, 20);
        } else {
            EndpointRegistry endpointRegistry = this;
            synchronized (endpointRegistry) {
                endpoints = new RegisteredEndpoint[this.mInternalEndpoints.size()];
                this.mInternalEndpoints.values().toArray(endpoints);
            }
        }
        return endpoints;
    }

    public synchronized void removeEndpoint(ServiceEndpoint ref) {
        RegisteredEndpoint re = ref instanceof RegisteredEndpoint ? (RegisteredEndpoint)ref : this.mExternalEndpoints.get(new Endpoint(ref.getServiceName(), ref.getEndpointName()));
        if (re != null && re.isActive()) {
            re.setActive(false);
            if (re.isInternal()) {
                this.removeInternalEndpoint(re);
            } else if (re.isExternal()) {
                this.removeExternalEndpoint(re);
            } else if (re.isLinked()) {
                this.removeLinkedEndpoint(re);
            }
            if (this.mLog.isLoggable(Level.FINE)) {
                this.mLog.log(Level.FINE, "Removed endpoint: {0}", re.toExternalName());
            }
        }
    }

    @Override
    public void addEndpointConnection(QName fromService, String fromEndpoint, QName toService, String toEndpoint, Link linkType) throws MessagingException {
        EndpointListener el;
        if (this.addEndpointConnectionInternal(fromService, fromEndpoint, toService, toEndpoint, linkType) && (el = this.mMsgSvc.getEndpointListener()) != null) {
            el.addServiceConnection(fromService, fromEndpoint, toService, toEndpoint, linkType.toString());
        }
    }

    public boolean addEndpointConnectionInternal(QName fromService, String fromEndpoint, QName toService, String toEndpoint, Link linkType) throws MessagingException {
        Endpoint ep = new Endpoint(fromService, fromEndpoint);
        boolean added = true;
        this.mLog.log(Level.FINE, "Add service connection for endpoint {0} {1}", new Object[]{fromService, fromEndpoint});
        LinkedEndpoint re = this.mLinkedEndpoints.get(ep);
        LinkedEndpoint link = new LinkedEndpoint(fromService, fromEndpoint, toService, toEndpoint, linkType);
        if (re != null) {
            if (!((RegisteredEndpoint)re).equals(link)) {
                throw new MessagingException(Translator.translate("ENDPOINT_CONNECTION_EXISTS", new Object[]{fromService, fromEndpoint, re.getOwnerId()}));
            }
            added = false;
        } else {
            VectorArray va = new VectorArray(this.mIEbyService.get(fromService), link);
            this.mIEbyService.put(fromService, va);
            this.mLinkedEndpoints.put(ep, link);
            this.mLinkedEndpointNames.put(link.toExternalName(), link);
            ++this.mTotalLinkedEndpoints;
        }
        return added;
    }

    @Override
    public boolean removeEndpointConnection(QName fromService, String fromEndpoint, QName toService, String toEndpoint) {
        EndpointListener el;
        boolean removed = this.removeEndpointConnectionInternal(fromService, fromEndpoint, toService, toEndpoint);
        if (removed && (el = this.mMsgSvc.getEndpointListener()) != null) {
            el.removeServiceConnection(fromService, fromEndpoint, toService, toEndpoint);
        }
        return removed;
    }

    public synchronized boolean removeEndpointConnectionInternal(QName fromService, String fromEndpoint, QName toService, String toEndpoint) {
        boolean isRemoved = false;
        this.mLog.log(Level.FINE, "Remove service connection for endpoint {0} {1}", new Object[]{fromService, fromEndpoint});
        LinkedEndpoint link = this.mLinkedEndpoints.get(new Endpoint(fromService, fromEndpoint));
        if (link != null) {
            this.removeEndpoint(link);
            isRemoved = true;
            --this.mTotalLinkedEndpoints;
        }
        return isRemoved;
    }

    @Override
    public synchronized void addInterfaceConnection(QName fromInterface, QName toService, String toEndpoint) throws MessagingException {
        Endpoint ep = new Endpoint(toService, toEndpoint);
        if (this.mInterfaceConnections.containsKey(fromInterface) && !ep.equals(this.mInterfaceConnections.get(fromInterface))) {
            throw new MessagingException(Translator.translate("INTERFACE_CONNECTION_EXISTS", new Object[]{fromInterface}));
        }
        this.mLog.log(Level.FINE, "Adding service connection for interface {0}", fromInterface);
        this.mInterfaceConnections.put(fromInterface, ep);
    }

    @Override
    public synchronized boolean removeInterfaceConnection(QName fromInterface, QName toService, String toEndpoint) {
        this.mLog.log(Level.FINE, "Removing service connection for interface {0}", fromInterface);
        return this.mInterfaceConnections.remove(fromInterface) != null;
    }

    public RegisteredEndpoint resolveLinkedEndpoint(LinkedEndpoint link) {
        return this.mInternalEndpoints.get(new Endpoint(link.getServiceLink(), link.getEndpointLink()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisteredEndpoint[] getEndpointsForInterface(QName interfaceName, int type) {
        LinkedList<RegisteredEndpoint> interfaces = type == 20 ? this.mPendingInternalInterfaces : this.mPendingExternalInterfaces;
        ConcurrentHashMap<QName, VectorArray> interfaceMap = type == 20 ? this.mIEbyInterface : this.mEEbyInterface;
        while (true) {
            RegisteredEndpoint ep;
            EndpointRegistry endpointRegistry = this;
            synchronized (endpointRegistry) {
                ep = interfaces.poll();
            }
            if (ep == null) break;
            this.getInterfacesForEndpoint(ep);
        }
        VectorArray va = interfaceMap.get(interfaceName);
        return va == null ? new RegisteredEndpoint[]{} : va.mArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getInterfacesForEndpoint(RegisteredEndpoint re) {
        LinkedList<RegisteredEndpoint> interfaces = re.getType() == 20 ? this.mPendingInternalInterfaces : this.mPendingExternalInterfaces;
        ConcurrentHashMap<QName, VectorArray> interfaceMap = re.getType() == 20 ? this.mIEbyInterface : this.mEEbyInterface;
        EndpointRegistry endpointRegistry = this;
        synchronized (endpointRegistry) {
            interfaces.remove(re);
            try {
                if (re.getInterfacesInternal() == null) {
                    re.parseDescriptor(this.mMsgSvc.queryDescriptor(re));
                }
                for (QName in : re.getInterfaces()) {
                    interfaceMap.put(in, new VectorArray(interfaceMap.get(in), re));
                }
            }
            catch (MessagingException msgEx) {
                this.mLog.warning(msgEx.toString());
            }
        }
    }

    private void removeInternalEndpoint(RegisteredEndpoint endpoint) {
        VectorArray va = this.mIEbyService.get(endpoint.getServiceName());
        if (va != null) {
            if (va.remove(endpoint)) {
                this.mIEbyService.remove(endpoint.getServiceName());
            } else {
                this.mIEbyService.put(endpoint.getServiceName(), va);
            }
            QName[] interfaceNames = endpoint.getInterfacesInternal();
            if (interfaceNames != null) {
                for (QName i : interfaceNames) {
                    va = this.mIEbyInterface.get(i);
                    if (va == null) continue;
                    if (va.remove(endpoint)) {
                        this.mIEbyInterface.remove(i);
                        continue;
                    }
                    this.mIEbyInterface.put(i, va);
                }
            }
            this.mInternalEndpoints.remove(new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName()));
            this.mInternalEndpointNames.remove(endpoint.toExternalName());
            this.mPendingInternalInterfaces.remove(endpoint);
        }
    }

    private void removeExternalEndpoint(RegisteredEndpoint endpoint) {
        VectorArray va = this.mEEbyService.get(endpoint.getServiceName());
        if (va != null) {
            if (va.remove(endpoint)) {
                this.mEEbyService.remove(endpoint.getServiceName());
            } else {
                this.mEEbyService.put(endpoint.getServiceName(), va);
            }
            QName[] interfaceNames = endpoint.getInterfacesInternal();
            if (interfaceNames != null) {
                for (QName i : interfaceNames) {
                    va = this.mEEbyInterface.get(i);
                    if (va == null) continue;
                    if (va.remove(endpoint)) {
                        this.mEEbyInterface.remove(i);
                        continue;
                    }
                    this.mEEbyInterface.put(i, va);
                }
            }
            this.mExternalEndpoints.remove(new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName()));
            this.mPendingExternalInterfaces.remove(endpoint);
        }
    }

    private void removeLinkedEndpoint(RegisteredEndpoint endpoint) {
        VectorArray va = this.mIEbyService.get(endpoint.getServiceName());
        if (va != null) {
            if (va.remove(endpoint)) {
                this.mIEbyService.remove(endpoint.getServiceName());
            } else {
                this.mIEbyService.put(endpoint.getServiceName(), va);
            }
            this.mLinkedEndpoints.remove(new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName()));
            this.mLinkedEndpointNames.remove(endpoint.toExternalName());
        }
    }

    int countEndpoints(int type) {
        int count = 0;
        count = type == 20 ? this.mInternalEndpoints.size() : (type == 30 ? this.mExternalEndpoints.size() : this.mLinkedEndpoints.size());
        return count;
    }

    ServiceEndpoint[] listEndpoints(int type) {
        Collection<RegisteredEndpoint> values = type == 20 ? this.mInternalEndpoints.values() : (type == 30 ? this.mExternalEndpoints.values() : this.mLinkedEndpoints.values());
        ServiceEndpoint[] endpoints = new ServiceEndpoint[values.size()];
        values.toArray(endpoints);
        return endpoints;
    }

    void clear() {
        this.mLinkedEndpoints.clear();
        this.mInternalEndpoints.clear();
        this.mExternalEndpoints.clear();
        this.mInterfaceConnections.clear();
        this.mIEbyService.clear();
        this.mEEbyService.clear();
        this.mIEbyInterface.clear();
        this.mEEbyInterface.clear();
        this.mPendingInternalInterfaces.clear();
        this.mPendingExternalInterfaces.clear();
    }

    public String toString() {
        VectorArray va;
        StringBuilder sb = new StringBuilder();
        sb.append("  EndpointRegistry\n");
        sb.append("    InternalEndpoints Count: ");
        sb.append(this.mInternalEndpoints.size());
        sb.append("\n");
        Iterator<Map.Entry<Endpoint, RegisteredEndpoint>> i = this.mInternalEndpoints.entrySet().iterator();
        while (i.hasNext()) {
            sb.append(i.next().getValue().toString());
        }
        sb.append("    InternalEndpointsByService Count: ");
        sb.append(this.mIEbyService.size());
        sb.append("\n");
        for (Map.Entry<QName, VectorArray> entry : this.mIEbyService.entrySet()) {
            va = entry.getValue();
            sb.append("      Service: " + entry.getKey());
            sb.append("\n");
            sb.append(va.toString());
        }
        sb.append("    InternalEndpointsByInterface Count: ");
        sb.append(this.mIEbyInterface.size());
        sb.append("\n");
        for (Map.Entry<QName, VectorArray> entry : this.mIEbyInterface.entrySet()) {
            va = entry.getValue();
            sb.append("      Interface: " + entry.getKey());
            sb.append("\n");
            sb.append(va.toString());
        }
        sb.append("    ExternalEndpoints Count: ");
        sb.append(this.mExternalEndpoints.size());
        sb.append("\n");
        i = this.mExternalEndpoints.entrySet().iterator();
        while (i.hasNext()) {
            sb.append(i.next().getValue().toString());
        }
        sb.append("    ExternalEndpointsByService Count: ");
        sb.append(this.mEEbyService.size());
        sb.append("\n");
        for (Map.Entry<QName, VectorArray> entry : this.mEEbyService.entrySet()) {
            va = entry.getValue();
            sb.append("      Service: " + entry.getKey());
            sb.append("\n");
            sb.append(va.toString());
        }
        sb.append("    ExternalEndpointsByInterface Count: ");
        sb.append(this.mEEbyInterface.size());
        sb.append("\n");
        for (Map.Entry<QName, VectorArray> entry : this.mEEbyInterface.entrySet()) {
            va = entry.getValue();
            sb.append("      Interface: " + entry.getKey());
            sb.append("\n");
            sb.append(va.toString());
        }
        sb.append("    LinkedEndpoints Count: ");
        sb.append(this.mLinkedEndpoints.size());
        sb.append("\n");
        i = this.mLinkedEndpoints.entrySet().iterator();
        while (i.hasNext()) {
            sb.append(((LinkedEndpoint)i.next().getValue()).toString());
        }
        sb.append("    InterfaceConnections Count: ");
        sb.append(this.mInterfaceConnections.size());
        sb.append("\n");
        for (Map.Entry<QName, Object> entry : this.mInterfaceConnections.entrySet()) {
            sb.append("      InterfaceName: " + entry.getKey());
            sb.append("\n");
            sb.append(((Endpoint)entry.getValue()).toString());
        }
        return sb.toString();
    }

    private class VectorArray {
        Vector mVector;
        RegisteredEndpoint[] mArray;

        VectorArray(VectorArray va, RegisteredEndpoint o) {
            this.mVector = va == null ? new Vector() : va.mVector;
            if (o instanceof LinkedEndpoint) {
                this.mVector.add(0, o);
            } else {
                this.mVector.add(o);
            }
            this.mArray = new RegisteredEndpoint[this.mVector.size()];
            this.mVector.toArray(this.mArray);
        }

        boolean remove(Object o) {
            this.mVector.remove(o);
            if (this.mVector.size() != 0) {
                this.mArray = new RegisteredEndpoint[this.mVector.size()];
                this.mVector.toArray(this.mArray);
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (RegisteredEndpoint re : this.mArray) {
                sb.append(re.toString());
            }
            return sb.toString();
        }
    }

    class Endpoint {
        private QName mServiceName;
        private String mEndpointName;

        Endpoint(QName serviceName, String endpointName) {
            this.mServiceName = serviceName;
            this.mEndpointName = endpointName;
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof Endpoint && ((Endpoint)obj).mServiceName.equals(this.mServiceName) && ((Endpoint)obj).mEndpointName.equals(this.mEndpointName)) {
                isEqual = true;
            }
            return isEqual;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("        ServiceName: " + this.mServiceName);
            sb.append("\n        EndpointName: " + this.mEndpointName);
            sb.append("\n");
            return sb.toString();
        }

        public int hashCode() {
            return this.mServiceName.hashCode() ^ this.mEndpointName.hashCode();
        }
    }
}

