/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.ChannelStatistics;
import com.sun.jbi.messaging.DeliveryChannel;
import com.sun.jbi.messaging.EndpointListener;
import com.sun.jbi.messaging.EndpointRegistry;
import com.sun.jbi.messaging.EndpointStatistics;
import com.sun.jbi.messaging.ExchangeFactory;
import com.sun.jbi.messaging.ExchangeIdGenerator;
import com.sun.jbi.messaging.Link;
import com.sun.jbi.messaging.MessageExchange;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.MessagingStatistics;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.TimeoutListener;
import com.sun.jbi.messaging.stats.METimestamps;
import com.sun.jbi.messaging.stats.Value;
import com.sun.jbi.messaging.util.Translator;
import com.sun.jbi.monitoring.ComponentStatisticsBase;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class DeliveryChannelImpl
implements DeliveryChannel,
ChannelStatistics {
    public static final String REG_NOTIFICATION_TYPE = "Registration";
    private String mChannelId;
    private ClassLoader mClassLoader;
    private MessageService mMsgSvc;
    private boolean mIsClosed;
    private boolean mTransactional;
    private IdentityHashMap mActive;
    private long mMaxActive;
    private LinkedList mQueue;
    private long mMaxQueued;
    private int mAcceptors;
    private long mDeadWait;
    private long mTimeOut;
    private long mSendCount;
    private long mSendSyncCount;
    private long mAcceptCount;
    private long mStatisticsEpoch;
    private long mSendRequest;
    private long mReceiveRequest;
    private long mSendReply;
    private long mReceiveReply;
    private long mSendFault;
    private long mReceiveFault;
    private long mSendDONE;
    private long mReceiveDONE;
    private long mSendERROR;
    private long mReceiveERROR;
    private Value mResponseTime;
    private Value mStatusTime;
    private Value mNMRTime;
    private Value mComponentTime;
    private Value mChannelTime;
    private HashSet<RegisteredEndpoint> mInternalEndpoints;
    private HashMap<String, RegisteredEndpoint> mEndpoints;
    private HashSet<RegisteredEndpoint> mExternalEndpoints;
    private EndpointRegistry mRegistry;
    private TimeoutListener mTimeout;
    private int mNotifyIdx = 0;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private ComponentStatisticsBase mStats;
    private MessagingStatistics mMsgStats;
    private static final int ITEMS_BASE = 20;
    private static final int ITEMS_EXTRA = 20;
    private static final String[] ITEM_NAMES = new String[]{"ActiveExchanges", "MaxActiveExchanges", "QueuedExchanges", "MaxQueuedExchanges", "ActiveEndpoints", "SendRequest", "ReceiveRequest", "SendReply", "ReceiveReply", "SendFault", "ReceiveFault", "SendDONE", "ReceiveDONE", "SendERROR", "ReceiveERROR", "DeadWait", "TimeOut", "SendCount", "SendSyncCount", "AcceptCount", "ResponseTimeMin (ns)", "ResponseTimeAvg (ns)", "ResponseTimeMax (ns)", "ResponseTimeStd (ns)", "StatusTimeMin (ns)", "StatusTimeAvg (ns)", "StatusTimeMax (ns)", "StatusTimeStd (ns)", "NMRTimeMin (ns)", "NMRTimeAvg (ns)", "NMRTimeMax (ns)", "NMRTimeStd (ns)", "ComponentTimeMin (ns)", "ComponentTimeAvg (ns)", "ComponentTimeMax (ns)", "ComponentTimeStd (ns)", "ChannelTimeMin (ns)", "ChannelTimeAvg (ns)", "ChannelTimeMax (ns)", "ChannelTimeStd (ns)"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"Number of active MessageExchanges", "Number of active MessageExchanges Max", "Number of queued MessageExchanges", "Number of queued MessageExchanges Max", "Number of active Endpoints", "Number of requests sent", "Number of requests received", "Number of replies sent", "Number of replies received", "Number of faults sent", "Number of faults received", "Number of DONE requests sent", "Number of DONE requests received", "Number of ERROR requests sent", "Number of ERROR requests received", "Number of waits that didn't find any work", "Number of requests that timed out", "Number of Send operations", "Number of SendSync operations", "Number of Accept operations", "Response Time Min", "Response Time Avg", "Response Time Max", "Response Time Std", "Status Time Min", "Status Time Avg", "Status Time Max", "Status Time Std", "NMR Time Min", "NMR Time Avg", "NMR Time Max", "NMR Time Std", "Component Time Min", "Component Time Avg", "Component Time Max", "Component Time Std", "Channel Time Min", "Channel Time Avg", "Channel Time Max", "Channel Time Std"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};

    DeliveryChannelImpl(String channelId, ClassLoader classLoader, MessageService msgSvc, EndpointListener listener) {
        this.mChannelId = channelId;
        this.mClassLoader = classLoader;
        this.mMsgSvc = msgSvc;
        this.mIsClosed = false;
        this.mTransactional = true;
        this.mQueue = new LinkedList();
        this.mActive = new IdentityHashMap();
        this.mInternalEndpoints = new HashSet();
        this.mExternalEndpoints = new HashSet();
        this.mEndpoints = new HashMap();
        this.mRegistry = EndpointRegistry.getInstance();
        this.mStats = null;
        this.mResponseTime = new Value();
        this.mStatusTime = new Value();
        this.mNMRTime = new Value();
        this.mComponentTime = new Value();
        this.mChannelTime = new Value();
    }

    public javax.jbi.messaging.MessageExchange accept() throws MessagingException {
        MessageExchangeProxy me = null;
        me = this.acceptInternal(0L);
        if (me != null && me.capture((byte)6, (byte)3)) {
            this.propagateStatistics(me);
        }
        return me;
    }

    public javax.jbi.messaging.MessageExchange accept(long timeout) throws MessagingException {
        MessageExchangeProxy me = null;
        me = this.acceptInternal(timeout);
        if (me != null && me.capture((byte)6, (byte)3)) {
            this.propagateStatistics(me);
        }
        return me;
    }

    private MessageExchangeProxy acceptInternal(long timeout) throws MessagingException {
        MessageExchangeProxy me = null;
        if (this.mIsClosed) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        me = timeout == 0L ? this.dequeueExchange() : this.dequeueExchange(timeout);
        if (me != null) {
            if (me.handleAccept(this)) {
                this.removeAcceptReference(me);
                if (this.mLog.isLoggable(Level.FINE)) {
                    this.mLog.log(Level.FINER, "Exchange {0} accepted on channel {1}", new Object[]{me.getExchangeId(), this.mChannelId});
                }
            } else {
                this.updateStatistics(me);
            }
        }
        return me;
    }

    public void send(javax.jbi.messaging.MessageExchange exchange) throws MessagingException {
        ((MessageExchangeProxy)exchange).capture((byte)1, (byte)4);
        if (this.isClosed()) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        this.mMsgSvc.doExchange(this, (MessageExchangeProxy)exchange);
    }

    @Override
    public boolean sendLast(javax.jbi.messaging.MessageExchange exchange) throws MessagingException {
        ((MessageExchangeProxy)exchange).capture((byte)1, (byte)4);
        if (this.isClosed()) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        return this.mMsgSvc.doExchange(this, (MessageExchangeProxy)exchange);
    }

    public boolean sendSync(javax.jbi.messaging.MessageExchange exchange) throws MessagingException {
        ((MessageExchangeProxy)exchange).capture((byte)1, (byte)4);
        return this.sendSyncInternal((MessageExchangeProxy)exchange, 0L);
    }

    public boolean sendSync(javax.jbi.messaging.MessageExchange exchange, long timeout) throws MessagingException {
        ((MessageExchangeProxy)exchange).capture((byte)1, (byte)4);
        return this.sendSyncInternal((MessageExchangeProxy)exchange, timeout);
    }

    private boolean sendSyncInternal(MessageExchangeProxy mep, long timeout) throws MessagingException {
        boolean available;
        if (this.isClosed()) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        if (this.mLog.isLoggable(Level.FINE)) {
            this.mLog.log(Level.FINER, "Exchange {0} sent on channel {1}", new Object[]{mep.getExchangeId(), this.mChannelId});
        }
        if (available = this.mMsgSvc.doSynchExchange(this, mep, timeout)) {
            if (mep.handleAccept(this)) {
                this.removeAcceptReference(mep);
            } else {
                this.updateStatistics(mep);
            }
            if (mep.capture((byte)6, (byte)3)) {
                this.propagateStatistics(mep);
            }
        }
        return available;
    }

    public MessageExchangeFactory createExchangeFactory() {
        return new ExchangeFactory(this.mMsgSvc);
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        return ExchangeFactory.newInterfaceFactory(this.mMsgSvc, interfaceName);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        return ExchangeFactory.newServiceFactory(this.mMsgSvc, serviceName);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        return ExchangeFactory.newEndpointFactory(this.mMsgSvc, endpoint);
    }

    public void registerXAResource(XAResource resource) {
        this.mMsgSvc.addXAResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredEndpoint activateEndpoint(QName service, String endpoint) throws MessagingException {
        if (service == null || endpoint == null || endpoint.equals("")) {
            throw new MessagingException(Translator.translate("ACTIVATE_NOT_NULL"));
        }
        RegisteredEndpoint re = this.mRegistry.registerInternalEndpoint(service, endpoint, this.getChannelId());
        if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
            this.mStats.incrementRegisteredServicesOrEndpoints();
        }
        HashSet<RegisteredEndpoint> hashSet = this.mInternalEndpoints;
        synchronized (hashSet) {
            this.mInternalEndpoints.add(re);
            this.mEndpoints.put(re.toExternalName(), re);
        }
        if (this.mMsgSvc.getEndpointListener() != null) {
            this.mMsgSvc.getEndpointListener().activate(this, re);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateEndpoint(ServiceEndpoint ref) throws MessagingException {
        RegisteredEndpoint re = (RegisteredEndpoint)ref;
        if (!re.getOwnerId().equals(this.mChannelId)) {
            throw new MessagingException(Translator.translate("DEACTIVATE_NOT_OWNER"));
        }
        HashSet<RegisteredEndpoint> hashSet = this.mInternalEndpoints;
        synchronized (hashSet) {
            this.mInternalEndpoints.remove(ref);
            this.mEndpoints.remove(((RegisteredEndpoint)ref).toExternalName());
        }
        this.mRegistry.removeEndpoint(re);
        if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
            this.mStats.decrementRegisteredServicesOrEndpoints();
        }
        if (this.mMsgSvc.getEndpointListener() != null) {
            this.mMsgSvc.getEndpointListener().deactivate(this, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws MessagingException {
        try {
            RegisteredEndpoint re = this.mRegistry.registerExternalEndpoint(externalEndpoint, this.getChannelId());
            if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
                this.mStats.incrementRegisteredServicesOrEndpoints();
            }
            HashSet<RegisteredEndpoint> hashSet = this.mExternalEndpoints;
            synchronized (hashSet) {
                this.mExternalEndpoints.add(re);
            }
        }
        catch (MessagingException msgEx) {
            this.mLog.warning(msgEx.getMessage());
            throw msgEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws MessagingException {
        RegisteredEndpoint re = this.mRegistry.getExternalEndpoint(externalEndpoint.getServiceName(), externalEndpoint.getEndpointName());
        if (!re.getOwnerId().equals(this.mChannelId)) {
            throw new MessagingException(Translator.translate("DEACTIVATE_NOT_OWNER"));
        }
        HashSet<RegisteredEndpoint> hashSet = this.mExternalEndpoints;
        synchronized (hashSet) {
            this.mExternalEndpoints.remove(re);
        }
        this.mRegistry.removeEndpoint(re);
        if (null != this.mStats && this.mStats.getStatisticsBase().isEnabled()) {
            this.mStats.decrementRegisteredServicesOrEndpoints();
        }
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        ServiceEndpoint[] list;
        ServiceEndpoint endpoint = null;
        for (ServiceEndpoint list1 : list = this.getEndpointsForService(service)) {
            if (!list1.getEndpointName().equals(name)) continue;
            endpoint = list1;
            break;
        }
        return endpoint;
    }

    synchronized RegisteredEndpoint getEndpointByExternalName(String name) {
        return this.mEndpoints.get(name);
    }

    synchronized RegisteredEndpoint getConsumingEndpointByExternalName(String name) {
        return this.mRegistry.getLinkedEndpointByName(name);
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws MessagingException {
        return this.mMsgSvc.queryDescriptor(endpoint);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return this.mRegistry.getExternalEndpointsForInterface(interfaceName);
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        return this.mRegistry.getInternalEndpointsForInterface(interfaceName);
    }

    public ServiceEndpoint[] getEndpoints() {
        return this.mInternalEndpoints.toArray(new ServiceEndpoint[this.mInternalEndpoints.size()]);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return this.mRegistry.getExternalEndpointsForService(serviceName);
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment endpointReference) {
        return this.mMsgSvc.resolveEndpointReference(endpointReference);
    }

    public ServiceEndpoint[] getEndpointsForService(QName service) {
        return this.mRegistry.getInternalEndpointsForService(service, false);
    }

    @Override
    public void addServiceConnection(QName serviceLink, String endpointLink, QName service, String endpoint, String type) throws MessagingException {
        this.mRegistry.addEndpointConnectionInternal(serviceLink, endpointLink, service, endpoint, Link.valueOf(type));
    }

    @Override
    public void removeServiceConnection(QName serviceLink, String endpointLink, QName service, String endpoint) {
        this.mRegistry.removeEndpointConnectionInternal(serviceLink, endpointLink, service, endpoint);
    }

    public void setTransactional(boolean transactional) {
        this.mTransactional = transactional;
    }

    public final boolean isTransactional() {
        return this.mTransactional;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public void close() throws MessagingException {
        if (this.mIsClosed) {
            return;
        }
        this.mIsClosed = true;
        for (RegisteredEndpoint ref : this.mInternalEndpoints) {
            this.mRegistry.removeEndpoint(ref);
        }
        for (RegisteredEndpoint ref : this.mExternalEndpoints) {
            this.mRegistry.removeEndpoint(ref);
        }
        this.cleanActive();
        this.mMsgSvc.removeChannel(this.mChannelId);
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    String getChannelId() {
        return this.mChannelId;
    }

    synchronized void addSendReference(MessageExchangeProxy me) {
        if (this.mActive.put(me, me) == null) {
            me.setInUse(this.mChannelId);
            if ((long)this.mActive.size() > this.mMaxActive) {
                this.mMaxActive = this.mActive.size();
            }
        }
        ++this.mSendCount;
        switch (me.getPhase()) {
            case 5: {
                ++this.mSendReply;
                break;
            }
            case 4: {
                ++this.mSendRequest;
                break;
            }
            case 1: {
                ++this.mSendDONE;
                break;
            }
            case 3: {
                ++this.mSendERROR;
                break;
            }
            case 6: {
                ++this.mSendFault;
            }
        }
    }

    synchronized void addSendSyncReference(MessageExchangeProxy me) {
        if (this.mActive.put(me, me) == null) {
            me.setInUse(this.mChannelId);
            if ((long)this.mActive.size() > this.mMaxActive) {
                this.mMaxActive = this.mActive.size();
            }
        }
        ++this.mSendSyncCount;
        switch (me.getPhase()) {
            case 5: {
                ++this.mSendReply;
                break;
            }
            case 4: {
                ++this.mSendRequest;
                break;
            }
            case 1: {
                ++this.mSendDONE;
                break;
            }
            case 3: {
                ++this.mSendERROR;
                break;
            }
            case 6: {
                ++this.mSendFault;
            }
        }
    }

    synchronized void removeSendReference(MessageExchangeProxy me) {
        this.mActive.remove(me);
        me.resetInUse();
        ++this.mSendCount;
        switch (me.getPhase()) {
            case 5: {
                ++this.mSendReply;
                break;
            }
            case 4: {
                ++this.mSendRequest;
                break;
            }
            case 1: {
                ++this.mSendDONE;
                break;
            }
            case 3: {
                ++this.mSendERROR;
                break;
            }
            case 6: {
                ++this.mSendFault;
            }
        }
    }

    synchronized void removeAcceptReference(MessageExchangeProxy me) {
        if (this.mActive.remove(me) != null) {
            me.resetInUse();
        }
        switch (me.getPhase()) {
            case 5: {
                ++this.mReceiveReply;
                break;
            }
            case 4: {
                ++this.mReceiveRequest;
                break;
            }
            case 1: {
                ++this.mReceiveDONE;
                break;
            }
            case 3: {
                ++this.mReceiveERROR;
                break;
            }
            case 6: {
                ++this.mReceiveFault;
            }
        }
    }

    synchronized void addAcceptReference(MessageExchangeProxy me) {
        if (this.mActive.put(me, me) == null) {
            me.setInUse(null);
            if ((long)this.mActive.size() > this.mMaxActive) {
                this.mMaxActive = this.mActive.size();
            }
        }
    }

    void propagateStatistics(MessageExchangeProxy me) {
        this.updateStatistics(me);
        me.updateStatistics();
        this.mMsgSvc.updateStatistics(me);
    }

    synchronized void updateStatistics(MessageExchangeProxy me) {
        switch (me.getPhase()) {
            case 5: {
                ++this.mReceiveReply;
                break;
            }
            case 4: {
                ++this.mReceiveRequest;
                break;
            }
            case 1: {
                ++this.mReceiveDONE;
                break;
            }
            case 3: {
                ++this.mReceiveERROR;
                break;
            }
            case 6: {
                ++this.mReceiveFault;
            }
        }
    }

    synchronized void updateProviderStatistics(METimestamps ts) {
        if (ts != null) {
            this.mResponseTime.addSample(ts.mResponseTime);
            this.mNMRTime.addSample(ts.mNMRTime);
            this.mComponentTime.addSample(ts.mProviderTime);
            this.mChannelTime.addSample(ts.mProviderChannelTime);
        }
    }

    synchronized void updateConsumerStatistics(METimestamps ts) {
        if (ts != null) {
            if (ts.mStatusTime != 0L) {
                this.mStatusTime.addSample(ts.mStatusTime);
            }
            if (ts.mConsumerTime != 0L) {
                this.mComponentTime.addSample(ts.mConsumerTime);
            }
            this.mNMRTime.addSample(ts.mNMRTime);
            this.mChannelTime.addSample(ts.mConsumerChannelTime);
        }
    }

    synchronized void zeroStatistics() {
        this.mDeadWait = 0L;
        this.mTimeOut = 0L;
        this.mSendCount = 0L;
        this.mSendSyncCount = 0L;
        this.mAcceptCount = 0L;
        this.mSendRequest = 0L;
        this.mReceiveRequest = 0L;
        this.mSendReply = 0L;
        this.mReceiveReply = 0L;
        this.mSendFault = 0L;
        this.mReceiveFault = 0L;
        this.mSendDONE = 0L;
        this.mReceiveDONE = 0L;
        this.mSendERROR = 0L;
        this.mReceiveERROR = 0L;
        this.mResponseTime.zero();
        this.mStatusTime.zero();
        this.mNMRTime.zero();
        this.mComponentTime.zero();
        this.mChannelTime.zero();
    }

    @Override
    public synchronized boolean activeReference(javax.jbi.messaging.MessageExchange me) {
        return this.mActive.get(me) != null;
    }

    synchronized void queueObserved(MessageExchangeProxy mep) throws MessagingException {
        if (this.mIsClosed) {
            this.mLog.warning(Translator.translate("CHANNEL_CLOSED"));
            return;
        }
        this.mQueue.addLast(mep);
        if (this.mQueue.size() == 1) {
            this.notifyAll();
        }
        if ((long)this.mQueue.size() > this.mMaxQueued) {
            this.mMaxQueued = this.mQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void queueExchange(MessageExchangeProxy mep) throws MessagingException {
        if (this.mIsClosed) {
            throw new MessagingException(Translator.translate("CHANNEL_CLOSED"));
        }
        this.addAcceptReference(mep);
        if (mep.getSynchState() == 0) {
            if (mep.getStatus().equals(ExchangeStatus.ACTIVE)) {
                this.mQueue.addLast(mep);
            } else {
                this.mQueue.addFirst(mep);
            }
            if ((long)this.mQueue.size() > this.mMaxQueued) {
                this.mMaxQueued = this.mQueue.size();
            }
            mep.setSynchState(4);
            if (this.mQueue.size() == 1) {
                this.notifyAll();
            }
            mep.capture((byte)5, (byte)2);
        } else {
            MessageExchangeProxy messageExchangeProxy = mep;
            synchronized (messageExchangeProxy) {
                if (mep.getSynchState() == 1 || mep.getSynchState() == 2) {
                    ++this.mAcceptCount;
                    mep.setSynchState(3);
                    mep.capture((byte)5, (byte)2);
                    mep.notify();
                } else if (mep.getSynchState() == 5) {
                    this.mActive.remove(mep);
                    mep.terminate();
                    throw new MessagingException(Translator.translate("MESSAGE_TIMEOUT"));
                }
            }
        }
    }

    synchronized MessageExchangeProxy dequeueExchange() throws MessagingException {
        MessageExchangeProxy me = null;
        boolean dead = false;
        try {
            ++this.mAcceptCount;
            ++this.mAcceptors;
            while (!this.mIsClosed) {
                if (this.mQueue.size() > 0) {
                    me = (MessageExchangeProxy)this.mQueue.removeFirst();
                    break;
                }
                this.wait();
                if (dead) {
                    ++this.mDeadWait;
                }
                dead = true;
            }
        }
        catch (InterruptedException intEx) {
            throw new MessagingException((Throwable)intEx);
        }
        finally {
            --this.mAcceptors;
        }
        return me;
    }

    synchronized MessageExchangeProxy dequeueExchange(long timeout) throws MessagingException {
        MessageExchangeProxy me = null;
        boolean timedOut = false;
        boolean dead = false;
        long endTime = System.currentTimeMillis() + timeout;
        try {
            ++this.mAcceptCount;
            ++this.mAcceptors;
            while (!this.mIsClosed) {
                if (this.mQueue.size() > 0) {
                    me = (MessageExchangeProxy)this.mQueue.removeFirst();
                    break;
                }
                if (timedOut) {
                    ++this.mTimeOut;
                    break;
                }
                this.wait(timeout);
                timeout = endTime - System.currentTimeMillis();
                boolean bl = timedOut = timeout <= 0L;
                if (dead) {
                    ++this.mDeadWait;
                }
                dead = true;
            }
        }
        catch (InterruptedException intEx) {
            throw new MessagingException((Throwable)intEx);
        }
        finally {
            --this.mAcceptors;
        }
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanActive() {
        Iterator i;
        Set s;
        DeliveryChannelImpl deliveryChannelImpl = this;
        synchronized (deliveryChannelImpl) {
            s = this.mActive.entrySet();
            i = s.iterator();
            while (i.hasNext()) {
                MessageExchangeProxy mep = (MessageExchangeProxy)i.next().getKey();
                if (!mep.terminate()) continue;
                i.remove();
                this.mLog.log(Level.WARNING, "DeliveryChannel:Close Cleanup Exchange\n{0}", mep);
            }
            this.mQueue.clear();
            this.notifyAll();
        }
        i = s.iterator();
        while (i.hasNext()) {
            MessageExchangeProxy mep = (MessageExchangeProxy)i.next().getKey();
            try {
                mep.getSendChannel().queueExchange(mep.getTwin());
            }
            catch (MessagingException mEx) {
                this.mLog.log(Level.WARNING, "MessagingException Id({0}) : {1}", new Object[]{mep.getExchangeId(), mEx});
            }
        }
    }

    DeliveryChannelImpl getChannel(String id) {
        return this.mMsgSvc.getChannel(id);
    }

    @Override
    public void setEndpointListener(EndpointListener listener) {
        this.mMsgSvc.setEndpointListener(listener);
    }

    @Override
    public void setTimeoutListener(TimeoutListener timeout) {
        this.mMsgSvc.setTimeoutListener(timeout == null ? null : this, timeout);
    }

    @Override
    public javax.jbi.messaging.MessageExchange createExchange(URI pattern, String id) throws MessagingException {
        javax.jbi.messaging.MessageExchange me = this.createExchangeFactory().createExchange(pattern);
        ((MessageExchangeProxy)me).getMessageExchange().setExchangeId(id);
        return me;
    }

    @Override
    public ServiceEndpoint createEndpoint(QName service, String endpoint) throws MessagingException {
        return this.mRegistry.getInternalEndpoint(service, endpoint);
    }

    @Override
    public void setExchangeIdGenerator(ExchangeIdGenerator generator) {
        this.mMsgSvc.setExchangeIdGenerator(generator);
    }

    @Override
    public boolean isExchangeOkay(javax.jbi.messaging.MessageExchange me) {
        return this.mMsgSvc.isExchangeOkay((MessageExchange)me);
    }

    void activeSummary(SortedMap<String, String> summary) {
        for (MessageExchangeProxy mep : this.mActive.values()) {
            if (summary.containsKey(mep.getExchangeId())) continue;
            summary.put(mep.getExchangeId(), mep.getSummary());
        }
    }

    @Override
    public String getName() {
        return this.mChannelId;
    }

    @Override
    public String[] getEndpointNames() {
        Object[] eps = this.mInternalEndpoints.toArray();
        String[] results = new String[eps.length];
        for (int i = 0; i < eps.length; ++i) {
            results[i] = ((RegisteredEndpoint)eps[i]).toExternalName();
        }
        return results;
    }

    @Override
    public String[] getConsumingEndpointNames() {
        return this.mRegistry.getLinkedEndpointsByChannel(this.mChannelId);
    }

    @Override
    public EndpointStatistics getEndpointStatistics(String name) {
        return this.getEndpointByExternalName(name);
    }

    @Override
    public CompositeData getStatistics() {
        try {
            String[] descs;
            String[] names;
            OpenType[] types;
            Object[] values;
            boolean enabled;
            boolean bl = enabled = this.mChannelTime.getCount() != 0L;
            if (enabled) {
                values = new Object[40];
                types = ITEM_TYPES;
                names = ITEM_NAMES;
                descs = ITEM_DESCRIPTIONS;
            } else {
                values = new Object[20];
                types = new OpenType[20];
                System.arraycopy(ITEM_TYPES, 0, types, 0, 20);
                names = new String[20];
                System.arraycopy(ITEM_NAMES, 0, names, 0, 20);
                descs = new String[20];
                System.arraycopy(ITEM_DESCRIPTIONS, 0, descs, 0, 20);
            }
            values[0] = (long)this.mActive.size();
            values[1] = this.mMaxActive;
            values[2] = (long)this.mQueue.size();
            values[3] = this.mMaxQueued;
            values[4] = (long)this.mInternalEndpoints.size();
            values[5] = this.mSendRequest;
            values[6] = this.mReceiveRequest;
            values[7] = this.mSendReply;
            values[8] = this.mReceiveReply;
            values[9] = this.mSendFault;
            values[10] = this.mReceiveFault;
            values[11] = this.mSendDONE;
            values[12] = this.mReceiveDONE;
            values[13] = this.mSendERROR;
            values[14] = this.mReceiveERROR;
            values[15] = this.mDeadWait;
            values[16] = this.mTimeOut;
            values[17] = this.mSendCount;
            values[18] = this.mSendSyncCount;
            values[19] = this.mAcceptCount;
            if (enabled) {
                values[20] = this.mResponseTime.getMin();
                values[21] = (long)this.mResponseTime.getAverage();
                values[22] = this.mResponseTime.getMax();
                values[23] = (long)this.mResponseTime.getSd();
                values[24] = this.mStatusTime.getMin();
                values[25] = (long)this.mStatusTime.getAverage();
                values[26] = this.mStatusTime.getMax();
                values[27] = (long)this.mStatusTime.getSd();
                values[28] = this.mNMRTime.getMin();
                values[29] = (long)this.mNMRTime.getAverage();
                values[30] = this.mNMRTime.getMax();
                values[31] = (long)this.mNMRTime.getSd();
                values[32] = this.mComponentTime.getMin();
                values[33] = (long)this.mComponentTime.getAverage();
                values[34] = this.mComponentTime.getMax();
                values[35] = (long)this.mComponentTime.getSd();
                values[36] = this.mChannelTime.getMin();
                values[37] = (long)this.mChannelTime.getAverage();
                values[38] = this.mChannelTime.getMax();
                values[39] = (long)this.mChannelTime.getSd();
            }
            return new CompositeDataSupport(new CompositeType("EndpointStatistics", "Endpoint statistics", names, descs, types), names, values);
        }
        catch (OpenDataException openDataException) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  DeliveryChannel for Component: ");
        sb.append(this.mChannelId);
        sb.append("\n    State: ");
        sb.append(this.mIsClosed ? "CLOSED" : "OPEN");
        sb.append("  Transactional: ");
        sb.append(this.mTransactional ? "YES" : "NO");
        sb.append("  Acceptors: " + this.mAcceptors);
        sb.append("\n    DeadWaitCount: " + this.mDeadWait);
        sb.append("  TimeoutCount: " + this.mTimeOut);
        sb.append("\n    SendCount: " + this.mSendCount);
        sb.append("  SendSyncCount:" + this.mSendSyncCount);
        sb.append("  AcceptCount: " + this.mAcceptCount);
        sb.append("\n    SendRequest: " + this.mSendRequest);
        sb.append("  RecvRequest: " + this.mReceiveRequest);
        sb.append("  SendReply: " + this.mSendReply);
        sb.append("  RecvReply: " + this.mReceiveReply);
        sb.append("\n    SendDONE: " + this.mSendDONE);
        sb.append("  RecvDONE: " + this.mReceiveDONE);
        sb.append("  SendERROR: " + this.mSendERROR);
        sb.append("  RecvERROR: " + this.mReceiveERROR);
        sb.append("\n    SendFault: " + this.mSendFault);
        sb.append("  RecvFault: " + this.mReceiveFault);
        sb.append("\n");
        if (this.mChannelTime.getCount() != 0L) {
            sb.append("    ResponseTime:  " + this.mResponseTime.toString());
            sb.append("\n    StatusTime:    " + this.mStatusTime.toString());
            sb.append("\n    ComponentTime: " + this.mComponentTime.toString());
            sb.append("\n    ChannelTime:   " + this.mChannelTime.toString());
            sb.append("\n    NMRTime:       " + this.mNMRTime.toString());
            sb.append("\n");
        }
        sb.append("    InternalEndpoints Count: ");
        sb.append(this.mInternalEndpoints.size());
        sb.append("\n");
        Iterator<RegisteredEndpoint> i = this.mInternalEndpoints.iterator();
        while (i.hasNext()) {
            sb.append(((Object)i.next()).toString());
        }
        sb.append("    ExternalEndpoints Count: ");
        sb.append(this.mExternalEndpoints.size());
        sb.append("\n");
        i = this.mExternalEndpoints.iterator();
        while (i.hasNext()) {
            sb.append(((Object)i.next()).toString());
            sb.append("\n");
        }
        sb.append("    ConsumingEndpoints Count: ");
        String[] cen = this.getConsumingEndpointNames();
        sb.append(cen.length);
        sb.append("\n");
        for (String i2 : cen) {
            sb.append(this.getConsumingEndpointByExternalName(i2).toString());
        }
        sb.append("    Active MEP's  Count: ");
        sb.append(this.mActive.size());
        sb.append(" Max: " + this.mMaxActive + "\n");
        for (MessageExchangeProxy mep : this.mActive.values()) {
            sb.append(mep.toString());
            sb.append("\n");
        }
        sb.append("    Queued MEP's Count: ");
        sb.append(this.mQueue.size());
        sb.append(" Max: " + this.mMaxQueued + "\n");
        for (MessageExchangeProxy mep : this.mQueue) {
            sb.append("      Exchange Id(");
            sb.append(mep.getExchangeId());
            sb.append(")\n");
        }
        return sb.toString();
    }
}

