/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.support;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.support.SystemServiceLoggerMBeanImpl;
import com.sun.jbi.util.Constants;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanHelper
implements com.sun.jbi.management.MBeanHelper,
Constants {
    private final MBeanServer mMBeanServer;
    private final MBeanNames mMBeanNames;
    private Logger mLogger;
    private StringTranslator mTranslator;
    private EnvironmentContext mCtx;

    public MBeanHelper(MBeanServer aMBeanServer, MBeanNames aMBeanNames, Logger aLogger) {
        this.mMBeanServer = aMBeanServer;
        this.mMBeanNames = aMBeanNames;
        this.mLogger = aLogger;
        this.mCtx = EnvironmentAccess.getContext();
        this.mTranslator = this.mCtx.getStringTranslator("com.sun.jbi.management");
    }

    @Override
    public boolean createSystemServiceLoggerMBean(String aService, Logger aLogger) {
        this.mLogger.log(Level.FINE, "createSystemServiceLoggerMBean for Service={0} logger={1}", new Object[]{aService, aLogger.getName()});
        ObjectName mbname = this.mMBeanNames.getSystemServiceLoggerMBeanName(aService, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aService, "Logger");
            this.mLogger.severe(statusMsg);
            return false;
        }
        try {
            SystemServiceLoggerMBeanImpl loggerImpl;
            SystemServiceLoggerMBeanImpl mbean = loggerImpl = new SystemServiceLoggerMBeanImpl(aLogger, aService);
            this.mMBeanServer.registerMBean(mbean, mbname);
        }
        catch (Exception ex) {
            Object[] params = new String[]{aService, aLogger.getName(), ex.getMessage()};
            String locMsg = this.mTranslator.getString("JBI_ADMIN_LOGGER_MBN_CREATE_FAILED", params);
            this.mLogger.warning(locMsg);
            return false;
        }
        return true;
    }

    @Override
    public boolean destroySystemServiceLoggerMBean(String aService) {
        this.mLogger.log(Level.FINE, "destroySystemServiceLoggerMBean for Service={0}", aService);
        ObjectName mbname = this.mMBeanNames.getSystemServiceMBeanName(aService, "Logger");
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aService, "Logger");
            this.mLogger.severe(statusMsg);
            return false;
        }
        try {
            this.mMBeanServer.unregisterMBean(mbname);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean destroySystemServiceLoggerMBean(String aService, Logger aLogger) {
        this.mLogger.log(Level.FINE, "destroySystemServiceLoggerMBean for Service={0}", aService);
        ObjectName mbname = this.mMBeanNames.getSystemServiceLoggerMBeanName(aService, aLogger);
        if (null == mbname) {
            String statusMsg = this.mTranslator.getString("MBEAN_HELPER_FAILED_OBJECT_CREATION", aService, "Logger");
            this.mLogger.severe(statusMsg);
            return false;
        }
        try {
            this.mMBeanServer.unregisterMBean(mbname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Level getLogLevel(String attrName, EnvironmentContext envCtx) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        ObjectName configMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        Level level = null;
        try {
            if (envCtx.getMBeanServer().isRegistered(configMBeanName)) {
                String attrValue = (String)envCtx.getMBeanServer().getAttribute(configMBeanName, attrName);
                level = attrValue == null || "null".equalsIgnoreCase(attrValue) || "DEFAULT".equalsIgnoreCase(attrValue) ? null : Level.parse(attrValue);
            } else {
                Logger.getLogger("com.sun.jbi").log(Level.FINEST, "MBean {0}is not registered", configMBeanName);
            }
        }
        catch (JMException jmex) {
            Logger.getLogger("com.sun.jbi").warning(jmex.toString());
        }
        return level;
    }

    public static void setLogLevel(String logName, String logLevel, EnvironmentContext envCtx, Logger aLogger) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        ObjectName configMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        try {
            if (envCtx.getMBeanServer().isRegistered(configMBeanName)) {
                Attribute attrib = new Attribute(logName, logLevel);
                envCtx.getMBeanServer().setAttribute(configMBeanName, attrib);
            } else {
                aLogger.log(Level.FINEST, "MBean {0}is not registered", configMBeanName);
            }
        }
        catch (JMException jmex) {
            aLogger.warning(jmex.toString());
        }
    }

    public static void revertToGlobalLogLevel(String logName, EnvironmentContext envCtx, Logger aLogger) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        ObjectName configMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        try {
            if (envCtx.getMBeanServer().isRegistered(configMBeanName)) {
                envCtx.getMBeanServer().invoke(configMBeanName, "deleteOverride", new Object[]{logName}, new String[]{"java.lang.String"});
            } else {
                aLogger.log(Level.FINEST, "MBean {0}is not registered", configMBeanName);
            }
        }
        catch (JMException jmex) {
            aLogger.warning(jmex.toString());
        }
    }

    public static ObjectName getLoggerConfigMBeanName() {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.Logger.toString());
        return EnvironmentAccess.getContext().getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
    }

    public static ObjectName getSystemConfigMBeanName() {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(ConfigurationCategory.System.toString());
        return EnvironmentAccess.getContext().getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
    }
}

