/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import com.sun.jbi.StringTranslator;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.zip.ZipFile;

public class JarURLHelper {
    public static final String FILE = "file";
    public static final String HTTP = "http";
    public static final String JAR = "jar";
    public static final String JAR_SEPARATOR = "!/";

    public static ZipFile getZipFileFromURL(URL fileURL, StringTranslator translator) throws IOException {
        if (FILE.equals(fileURL.getProtocol())) {
            return new ZipFile(fileURL.getPath());
        }
        if (JAR.equals(fileURL.getProtocol())) {
            JarURLConnection conxn = (JarURLConnection)fileURL.openConnection();
            conxn.setUseCaches(false);
            return conxn.getJarFile();
        }
        String errMsg = translator.getString("UNSUPPORTED_URL_PROTOCOL", fileURL.getProtocol());
        throw new IOException(errMsg);
    }

    public static URL convertToJarURL(URL fileURL, StringTranslator translator) throws IOException {
        try {
            if (JAR.equalsIgnoreCase(fileURL.getProtocol())) {
                return fileURL;
            }
            if (FILE.equalsIgnoreCase(fileURL.getProtocol()) || HTTP.equalsIgnoreCase(fileURL.getProtocol())) {
                return new URL("jar:" + fileURL.toString() + JAR_SEPARATOR);
            }
            String errMsg = translator.getString("UNSUPPORTED_URL_PROTOCOL", fileURL.getProtocol());
            throw new IOException(errMsg);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

