/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.ConnectionConfiguration;
import com.sun.esb.eventmanagement.impl.AlertUtil;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.I18NBundle;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ConnectionConfigurationImpl
implements ConnectionConfiguration {
    private static final String RESOURCES_MBEAN_OBJ_NAME = "com.sun.appserv:type=resources,category=config";
    private static final String ALERTS_POOL_NAME = "AlertDBPool";
    private static final String DB_NAME = "EventDB";
    private static final String USR_NAME = "alertusr2";
    private static final String PASSWORD = "alertpass2";
    private static final String SERVER_NAME = "localhost";
    private static final String PORT_NUM = "1527";
    private static final Logger mLogger = Logger.getLogger(ConnectionConfigurationImpl.class.getName());
    private static boolean isDebugEnabled = mLogger.isLoggable(Level.FINEST);
    private String mJndiName;
    private MBeanServerConnection mMBeanServer;
    private I18NBundle I18NPACKAGEBUNDLE;

    public ConnectionConfigurationImpl(String jndiName, MBeanServerConnection aMBeanServer) {
        this.mJndiName = jndiName;
        this.mMBeanServer = aMBeanServer;
    }

    @Override
    public void createConnectionsPools() throws ManagementRemoteException {
        String dataSrcClassName = "org.apache.derby.jdbc.ClientDataSource";
        String resourceType = "javax.sql.DataSource";
        this.createPoolandResource(ALERTS_POOL_NAME, this.mJndiName, dataSrcClassName, resourceType);
    }

    private void createPoolandResource(String connPoolName, String jndiResName, String dataSrcClassName, String resourceType) throws ManagementRemoteException {
        ObjectName configObjName = null;
        try {
            configObjName = ObjectName.getInstance(RESOURCES_MBEAN_OBJ_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        String sFalse = "false";
        String sTrue = "true";
        String sZero = "0";
        Object retRes = null;
        try {
            retRes = this.mMBeanServer.invoke(configObjName, "getJdbcResourceByJndiName", new Object[]{jndiResName}, new String[]{String.class.getName()});
        }
        catch (Exception resourceExec) {
            // empty catch block
        }
        if (retRes != null) {
            String msg = this.getPackageBundle().getMessage("ConnectionConfigurationImpl.JDBC.Resource.is.present.log.msg", jndiResName);
            mLogger.log(Level.INFO, msg);
            return;
        }
        Object retPool = null;
        try {
            retPool = this.mMBeanServer.invoke(configObjName, "getJdbcConnectionPoolByName", new Object[]{connPoolName}, new String[]{String.class.getName()});
        }
        catch (Exception poolExec) {
            // empty catch block
        }
        if (retPool == null) {
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", connPoolName));
            attrList.add(new Attribute("datasource-classname", dataSrcClassName));
            attrList.add(new Attribute("res-type", resourceType));
            attrList.add(new Attribute("steady-pool-size", "8"));
            attrList.add(new Attribute("max-pool-size", "32"));
            attrList.add(new Attribute("pool-resize-quantity", "2"));
            attrList.add(new Attribute("idle-timeout-in-seconds", "300"));
            attrList.add(new Attribute("max-wait-time-in-millis", "60000"));
            attrList.add(new Attribute("is-connection-validation-required", "false"));
            attrList.add(new Attribute("connection-validation-method", "auto-commit"));
            attrList.add(new Attribute("fail_all_connections", "false"));
            attrList.add(new Attribute("allow-non-component-callers", "true"));
            attrList.add(new Attribute("non-transactional-connections", "false"));
            attrList.add(new Attribute("is-isolation-level-guaranteed", "false"));
            attrList.add(new Attribute("wrap-jdbc-objects", "false"));
            attrList.add(new Attribute("validate-atmost-once-period-in-seconds", "0"));
            attrList.add(new Attribute("connection-leak-timeout-in-seconds", "0"));
            attrList.add(new Attribute("connection-leak-reclaim", "false"));
            attrList.add(new Attribute("connection-creation-retry-attempts", "0"));
            attrList.add(new Attribute("connection-creation-retry-interval-in-seconds", "10"));
            attrList.add(new Attribute("lazy-connection-enlistment", "false"));
            attrList.add(new Attribute("lazy-connection-association", "false"));
            attrList.add(new Attribute("associate-with-thread", "false"));
            attrList.add(new Attribute("match-connections", "false"));
            attrList.add(new Attribute("max-connection-usage-count", "0"));
            Properties props = new Properties();
            props.setProperty("PortNumber", PORT_NUM);
            props.setProperty("DatabaseName", DB_NAME);
            props.setProperty("User", USR_NAME);
            props.setProperty("Password", PASSWORD);
            props.setProperty("serverName", SERVER_NAME);
            props.setProperty("connectionAttributes", ";create=true");
            try {
                this.mMBeanServer.invoke(configObjName, "createJdbcConnectionPool", new Object[]{attrList, props, "domain"}, new String[]{AttributeList.class.getName(), Properties.class.getName(), String.class.getName()});
            }
            catch (InstanceNotFoundException aInstanceNotFoundException) {
                Exception e = AlertUtil.createManagementException("caps.management.client.alert.configuration.resourceConfig.mbean.error", null, aInstanceNotFoundException);
                throw new ManagementRemoteException(e);
            }
            catch (MBeanException jmxException) {
                throw ManagementRemoteException.filterJmxExceptions(jmxException);
            }
            catch (ReflectionException aReflectionException) {
                Exception e = AlertUtil.createManagementException("caps.management.client.alert.configuration.Reflection.error", null, aReflectionException);
                throw new ManagementRemoteException(e);
            }
            catch (IOException ioe) {
                Exception e = AlertUtil.createManagementException("caps.management.client.alert.configuration.connectivity.error", null, ioe);
                throw new ManagementRemoteException(e);
            }
        } else {
            String msg = this.getPackageBundle().getMessage("ConnectionConfigurationImpl.Connection.is.present.log.msg", connPoolName);
            mLogger.log(Level.INFO, msg);
        }
        AttributeList attrList2 = new AttributeList();
        attrList2.add(new Attribute("jndi-name", jndiResName));
        attrList2.add(new Attribute("pool-name", connPoolName));
        attrList2.add(new Attribute("object-type", "user"));
        attrList2.add(new Attribute("enabled", "true"));
        try {
            this.mMBeanServer.invoke(configObjName, "createJdbcResource", new Object[]{attrList2, new Properties(), "server"}, new String[]{AttributeList.class.getName(), Properties.class.getName(), String.class.getName()});
        }
        catch (InstanceNotFoundException aInstanceNotFoundException) {
            Exception e = AlertUtil.createManagementException("caps.management.client.alert.configuration.resourceConfig.mbean.error", null, aInstanceNotFoundException);
            throw new ManagementRemoteException(e);
        }
        catch (MBeanException jmxException) {
            throw ManagementRemoteException.filterJmxExceptions(jmxException);
        }
        catch (ReflectionException aReflectionException) {
            Exception e = AlertUtil.createManagementException("caps.management.client.alert.configuration.Reflection.error", null, aReflectionException);
            throw new ManagementRemoteException(e);
        }
        catch (IOException ioe) {
            Exception e = AlertUtil.createManagementException("caps.management.client.alert.configuration.connectivity.error", null, ioe);
            throw new ManagementRemoteException(e);
        }
    }

    private boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    private I18NBundle getPackageBundle() {
        if (this.I18NPACKAGEBUNDLE == null) {
            this.I18NPACKAGEBUNDLE = new I18NBundle("com.sun.esb.eventmanagement.impl");
        }
        return this.I18NPACKAGEBUNDLE;
    }
}

