/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.FrameworkStatisticsData;
import com.sun.esb.management.common.data.helper.FrameworkStatisticsDataReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FrameworkStatisticsDataCreator {
    public static String FRAMEWORK_STARTUP_TIME = "StartupTime";
    public static String FRAMEWORK_LAST_RESTART_TIME = "LastRestartTime";
    static String[] FRAMEWORK_STATS_ITEM_NAMES = new String[]{"InstanceName", "StartupTime", "UpTime"};
    static String[] FRAMEWORK_STATS_ITEM_DESCRIPTIONS = new String[]{"Instance Name", "Time taken to startup the framework (ms)", "Time elapsed since framework has been started (ms)"};
    static OpenType[] FRAMEWORK_STATS_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG};
    static String[] FRAMEWORK_STATS_TABLE_INDEX = new String[]{"InstanceName"};

    public static TabularData createTabularData(Map<String, FrameworkStatisticsData> map) throws ManagementRemoteException {
        TabularDataSupport frameworkStatsTable = null;
        try {
            CompositeType frameworkStatsEntriesType = new CompositeType("FrameworkStatistics", "Framework Statistics", FRAMEWORK_STATS_ITEM_NAMES, FRAMEWORK_STATS_ITEM_DESCRIPTIONS, FRAMEWORK_STATS_ITEM_TYPES);
            TabularType frameworkStatsType = new TabularType("FrameworkStats", "Framework Statistic Information", frameworkStatsEntriesType, FRAMEWORK_STATS_TABLE_INDEX);
            frameworkStatsTable = new TabularDataSupport(frameworkStatsType);
            Set<String> instances = map.keySet();
            for (String instanceName : instances) {
                FrameworkStatisticsData data = map.get(instanceName);
                frameworkStatsTable.put(FrameworkStatisticsDataCreator.getFrameworkStatistics(frameworkStatsEntriesType, data));
            }
        }
        catch (OpenDataException e) {
            throw new ManagementRemoteException(e);
        }
        return frameworkStatsTable;
    }

    protected static CompositeData getFrameworkStatistics(CompositeType frameworkStatsEntriesType, FrameworkStatisticsData data) throws ManagementRemoteException {
        try {
            Object[] values = new Object[]{data.getInstanceName(), data.getStartupTime(), data.getUpTime()};
            return new CompositeDataSupport(frameworkStatsEntriesType, FRAMEWORK_STATS_ITEM_NAMES, values);
        }
        catch (Exception ex) {
            throw new ManagementRemoteException(ex);
        }
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/frameworkstatistics/FrameworkStatisticsData.xml";
        try {
            Map<String, FrameworkStatisticsData> map = null;
            map = FrameworkStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            TabularData data = FrameworkStatisticsDataCreator.createTabularData(map);
            System.out.println(data);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ManagementRemoteException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

