/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.sdk.model;

import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.openesb.sdk.http.HttpMethodName;
import net.openesb.sdk.model.AbstractRequest;

public class LoginRequest
extends AbstractRequest {
    private final String username;
    private final String password;

    public LoginRequest(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public HttpMethodName method() {
        return HttpMethodName.POST;
    }

    @Override
    public String uri() {
        return "/authentication/_login";
    }

    @Override
    public Map<String, String> headers() {
        Map<String, String> headers = super.headers();
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])(this.getUsername() + ":" + this.getPassword()).getBytes());
        headers.put("Authorization", "Basic " + basicAuth);
        return headers;
    }
}

