/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.internal.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import java.util.Set;
import net.openesb.command.Command;
import net.openesb.command.impl.CreateComponentApplicationConfigurationCommand;
import net.openesb.command.impl.CreateComponentApplicationVariableCommand;
import net.openesb.command.impl.DeleteComponentApplicationConfigurationCommand;
import net.openesb.command.impl.DeleteComponentApplicationVariableCommand;
import net.openesb.command.impl.DeployServiceAssemblyCommand;
import net.openesb.command.impl.InstallComponentCommand;
import net.openesb.command.impl.InstallSharedLibraryCommand;
import net.openesb.command.impl.ListComponentApplicationConfigurationsCommand;
import net.openesb.command.impl.ListComponentApplicationVariablesCommand;
import net.openesb.command.impl.ListComponentsCommand;
import net.openesb.command.impl.ListServiceAssembliesCommand;
import net.openesb.command.impl.ListSharedLibrariesCommand;
import net.openesb.command.impl.SetComponentConfigurationCommand;
import net.openesb.command.impl.SetComponentLoggerCommand;
import net.openesb.command.impl.SetRuntimeConfigurationCommand;
import net.openesb.command.impl.SetRuntimeLoggerCommand;
import net.openesb.command.impl.ShowComponentCommand;
import net.openesb.command.impl.ShowServiceAssemblyCommand;
import net.openesb.command.impl.ShowSharedLibraryCommand;
import net.openesb.command.impl.ShutdownComponentCommand;
import net.openesb.command.impl.ShutdownServiceAssemblyCommand;
import net.openesb.command.impl.StartComponentCommand;
import net.openesb.command.impl.StartServiceAssemblyCommand;
import net.openesb.command.impl.StopComponentCommand;
import net.openesb.command.impl.StopServiceAssemblyCommand;
import net.openesb.command.impl.UndeployServiceAssemblyCommand;
import net.openesb.command.impl.UninstallComponentCommand;
import net.openesb.command.impl.UninstallSharedLibraryCommand;
import net.openesb.command.impl.UpdateComponentApplicationConfigurationCommand;
import net.openesb.command.impl.UpdateComponentApplicationVariableCommand;
import net.openesb.command.impl.UpgradeComponentCommand;
import net.openesb.command.internal.CommandLineParser;
import net.openesb.command.utils.I18NBundle;

public class JCommanderCommandLineParser
implements CommandLineParser {
    private JCommander parser;

    public JCommanderCommandLineParser() {
        this.init();
    }

    private void init() {
        this.parser = new JCommander();
        this.parser.setProgramName("oeadmin");
        this.parser.addCommand(new CreateComponentApplicationConfigurationCommand());
        this.parser.addCommand(new CreateComponentApplicationVariableCommand());
        this.parser.addCommand(new DeleteComponentApplicationConfigurationCommand());
        this.parser.addCommand(new DeleteComponentApplicationVariableCommand());
        this.parser.addCommand(new DeployServiceAssemblyCommand());
        this.parser.addCommand(new InstallComponentCommand());
        this.parser.addCommand(new InstallSharedLibraryCommand());
        this.parser.addCommand(new ListComponentApplicationConfigurationsCommand());
        this.parser.addCommand(new ListComponentApplicationVariablesCommand());
        this.parser.addCommand(new ListComponentsCommand());
        this.parser.addCommand(new ListServiceAssembliesCommand());
        this.parser.addCommand(new ListSharedLibrariesCommand());
        this.parser.addCommand(new SetComponentConfigurationCommand());
        this.parser.addCommand(new SetComponentLoggerCommand());
        this.parser.addCommand(new SetRuntimeConfigurationCommand());
        this.parser.addCommand(new SetRuntimeLoggerCommand());
        this.parser.addCommand(new ShowComponentCommand());
        this.parser.addCommand(new ShowServiceAssemblyCommand());
        this.parser.addCommand(new ShowSharedLibraryCommand());
        this.parser.addCommand(new ShutdownComponentCommand());
        this.parser.addCommand(new ShutdownServiceAssemblyCommand());
        this.parser.addCommand(new StartComponentCommand());
        this.parser.addCommand(new StartServiceAssemblyCommand());
        this.parser.addCommand(new StopComponentCommand());
        this.parser.addCommand(new StopServiceAssemblyCommand());
        this.parser.addCommand(new UndeployServiceAssemblyCommand());
        this.parser.addCommand(new UninstallComponentCommand());
        this.parser.addCommand(new UninstallSharedLibraryCommand());
        this.parser.addCommand(new UpdateComponentApplicationConfigurationCommand());
        this.parser.addCommand(new UpdateComponentApplicationVariableCommand());
        this.parser.addCommand(new UninstallComponentCommand());
        this.parser.addCommand(new UpgradeComponentCommand());
    }

    @Override
    public void execute(String[] args) {
        try {
            this.parser.parse(args);
            JCommander internalCmd = this.parser.getCommands().get(this.parser.getParsedCommand());
            if (internalCmd == null) {
                this.printLightUsage();
                return;
            }
            Command cmd = (Command)internalCmd.getObjects().iterator().next();
            if (cmd.help()) {
                this.printUsage(this.parser.getParsedCommand());
            } else {
                cmd.execute();
            }
        }
        catch (MissingCommandException ex) {
            System.out.println(I18NBundle.getBundle().getMessage("cli.command.not.found", args));
        }
        catch (ParameterException pe) {
            System.out.println(pe.getMessage());
        }
    }

    public void printLightUsage() {
        StringBuilder builder = new StringBuilder();
        Set<String> availableCommands = this.parser.getCommands().keySet();
        for (String commandName : availableCommands) {
            builder.append("    ").append(commandName).append("\t\t").append(this.parser.getCommandDescription(commandName)).append("\n");
        }
        System.out.println(builder.toString());
    }

    @Override
    public void printUsage() {
        this.parser.usage();
    }

    @Override
    public void printUsage(String command) {
        this.parser.usage(command);
    }
}

