/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.command.utils.ApplicationVariableConverter;
import net.openesb.model.api.ApplicationVariable;
import net.openesb.sdk.model.UpdateComponentApplicationVariablesRequest;

@Parameters(separators="=", commandNames={"update-jbi-application-variable"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.update-jbi-application-variable.descr")
public class UpdateComponentApplicationVariableCommand
extends AbstractCommand {
    @Parameter(names={"--component"}, descriptionKey="cli.update-jbi-application-variable.param.component", required=true, arity=1)
    private String componentName;
    @Parameter(descriptionKey="cli.update-jbi-application-variable.param.value", required=true)
    private List<String> variables;

    @Override
    protected void executeRequest() throws Exception {
        String values = this.variables.get(0);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(values));
        }
        catch (IOException e) {
            properties = this.createPropertiesParam(values);
        }
        UpdateComponentApplicationVariablesRequest request = new UpdateComponentApplicationVariablesRequest(this.componentName);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ApplicationVariable appVariable = ApplicationVariableConverter.convert((String)entry.getKey(), (String)entry.getValue());
            if (appVariable == null) continue;
            request.addApplicationVariable(appVariable);
        }
        this.getClient().updateComponentApplicationVariables(request);
    }
}

