/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Set;
import net.openesb.command.impl.AbstractCommand;
import net.openesb.command.internal.jcommander.StateConverter;
import net.openesb.model.api.ServiceAssembly;
import net.openesb.model.api.State;
import net.openesb.sdk.model.ListServiceAssembliesRequest;

@Parameters(commandNames={"list-jbi-service-assemblies"}, resourceBundle="net.openesb.command.Bundle", commandDescriptionKey="cli.list-jbi-service-assemblies.descr")
public class ListServiceAssembliesCommand
extends AbstractCommand {
    @Parameter(names={"--componentname"}, descriptionKey="cli.list-jbi-service-assemblies.param.componentname", arity=1)
    private String componentName;
    @Parameter(names={"--lifecyclestate"}, descriptionKey="cli.list-jbi-service-assemblies.param.lifecyclestate", converter=StateConverter.class, arity=1)
    private State lifecycleState;

    @Override
    protected void executeRequest() throws Exception {
        ListServiceAssembliesRequest request = new ListServiceAssembliesRequest();
        request.setComponentName(this.componentName);
        request.setState(this.lifecycleState);
        Set<ServiceAssembly> assemblies = this.getClient().listServiceAssemblies(request);
        if (assemblies.isEmpty()) {
            this.printMessage(this.getLocalizedString("cli.list-jbi-service-assemblies.empty"));
        } else {
            for (ServiceAssembly assembly : assemblies) {
                this.printMessage(assembly.getName());
            }
        }
    }
}

