/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiJmxTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class JbiUpgradeComponentTask
extends JbiJmxTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.upgrade.component.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.upgrade.component.failed";
    private File mInstallFile;
    private String mComponentName = null;

    public String getName() {
        return this.mComponentName;
    }

    public void setName(String name) {
        this.mComponentName = name;
    }

    public File getFile() {
        return this.mInstallFile;
    }

    public void setFile(File file) {
        this.mInstallFile = file;
    }

    protected void validateInstallFileAttribute(File installFile) throws BuildException {
        if (installFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.upgrade.error.comp.archive.file.path.null");
        }
        if (installFile.getPath().trim().length() <= 0) {
            this.throwTaskBuildException("jbi.ui.ant.upgrade.error.comp.archive.file.path.required");
        }
        if (!installFile.exists()) {
            this.throwTaskBuildException("jbi.ui.ant.upgrade.error.comp.archive.file.not.exist", installFile.getName());
        }
        if (installFile.isDirectory()) {
            this.throwTaskBuildException("jbi.ui.ant.upgrade.error.comp.archive.file.is.directory");
        }
    }

    protected void validateNameAttribute(String compName) throws BuildException {
        if (compName == null) {
            this.throwTaskBuildException("jbi.ui.ant.upgrade.error.comp.name.required");
        }
        if (compName.trim().length() == 0) {
            this.throwTaskBuildException("jbi.ui.ant.task.error.nullCompName");
        }
    }

    @Override
    public void executeTask() throws BuildException {
        String installFileAbsolutePath = null;
        String compName = this.getName();
        File installFile = this.getFile();
        this.validateNameAttribute(compName);
        this.validateInstallFileAttribute(installFile);
        installFileAbsolutePath = installFile.getAbsolutePath();
        try {
            String result = null;
            result = this.getJBIAdminCommands().updateComponent(compName, installFileAbsolutePath);
            this.printTaskSuccess(result);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }
}

