/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiQueryTask;
import com.sun.jbi.ui.common.JBIComponentInfo;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;

public class JbiListServiceEnginesTask
extends JbiQueryTask.JbiComponentQueryTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.engines.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.engines.failed";
    private String mServiceEngineName;
    private boolean mDescriptor;

    public String getServiceEngineName() {
        return this.mServiceEngineName;
    }

    public void setServiceEngineName(String serviceEngineName) {
        this.mServiceEngineName = serviceEngineName;
    }

    public boolean getDescriptor() {
        return this.mDescriptor;
    }

    public void setDescriptor(boolean descriptor) {
        this.mDescriptor = descriptor;
    }

    @Override
    public void executeTask() throws BuildException {
        this.initXmlOutput(JBIComponentInfo.writeAsXmlText(new ArrayList()));
        this.validateTaskPropertyForStateValue(this.getState());
        String target = this.getValidTarget();
        try {
            String result;
            String descriptor = null;
            String name = this.getServiceEngineName();
            if (null != name && name.length() > 0) {
                result = this.getJBIAdminCommands().showServiceEngine(name, this.toJbiComponentInfoState(this.getState()), this.getSharedLibraryName(), this.getServiceAssemblyName(), target);
                this.setSingleQueryResultType();
                if (this.mDescriptor && (descriptor = this.getJBIAdminCommands().getComponentInstallationDescriptor(name)) == null) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.show.component.descriptor.not.found", new String[]{name});
                    throw new Exception(errMsg);
                }
            } else {
                if (this.mDescriptor) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.show.component.descriptor.single.only", null);
                    throw new Exception(errMsg);
                }
                result = this.getJBIAdminCommands().listServiceEngines(this.toJbiComponentInfoState(this.getState()), this.getSharedLibraryName(), this.getServiceAssemblyName(), target);
            }
            this.printComponentQueryResults(result);
            if (descriptor != null) {
                this.printMessage("");
                this.printMessage(this.getI18NBundle().getMessage("jbi.ui.ant.print.comp.descriptor"));
                this.printMessage(descriptor);
                this.printMessage("");
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getEmptyQueryResultI18NKey() {
        return "jbi.ui.ant.print.no.engines";
    }

    @Override
    protected String getQueryResultHeaderI18NKey() {
        return "jbi.ui.ant.print.engines.header";
    }

    @Override
    protected String getQueryResultHeaderSeparatorI18NKey() {
        return "jbi.ui.ant.print.comp.info.header.separator";
    }

    @Override
    protected String getQueryResultPageSeparatorI18NKey() {
        return "jbi.ui.ant.print.comp.info.separator";
    }

    @Override
    protected String getEmptyQueryResultI18NMessage() {
        if (this.getQueryResultType() == 2) {
            return this.getI18NBundle().getMessage("jbi.ui.ant.print.no.engine.with.name", (Object)this.getServiceEngineName());
        }
        return this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey());
    }
}

