/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;

public class JbiListRuntimeLoggersTask
extends JbiTargetTask {
    private static final String LOGGER_SUCCESS_STATUS_KEY = "jbi.ui.ant.list.logger.successful";
    private static final String LOGGER_FAILED_STATUS_KEY = "jbi.ui.ant.list.logger.failed";
    private static final String INSTANCE_ERROR_PROP = "com.sun.jbi.cluster.instance.error";
    private static final String APP_CONFIG_NAME_KEY = "configurationName";
    private List mLoggerList;

    private void executeListRuntimeLoggers() throws BuildException {
        this.logDebug("Executing List Runtime Loggers ....");
        try {
            String target = this.getValidTarget();
            List tmpLoggerList = this.getLoggerList();
            ArrayList loggerList = new ArrayList(tmpLoggerList);
            for (Logger logger : tmpLoggerList) {
                String loggerName;
                if (logger == null || (loggerName = logger.getName()) == null || loggerName.trim().compareTo("") != 0) continue;
                loggerList.remove(logger);
            }
            if (loggerList.size() == 0) {
                Map resultLevels = this.getJBIAdminCommands().getRuntimeLoggerLevels(target);
                if (resultLevels == null) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.no.logger.resolved", null);
                    throw new BuildException(errMsg);
                }
                this.printRuntimeLoggerLevels(resultLevels);
            } else {
                Iterator it = loggerList.iterator();
                TreeMap<String, Level> resultLevels = new TreeMap<String, Level>();
                while (it.hasNext()) {
                    Logger logger = (Logger)it.next();
                    String loggerName = logger.getName();
                    if (loggerName == null || loggerName.compareTo("") == 0) continue;
                    Level resultLevel = this.getJBIAdminCommands().getRuntimeLoggerLevel(logger.getName(), target);
                    if (resultLevel == null) {
                        String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.no.logger.resolved", null);
                        throw new BuildException(errMsg);
                    }
                    resultLevels.put(logger.getName(), resultLevel);
                }
                this.printRuntimeLoggerLevels(resultLevels);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing List Configuration Task....");
        this.executeListRuntimeLoggers();
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return LOGGER_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return LOGGER_SUCCESS_STATUS_KEY;
    }

    protected String getLoggerEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.logger.info.empty" : "jbi.ui.ant.print.jbi.comp.logger.info.empty";
    }

    protected String getQueryResultHeaderSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header.separator" : "jbi.ui.ant.print.jbi.comp.config.info.header.separator";
    }

    protected String getLoggerQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.logger.info.header" : "jbi.ui.ant.print.jbi.comp.logger.info.header";
    }

    protected String getQueryResultPageSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.separator" : "jbi.ui.ant.print.jbi.comp.config.info.separator";
    }

    protected void printRuntimeLoggerLevels(Map<String, Level> theMap) {
        this.logDebug("Printing Rimtime Logger Levels....");
        if (theMap == null) {
            this.logDebug("List Runtime Logger Level map returns NULL");
        } else {
            this.logDebug("Size of Runtime Logger Level map: " + theMap.size());
        }
        boolean isRuntime = true;
        String header = this.getI18NBundle().getMessage(this.getLoggerQueryResultHeaderI18NKey(isRuntime), (Object)this.getValidTarget());
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey(isRuntime));
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey(isRuntime));
        String emptyResult = this.getI18NBundle().getMessage(this.getLoggerEmptyQueryResultI18NKey(isRuntime));
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (theMap == null || theMap.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            TreeSet<String> keys = new TreeSet<String>(theMap.keySet());
            for (Object e : keys) {
                String loggerName = (String)e;
                Level level = theMap.get(loggerName);
                String param = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.config.param", (Object)loggerName, (Object)(level == null ? "DEFAULT" : level.getLocalizedName()));
                msgWriter.println(param);
            }
            msgWriter.println(pageSeparator);
        }
        msgWriter.close();
        this.printMessage(stringWriter.getBuffer().toString());
    }

    protected List getLoggerList() {
        if (this.mLoggerList == null) {
            this.mLoggerList = new ArrayList();
        }
        return this.mLoggerList;
    }

    public Logger createLogger() {
        Logger logger = new Logger();
        this.getLoggerList().add(logger);
        return logger;
    }
}

