/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class JbiInstallSharedLibraryTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.install.slib.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.install.slib.failed";
    private File mInstallFile;
    private String mSLibName = null;

    public String getName() {
        return this.mSLibName;
    }

    public void setName(String name) {
        this.mSLibName = name;
    }

    public File getFile() {
        return this.mInstallFile;
    }

    public void setFile(File file) {
        this.mInstallFile = file;
    }

    protected void validateInstallFile(File installFile) throws BuildException {
        if (installFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.slib.archive.file.path.null");
        }
        if (installFile.getPath().trim().length() <= 0) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.slib.archive.file.path.required");
        }
        if (!installFile.exists()) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.slib.archive.file.not.exist", installFile.getName());
        }
        if (installFile.isDirectory()) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.archive.file.is.directory");
        }
    }

    protected void validateInstallFromDomainAttributes(String slibName, String target) throws BuildException {
        if (slibName.trim().length() == 0) {
            this.throwTaskBuildException("jbi.ui.ant.install.from.domain.error.slib.name.required");
        }
        if ("domain".equals(target)) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.slib.invalid.target.with.name.attrib");
        }
    }

    @Override
    public void executeTask() throws BuildException {
        String installFileAbsolutePath = null;
        boolean installFromDoamin = false;
        String slibName = this.getName();
        File installFile = this.getFile();
        String target = this.getValidTarget();
        if (slibName == null && installFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.slib.name.or.file.required");
        }
        if (slibName != null && installFile != null) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.slib.name.and.file.set");
        }
        if (slibName != null) {
            this.validateInstallFromDomainAttributes(slibName, target);
            installFromDoamin = true;
        } else {
            this.validateInstallFile(installFile);
            installFileAbsolutePath = installFile.getAbsolutePath();
        }
        try {
            String result = null;
            if (installFromDoamin) {
                this.getJBIAdminCommands().installSharedLibraryFromDomain(slibName, target);
            } else {
                result = this.getJBIAdminCommands().installSharedLibrary(installFileAbsolutePath, target);
            }
            this.printTaskSuccess(result);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }
}

