/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import org.apache.tools.ant.BuildException;

public class JbiExportApplicationEnvTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.export.app.env.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.export.app.env.failed";
    private String mServiceAssemblyName;
    private String mConfigDir;

    public String getServiceAssemblyName() {
        return this.mServiceAssemblyName;
    }

    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.mServiceAssemblyName = serviceAssemblyName;
    }

    public String getConfigDir() {
        return this.mConfigDir;
    }

    public void setConfigDir(String configDir) {
        this.mConfigDir = configDir;
    }

    @Override
    public void executeTask() throws BuildException {
        String target = this.getValidTarget();
        try {
            String appName = "" + this.getServiceAssemblyName();
            String configDir = "" + this.getConfigDir();
            this.logDebug("appName: " + appName + " target: " + target + " getConfigDir: " + configDir);
            String result = this.getJBIAdminCommands().exportApplicationConfiguration(appName, target, configDir);
            this.logDebug("Result: " + result);
            String returnMsg = this.getI18NBundle().getMessage("jbi.ui.ant.export.app.env.return.msg", (Object[])new String[]{configDir});
            this.printTaskSuccess(returnMsg);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }
}

