/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.framework.ComponentLoggerMBean;
import com.sun.jbi.management.ComponentLifeCycleMBean;
import com.sun.jbi.ui.common.JBIComponentInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import net.openesb.management.api.ComponentService;
import net.openesb.management.api.ManagementException;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.management.jmx.utils.ComponentConverter;
import net.openesb.management.jmx.utils.ComponentTypeConverter;
import net.openesb.management.jmx.utils.ServiceUnitConverter;
import net.openesb.management.jmx.utils.StateUtils;
import net.openesb.model.api.ComponentDescriptor;
import net.openesb.model.api.ComponentType;
import net.openesb.model.api.JBIComponent;
import net.openesb.model.api.ServiceUnit;
import net.openesb.model.api.State;

public class ComponentServiceImpl
extends AbstractServiceImpl
implements ComponentService {
    public Set<JBIComponent> findComponents(net.openesb.management.api.ComponentType type, String state, String sharedLibraryName, String serviceAssemblyName) throws ManagementException {
        ComponentState frameworkCompState = ComponentState.UNKNOWN;
        if (state != null) {
            frameworkCompState = StateUtils.toFrameworkComponentInfoState(state);
        }
        String slibName = null;
        String saName = null;
        if (sharedLibraryName != null && sharedLibraryName.trim().length() > 0) {
            slibName = sharedLibraryName.trim();
        }
        if (serviceAssemblyName != null && serviceAssemblyName.trim().length() > 0) {
            saName = serviceAssemblyName.trim();
        }
        com.sun.jbi.ComponentType internalComponenType = ComponentTypeConverter.convert(type);
        ComponentServiceImpl.getLogger().log(Level.FINE, "listComponents: Params : {0}, {1}, {2}, {3}", new Object[]{internalComponenType, frameworkCompState, slibName, saName});
        Collection<Object> componentNames = slibName == null && saName == null ? this.getComponentNamesWithStatus(internalComponenType, frameworkCompState) : (slibName == null && saName != null ? this.getComponentNamesDependentOnServiceAssembly(internalComponenType, frameworkCompState, saName) : (slibName != null && saName == null ? this.getComponentNamesDependentOnSharedLibrary(internalComponenType, frameworkCompState, slibName) : (slibName != null && saName != null ? this.getComponentNamesDependentOnSharedLibraryAndServiceAssembly(internalComponenType, frameworkCompState, slibName, saName) : new HashSet<String>())));
        List<JBIComponentInfo> compsInfo = this.toUiComponentInfoList(this.getFrameworkComponentInfoList(componentNames));
        HashSet<JBIComponent> components = new HashSet<JBIComponent>(compsInfo.size());
        for (JBIComponentInfo compInfo : compsInfo) {
            components.add(ComponentConverter.convert(compInfo));
        }
        return components;
    }

    public JBIComponent getComponent(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentInfo componentInfo = this.getComponentInfo(componentName);
        JBIComponentInfo uiComponentInfo = this.toUiComponentInfo(componentInfo);
        JBIComponent component = ComponentConverter.convert(uiComponentInfo);
        HashSet<ServiceUnit> sus = new HashSet<ServiceUnit>(componentInfo.getServiceUnitList().size());
        for (ServiceUnitInfo suInfo : componentInfo.getServiceUnitList()) {
            ServiceUnit serviceUnit = ServiceUnitConverter.convert(suInfo);
            try {
                String state = this.getDeploymentServiceMBean().getServiceUnitState(suInfo.getTargetComponent(), suInfo.getName());
                serviceUnit.setState(State.from((String)state));
            }
            catch (JBIException ex) {
                Logger.getLogger(ComponentServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            sus.add(serviceUnit);
        }
        component.setServiceUnits(sus);
        component.setSupportApplicationConfigurations(this.isAppConfigSupported(componentName));
        component.setSupportApplicationVariables(this.isAppVarsSupported(componentName));
        component.setSupportComponentConfigurations(this.isComponentConfigSupported(componentName));
        return component;
    }

    public ComponentDescriptor getDescriptor(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentInfo retrievedInfo = this.getComponentInfo(componentName);
        JBIComponentInfo jbiComponentInfo = this.toUiComponentInfo(retrievedInfo);
        ComponentDescriptor info = new ComponentDescriptor();
        info.setName(retrievedInfo.getName());
        info.setDescription(retrievedInfo.getDescription());
        if (jbiComponentInfo.getType().equals("binding-component")) {
            info.setType(ComponentType.BINDING_COMPONENT);
        } else if (jbiComponentInfo.getType().equals("service-engine")) {
            info.setType(ComponentType.SERVICE_ENGINE);
        } else if (jbiComponentInfo.getType().equals("shared-library")) {
            info.setType(ComponentType.SHARED_LIBRARY);
        }
        info.setBootstrapClassLoaderSelfFirst(retrievedInfo.isBootstrapClassLoaderSelfFirst());
        info.setBootstrapClassName(retrievedInfo.getBootstrapClassName());
        info.setBootstrapClassPathElements(retrievedInfo.getBootstrapClassPathElements());
        info.setClassLoaderSelfFirst(retrievedInfo.isClassLoaderSelfFirst());
        info.setClassPathElements(retrievedInfo.getClassPathElements());
        info.setComponentClassName(retrievedInfo.getComponentClassName());
        info.setInstallRoot(retrievedInfo.getInstallRoot());
        info.setSharedLibraries(retrievedInfo.getSharedLibraryNames());
        info.setWorkspaceRoot(retrievedInfo.getWorkspaceRoot());
        info.setBuildNumber(jbiComponentInfo.getBuildNumber());
        info.setVersion(jbiComponentInfo.getComponentVersion());
        return info;
    }

    public String getDescriptorAsXml(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentInfo retrievedInfo = this.getComponentInfo(componentName);
        if (retrievedInfo != null) {
            return retrievedInfo.getInstallationDescriptor();
        }
        return null;
    }

    private Collection getComponentNamesDependentOnSharedLibrary(com.sun.jbi.ComponentType frameworkCompType, ComponentState frameworkCompStatus, String slibName) {
        HashSet<String> compNameSet = new HashSet<String>(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus));
        HashSet<String> slibNameDepCompNameSet = new HashSet<String>(this.getComponentNamesDependentOnSharedLibrary(slibName));
        compNameSet.retainAll(slibNameDepCompNameSet);
        return compNameSet;
    }

    private Set<String> getComponentNamesWithStatus(com.sun.jbi.ComponentType frameworkCompType, ComponentState frameworkCompStatus) {
        List componentIdList = new ArrayList();
        ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
        if (componentQuery != null) {
            componentIdList = frameworkCompStatus == ComponentState.UNKNOWN ? componentQuery.getComponentIds(frameworkCompType) : componentQuery.getComponentIds(frameworkCompType, frameworkCompStatus);
        }
        return new HashSet<String>(componentIdList);
    }

    private Collection<String> getComponentNamesDependentOnServiceAssembly(com.sun.jbi.ComponentType frameworkCompType, ComponentState frameworkCompStatus, String saName) {
        HashSet<String> compNameSet = new HashSet<String>(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus));
        HashSet<String> saNameDepCompNameSet = new HashSet<String>(this.getComponentNamesDependentOnServiceAssembly(saName));
        compNameSet.retainAll(saNameDepCompNameSet);
        return compNameSet;
    }

    private Collection<String> getComponentNamesDependentOnServiceAssembly(String saId) {
        try {
            String[] componentNames = this.getDeploymentServiceMBean().getComponentsForDeployedServiceAssembly(saId);
            if (componentNames == null) {
                componentNames = new String[]{};
            }
            return new HashSet<String>(Arrays.asList(componentNames));
        }
        catch (Exception ex) {
            ComponentServiceImpl.getLogger().log(Level.FINE, ex.getMessage(), ex);
            return new HashSet<String>();
        }
    }

    private Collection<String> getComponentNamesDependentOnSharedLibraryAndServiceAssembly(com.sun.jbi.ComponentType frameworkCompType, ComponentState frameworkCompStatus, String slibName, String saName) {
        HashSet<String> compNameSet = new HashSet<String>(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus));
        HashSet<String> slibNameDepCompNameSet = new HashSet<String>(this.getComponentNamesDependentOnSharedLibrary(slibName));
        HashSet<String> saNameDepCompNameSet = new HashSet<String>(this.getComponentNamesDependentOnServiceAssembly(saName));
        slibNameDepCompNameSet.retainAll(saNameDepCompNameSet);
        compNameSet.retainAll(slibNameDepCompNameSet);
        return compNameSet;
    }

    private List<ComponentInfo> getFrameworkComponentInfoList(Collection<String> compNameList) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        try {
            ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
            if (componentQuery != null) {
                for (String componentName : compNameList) {
                    ComponentInfo componentInfo = this.getComponentInfo(componentName);
                    if (componentInfo == null) continue;
                    compInfoList.add(componentInfo);
                }
            }
        }
        catch (Exception ex) {
            ComponentServiceImpl.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
        return compInfoList;
    }

    private ComponentInfo getComponentInfo(String componentName) throws ManagementException {
        try {
            ComponentQuery componentQuery = this.getEnvironmentContext().getComponentQuery();
            if (componentQuery != null) {
                return componentQuery.getComponentInfo(componentName);
            }
        }
        catch (Exception ex) {
            ComponentServiceImpl.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
        return null;
    }

    public void start(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentLifeCycleMBean compLifecycleMBean = this.getComponentLifecycleMBean(componentName);
        try {
            compLifecycleMBean.start();
        }
        catch (JBIException ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.lifecycle.start.error", args, (Exception)((Object)ex));
        }
    }

    public void stop(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentLifeCycleMBean compLifecycleMBean = this.getComponentLifecycleMBean(componentName);
        try {
            compLifecycleMBean.stop();
        }
        catch (JBIException ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.lifecycle.stop.error", args, (Exception)((Object)ex));
        }
    }

    public void shutdown(String componentName, boolean force) throws ManagementException {
        this.checkComponentExists(componentName);
        ComponentLifeCycleMBean compLifecycleMBean = this.getComponentLifecycleMBean(componentName);
        try {
            compLifecycleMBean.shutDown(force);
        }
        catch (JBIException ex) {
            String[] args = new String[]{componentName, Boolean.toString(force)};
            throw this.createManagementException("rest.component.lifecycle.shutdown.error", args, (Exception)((Object)ex));
        }
    }

    public String install(String cmpZipURL) throws ManagementException {
        try {
            ObjectName installerObjectName = this.getInstallationServiceMBean().loadNewInstaller(cmpZipURL);
            String componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
            this.getComponentInstallerMBean(installerObjectName).install();
            return componentName;
        }
        catch (Exception e) {
            throw this.createManagementException(e.getMessage());
        }
    }

    public void uninstall(String componentName, boolean force) throws ManagementException {
        try {
            ObjectName installerObjectName = this.getInstallationServiceMBean().loadInstaller(componentName, force);
            this.getComponentInstallerMBean(installerObjectName).uninstall(force);
            this.getInstallationServiceMBean().unloadInstaller(componentName, true);
        }
        catch (Exception e) {
            throw this.createManagementException(e.getMessage());
        }
    }

    private ComponentLoggerMBean getComponentLoggerMBean(String componentName) throws ManagementException {
        try {
            ObjectName[] loggersObjectName = (ObjectName[])this.getComponentExtensionMBean(componentName).getLoggerMBeanNames().values().iterator().next();
            return this.getComponentLoggerMBean(loggersObjectName[0]);
        }
        catch (Exception ex) {
            String[] args = new String[]{componentName};
            throw this.createManagementException("rest.component.extension.getComponentLoggerLevels.error", args, ex);
        }
    }

    public Set<net.openesb.model.api.Logger> getLoggers(String componentName) throws ManagementException {
        this.checkComponentExists(componentName);
        try {
            ComponentLoggerMBean mBean = this.getComponentLoggerMBean(componentName);
            String[] loggerNames = mBean.getLoggerNames();
            HashSet<net.openesb.model.api.Logger> loggers = new HashSet<net.openesb.model.api.Logger>(loggerNames.length);
            for (String loggerName : loggerNames) {
                net.openesb.model.api.Logger logger = new net.openesb.model.api.Logger();
                logger.setName(loggerName);
                logger.setDisplayName(mBean.getDisplayName(loggerName));
                logger.setLevel(Level.parse(mBean.getLevel(loggerName)).getName());
                logger.setLocalizedLevel(mBean.getLevel(loggerName));
                loggers.add(logger);
            }
            return loggers;
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage());
        }
    }

    public void setLoggerLevel(String componentName, String loggerName, Level loggerLevel) throws ManagementException {
        this.checkComponentExists(componentName);
        try {
            ComponentLoggerMBean mBean = this.getComponentLoggerMBean(componentName);
            if (loggerLevel == null) {
                mBean.setDefault(loggerName);
            } else if (Level.ALL.equals(loggerLevel)) {
                mBean.setAll(loggerName);
            } else if (Level.CONFIG.equals(loggerLevel)) {
                mBean.setConfig(loggerName);
            } else if (Level.FINE.equals(loggerLevel)) {
                mBean.setFine(loggerName);
            } else if (Level.FINER.equals(loggerLevel)) {
                mBean.setFiner(loggerName);
            } else if (Level.FINEST.equals(loggerLevel)) {
                mBean.setFinest(loggerName);
            } else if (Level.INFO.equals(loggerLevel)) {
                mBean.setInfo(loggerName);
            } else if (Level.OFF.equals(loggerLevel)) {
                mBean.setOff(loggerName);
            } else if (Level.SEVERE.equals(loggerLevel)) {
                mBean.setSevere(loggerName);
            } else if (Level.WARNING.equals(loggerLevel)) {
                mBean.setWarning(loggerName);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage());
        }
    }

    public void upgrade(String componentName, String cmpZipURL) throws ManagementException {
        this.checkComponentExists(componentName);
        try {
            this.getInstallationServiceFacadeMBean().upgradeComponent(componentName, cmpZipURL);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage());
        }
    }
}

