/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.security.filter;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import net.openesb.rest.api.security.Session;
import net.openesb.rest.api.security.SessionManager;

@Priority(value=2000)
public class RequiresAuthenticationRequestFilter
implements ContainerRequestFilter {
    @Inject
    private SessionManager sessionManager;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authHeader = requestContext.getHeaderString("authorization");
        if (authHeader != null) {
            String token = RequiresAuthenticationRequestFilter.decode(authHeader);
            Session session = this.sessionManager.getSession((Serializable)((Object)token));
            if (session == null) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        } else {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private static String decode(String auth) {
        return auth.replaceFirst("[T|t]oken ", "");
    }
}

