/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.security;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class Session {
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    public static final long DEFAULT_GLOBAL_SESSION_TIMEOUT = 1800000L;
    private Serializable id;
    private Date startTimestamp;
    private Date stopTimestamp;
    private Date lastAccessTime = this.startTimestamp = new Date();
    private boolean expired;
    private long timeout = 1800000L;

    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStopTimestamp() {
        return this.stopTimestamp;
    }

    public void setStopTimestamp(Date stopTimestamp) {
        this.stopTimestamp = stopTimestamp;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected boolean isTimedOut() {
        if (this.isExpired()) {
            return true;
        }
        long timeout = this.getTimeout();
        Date lastAccessTime = this.getLastAccessTime();
        if (lastAccessTime == null) {
            String msg = "session.lastAccessTime for session with id [" + this.getId() + "] is null.  This value must be set at " + "least once, preferably at least upon instantiation.  Please check the " + this.getClass().getName() + " implementation and ensure " + "this value will be set (perhaps in the constructor?)";
            throw new IllegalStateException(msg);
        }
        long expireTimeMillis = System.currentTimeMillis() - timeout;
        Date expireTime = new Date(expireTimeMillis);
        return lastAccessTime.before(expireTime);
    }

    public void validate() throws Exception {
        if (this.isTimedOut()) {
            this.expire();
            Date lastAccessTime = this.getLastAccessTime();
            long timeout = this.getTimeout();
            Serializable sessionId = this.getId();
            DateFormat df = DateFormat.getInstance();
            String msg = "Session with id [" + sessionId + "] has expired. " + "Last access time: " + df.format(lastAccessTime) + ".  Current time: " + df.format(new Date()) + ".  Session timeout is set to " + timeout / 1000L + " seconds (" + timeout / 60000L + " minutes)";
            throw new Exception(msg);
        }
    }

    public void access() {
        this.lastAccessTime = new Date();
    }

    public void expire() {
        this.setExpired(true);
    }
}

