/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.ServiceAssemblyService;
import net.openesb.management.api.StatisticsService;
import net.openesb.model.api.ServiceAssembly;
import net.openesb.model.api.manage.Task;
import net.openesb.model.api.metric.Metric;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.LifecycleActionParam;

@RequiresAuthentication
public class ServiceAssemblyResource
extends AbstractResource {
    @Inject
    private ServiceAssemblyService serviceAssemblyService;
    @Inject
    private StatisticsService statisticsService;
    private final String assemblyName;

    public ServiceAssemblyResource(String assemblyName) {
        this.assemblyName = assemblyName;
    }

    @GET
    @Produces(value={"application/json"})
    public ServiceAssembly getServiceAssembly() throws ManagementException {
        return this.serviceAssemblyService.getServiceAssembly(this.assemblyName);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    public String getServiceAssemblyDescriptor(@QueryParam(value="su") String serviceUnit) throws ManagementException {
        return this.serviceAssemblyService.getDescriptorAsXml(this.assemblyName, serviceUnit);
    }

    @DELETE
    public Task undeploy(@DefaultValue(value="false") @QueryParam(value="force") boolean force) throws ManagementException {
        return this.serviceAssemblyService.undeploy(this.assemblyName, force);
    }

    @POST
    public Response doLifecycleAction(@QueryParam(value="action") LifecycleActionParam action, @DefaultValue(value="false") @QueryParam(value="force") boolean force) throws ManagementException {
        this.getLogger().log(Level.FINE, "Do lifecycle action {0} for service assembly {1}", new Object[]{action.getAction(), this.assemblyName});
        Task actionResult = null;
        switch (action.getAction()) {
            case START: {
                actionResult = this.serviceAssemblyService.start(this.assemblyName);
                break;
            }
            case STOP: {
                actionResult = this.serviceAssemblyService.stop(this.assemblyName);
                break;
            }
            case SHUTDOWN: {
                actionResult = this.serviceAssemblyService.shutdown(this.assemblyName, force);
                break;
            }
            default: {
                this.getLogger().log(Level.WARNING, "Unknown action {0} for service assembly {1}", new Object[]{action.getAction(), this.assemblyName});
            }
        }
        if (actionResult == null) {
            return Response.serverError().build();
        }
        return Response.ok((Object)actionResult, (String)"application/json").build();
    }

    @GET
    @Path(value="stats")
    @Produces(value={"application/json"})
    public Map<String, Metric> getStatistics() throws ManagementException {
        return this.statisticsService.getServiceAssemblyStatistics(this.assemblyName);
    }
}

