/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Response;
import net.openesb.management.api.ComponentService;
import net.openesb.management.api.ConfigurationService;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.StatisticsService;
import net.openesb.model.api.ComponentDescriptor;
import net.openesb.model.api.Configuration;
import net.openesb.model.api.JBIComponent;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.json.MetricsModule;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.ComponentApplicationResource;
import net.openesb.rest.api.resources.ComponentConfigurationResource;
import net.openesb.rest.api.resources.ComponentLoggersResource;
import net.openesb.rest.api.resources.EndpointsResource;
import net.openesb.rest.api.resources.LifecycleActionParam;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@RequiresAuthentication
public class ComponentResource
extends AbstractResource {
    private static final ObjectMapper mapper = new ObjectMapper().registerModules(new Module[]{new MetricsModule()});
    @Inject
    private ComponentService componentService;
    @Inject
    private StatisticsService statisticsService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ResourceContext resourceContext;
    private final String componentName;

    public ComponentResource(String componentName) {
        this.componentName = componentName;
    }

    @GET
    @Produces(value={"application/json"})
    public JBIComponent getComponent() throws ManagementException {
        return this.componentService.getComponent(this.componentName);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/json"})
    public ComponentDescriptor getComponentDescriptor() throws ManagementException {
        return this.componentService.getDescriptor(this.componentName);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    public String getComponentDescriptorAsXML() throws ManagementException {
        return this.componentService.getDescriptorAsXml(this.componentName);
    }

    @DELETE
    public Response uninstall(@DefaultValue(value="true") @QueryParam(value="force") boolean force) throws ManagementException {
        this.componentService.uninstall(this.componentName, force);
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"multipart/form-data"})
    public Response upgrade(@FormDataParam(value="component") InputStream is, @FormDataParam(value="component") FormDataContentDisposition fileDisposition) throws ManagementException {
        File compArchive = null;
        try {
            compArchive = this.createTemporaryFile(is, fileDisposition.getFileName());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "I/O errors while uploading the component archive.", e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        }
        if (compArchive != null) {
            this.componentService.upgrade(this.componentName, compArchive.toURI().toString());
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @POST
    public Response doLifecycleAction(@QueryParam(value="action") LifecycleActionParam action, @DefaultValue(value="false") @QueryParam(value="force") boolean force) throws ManagementException {
        this.getLogger().log(Level.FINE, "Do lifecycle action {0} for component {1}", new Object[]{action.getAction(), this.componentName});
        switch (action.getAction()) {
            case START: {
                this.componentService.start(this.componentName);
                break;
            }
            case STOP: {
                this.componentService.stop(this.componentName);
                break;
            }
            case SHUTDOWN: {
                this.componentService.shutdown(this.componentName, force);
                break;
            }
            default: {
                this.getLogger().log(Level.WARNING, "Unknown action {0} for component {1}", new Object[]{action.getAction(), this.componentName});
            }
        }
        return Response.ok().build();
    }

    @Path(value="stats")
    @GET
    @Produces(value={"application/json"})
    public String getStatistics() throws ManagementException, JsonProcessingException {
        return mapper.writeValueAsString((Object)this.statisticsService.getComponentStatistics(this.componentName));
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    public Configuration getConfigurationSchema() throws ManagementException {
        return this.configurationService.getConfigurationSchema(this.componentName);
    }

    @Path(value="endpoints")
    public EndpointsResource getEndpointsResource() {
        return (EndpointsResource)this.resourceContext.initResource((Object)new EndpointsResource(this.componentName));
    }

    @Path(value="loggers")
    public ComponentLoggersResource getLoggersResource() {
        return (ComponentLoggersResource)this.resourceContext.initResource((Object)new ComponentLoggersResource(this.componentName));
    }

    @Path(value="configuration")
    public ComponentConfigurationResource getComponentConfigurationResource() {
        return (ComponentConfigurationResource)this.resourceContext.initResource((Object)new ComponentConfigurationResource(this.componentName));
    }

    @Path(value="application")
    public ComponentApplicationResource getComponentApplicationResource() {
        return (ComponentApplicationResource)this.resourceContext.initResource((Object)new ComponentApplicationResource(this.componentName));
    }
}

