/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import net.openesb.management.api.ConfigurationService;
import net.openesb.management.api.ManagementException;
import net.openesb.model.api.ComponentConfiguration;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;

@RequiresAuthentication
public class ComponentConfigurationResource
extends AbstractResource {
    @Inject
    private ConfigurationService configurationService;
    private final String componentName;

    public ComponentConfigurationResource(String componentName) {
        this.componentName = componentName;
    }

    @GET
    @Produces(value={"application/json"})
    public Set<ComponentConfiguration> getComponentConfiguration() throws ManagementException {
        TreeSet<ComponentConfiguration> configurations = new TreeSet<ComponentConfiguration>(new Comparator<ComponentConfiguration>(){

            @Override
            public int compare(ComponentConfiguration conf1, ComponentConfiguration conf2) {
                return conf1.getName().compareTo(conf2.getName());
            }
        });
        configurations.addAll(this.configurationService.getComponentConfiguration(this.componentName));
        return configurations;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Set<ComponentConfiguration> setComponentConfiguration(Set<ComponentConfiguration> configurations) throws ManagementException {
        this.configurationService.updateComponentConfiguration(this.componentName, configurations);
        return this.getComponentConfiguration();
    }
}

