/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.security.Session;
import net.openesb.rest.api.security.SessionManager;
import net.openesb.security.AuthenticationException;
import net.openesb.security.AuthenticationToken;
import net.openesb.security.SecurityProvider;
import net.openesb.security.UsernamePasswordToken;

@Path(value="authentication")
public class AuthenticationResource
extends AbstractResource {
    @Inject
    private SecurityProvider securityProvider;
    @Inject
    private SessionManager sessionManager;

    @POST
    @Path(value="_login")
    public Response login(@Context ContainerRequestContext requestContext) {
        String auth = this.getAuthorizationHeader(requestContext);
        if (auth != null) {
            String[] lap = AuthenticationResource.decode(auth);
            if (lap == null || lap.length != 2) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            try {
                this.securityProvider.login((AuthenticationToken)new UsernamePasswordToken(lap[0], lap[1]));
                Session session = this.sessionManager.create(new HashMap<String, Object>());
                return Response.ok().entity((Object)session.getId()).build();
            }
            catch (AuthenticationException ae) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="_logout")
    @RequiresAuthentication
    public Response logout(@Context Session session) {
        session.setExpired(true);
        return Response.ok().build();
    }

    private String getAuthorizationHeader(ContainerRequestContext requestContext) {
        String auth = requestContext.getHeaderString("authorization");
        if (auth == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return null;
        }
        return auth;
    }

    public static String[] decode(String auth) {
        auth = auth.replaceFirst("[B|b]asic ", "");
        byte[] decodedBytes = null;
        try {
            decodedBytes = DatatypeConverter.parseBase64Binary((String)auth);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (decodedBytes == null || decodedBytes.length == 0) {
            return null;
        }
        return new String(decodedBytes).split(":", 2);
    }
}

