/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.feature;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.security.filter.RequiresAuthenticationRequestFilter;

public class RequiresAuthenticationFeature
implements DynamicFeature {
    private static final Logger LOG = Logger.getLogger(RequiresAuthenticationFeature.class.getName());

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Class resourceClass = resourceInfo.getResourceClass();
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceClass.isAnnotationPresent(RequiresAuthentication.class) || resourceClass.getSuperclass().isAnnotationPresent(RequiresAuthentication.class) || resourceMethod.isAnnotationPresent(RequiresAuthentication.class)) {
            LOG.log(Level.FINE, "RESTAPI-xxxx: Add authentication feature for {0}", resourceInfo);
            context.register(RequiresAuthenticationRequestFilter.class);
        }
    }
}

