/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.management.ComponentExtensionMBean;
import com.sun.jbi.management.ComponentLifeCycleMBean;
import com.sun.jbi.management.InstallerMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.facade.ClusterInstanceComponentConfiguration;
import com.sun.jbi.management.facade.ComponentConfiguration;
import com.sun.jbi.management.facade.ComponentExtension;
import com.sun.jbi.management.facade.ComponentLifeCycle;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.facade.InstallerConfiguration;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.util.FacadeMbeanHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class Installer
extends Facade
implements InstallerMBean {
    private String mComponentName;
    private ComponentType mComponentType;
    private Map<String, ObjectName> mInstanceInstallers;
    private InstallerConfiguration mInstallerConfig;

    public Installer(EnvironmentContext ctx, String target, String compName, Map instanceInstallers) throws ManagementException {
        super(ctx, target);
        this.mComponentName = compName;
        this.mInstanceInstallers = instanceInstallers;
        this.mComponentType = this.getComponentType();
    }

    public Installer(EnvironmentContext ctx, String target, String compName) throws ManagementException {
        this(ctx, target, compName, null);
    }

    public synchronized ObjectName getInstallerConfigurationMBean() throws JBIException {
        if (this.mInstallerConfig != null && this.mMBeanSvr.isRegistered(this.mInstallerConfig.getObjectName())) {
            return this.mInstallerConfig.getObjectName();
        }
        try {
            ObjectName configMBean = null;
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException("getInstallerConfigurationMBean");
            }
            configMBean = this.mPlatform.isStandaloneServer(this.mTarget) ? this.createInstanceConfigurationMBean() : this.createClusterConfigurationMBean();
            return configMBean;
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    public String getInstallRoot() {
        String installRoot = "";
        try {
            if ("domain".equals(this.mTarget)) {
                this.throwNotSupportedManagementException("getInstallRoot");
            } else {
                ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(this.mComponentName);
                if (compInfo != null) {
                    installRoot = compInfo.getInstallRoot();
                }
            }
        }
        catch (ManagementException mex) {
            throw new RuntimeException(mex.getMessage());
        }
        return installRoot;
    }

    public ObjectName install() throws JBIException {
        ObjectName ComponentLCObjName = null;
        try {
            if (this.mTarget.equals("domain")) {
                ComponentLCObjName = this.registerComponentLifeCycleMBean(this.mTarget, "install");
                this.registerComponentExtensionMBean("domain");
            } else {
                ComponentLCObjName = this.installComponentToTarget();
                this.registerComponentExtensionMBean("domain");
                this.registerComponentLifeCycleMBean("domain", "install");
            }
        }
        catch (Exception ex) {
            String errMsg = ex.getMessage();
            if (!(ex instanceof ManagementException)) {
                try {
                    errMsg = this.mMsgBuilder.buildExceptionMessage("install", ex);
                }
                catch (Exception exp) {
                    // empty catch block
                }
            }
            throw new JBIException(errMsg);
        }
        return ComponentLCObjName;
    }

    public boolean isInstalled() {
        if ("domain".equals(this.mTarget)) {
            return false;
        }
        try {
            if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                List<String> servers = this.getGenericQuery().getServersInstallingComponent(this.mComponentName);
                return servers.contains(this.mTarget);
            }
            List<String> clusters = this.getGenericQuery().getClustersInstallingComponent(this.mComponentName);
            return clusters.contains(this.mTarget);
        }
        catch (JBIException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void uninstall() throws JBIException {
        this.uninstall(false);
    }

    @Override
    public void uninstall(boolean force) throws JBIException {
        try {
            if ("domain".equals(this.mTarget)) {
                this.unregisterComponentExtensionMBean(this.mTarget, this.mComponentName, this.mComponentType);
                this.unregisterComponentLifeCycleMBean(this.mTarget, this.mComponentName, this.mComponentType);
            } else {
                this.uninstallComponentFromTarget(force);
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    private ObjectName registerComponentExtensionMBean() throws ManagementException {
        return this.registerComponentExtensionMBean(this.mTarget);
    }

    private ObjectName registerComponentExtensionMBean(String target) throws ManagementException {
        try {
            ObjectName facadeCompExtMBean = null;
            facadeCompExtMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Extension, target) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Extension, target);
            if (!this.mMBeanSvr.isRegistered(facadeCompExtMBean)) {
                ComponentExtension componentInfo = new ComponentExtension(this.mEnvCtx, target, this.mComponentName, this.mComponentType);
                StandardMBean mbean = new StandardMBean(componentInfo, ComponentExtensionMBean.class);
                this.mMBeanSvr.registerMBean(mbean, facadeCompExtMBean);
            }
            return facadeCompExtMBean;
        }
        catch (Exception ex) {
            String[] params = new String[]{this.mComponentName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException("registerComponentExtensionMBean", "JBI_ADMIN_FAILED_REGISTER_COMPONENT_MBEAN", params);
            return null;
        }
    }

    private void registerComponentConfigurationMBean() throws ManagementException {
        this.registerComponentConfigurationMBean(this.mTarget);
    }

    private void registerComponentConfigurationMBean(String target) throws ManagementException {
        try {
            ObjectName facadeCompCfgMBean = null;
            facadeCompCfgMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Configuration, target) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Configuration, target);
            if (!this.mMBeanSvr.isRegistered(facadeCompCfgMBean)) {
                ComponentConfiguration componentCfg = new ComponentConfiguration(this.mEnvCtx, target, this.mComponentName, this.mComponentType);
                this.mMBeanSvr.registerMBean(componentCfg, facadeCompCfgMBean);
            }
            Set<Object> clusterInstances = new HashSet();
            if (this.mPlatform.isCluster(target)) {
                clusterInstances = this.mPlatform.getServersInCluster(target);
            }
            for (String clusterInstance : clusterInstances) {
                facadeCompCfgMBean = null;
                facadeCompCfgMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Configuration, clusterInstance) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Configuration, clusterInstance);
                if (this.mMBeanSvr.isRegistered(facadeCompCfgMBean)) continue;
                ClusterInstanceComponentConfiguration componentCfg = new ClusterInstanceComponentConfiguration(this.mEnvCtx, clusterInstance, target, this.mComponentName, this.mComponentType);
                this.mMBeanSvr.registerMBean(componentCfg, facadeCompCfgMBean);
            }
        }
        catch (Exception ex) {
            String[] params = new String[]{this.mComponentName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException("registerComponentConfigurationMBean", "JBI_ADMIN_FAILED_REGISTER_COMPONENT_MBEAN", params);
        }
    }

    private ObjectName registerComponentLifeCycleMBean(String target, String taskId) throws JBIException {
        return this.registerComponentLifeCycleMBean(target, taskId, null);
    }

    private ObjectName registerComponentLifeCycleMBean(String target, String taskId, Map instanceComponentLCMBeans) throws ManagementException {
        try {
            ObjectName compLCName = FacadeMbeanHelper.getComponentLifeCycleFacadeMBeanName(this.mComponentName, this.mComponentType, target, this.mEnvCtx.getMBeanNames());
            if (!this.mMBeanSvr.isRegistered(compLCName)) {
                ComponentLifeCycle componentLC = new ComponentLifeCycle(this.mEnvCtx, target, this.mComponentName, this.mComponentType, instanceComponentLCMBeans);
                StandardMBean mbean = new StandardMBean(componentLC, ComponentLifeCycleMBean.class);
                this.mMBeanSvr.registerMBean(mbean, compLCName);
            }
            return compLCName;
        }
        catch (Exception ex) {
            String[] params = new String[]{this.mComponentName, ex.getMessage()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_FAILED_REGISTER_COMPONENT_MBEAN", params);
            return null;
        }
    }

    private ObjectName installComponentToTarget() throws ManagementException {
        Map<String, ObjectName> instanceComponentLCMBeans;
        this.componentInstallationCheck(this.mComponentName, true);
        this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_INSTALLING_COMPONENT_TO_TARGET", this.mComponentName, this.mTarget));
        ObjectName remoteComponentLCObjName = null;
        if (this.mInstallerConfig != null) {
            this.mInstallerConfig.setReadOnly();
        }
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            remoteComponentLCObjName = this.installComponentToInstance(this.mTarget);
            instanceComponentLCMBeans = new HashMap<String, ObjectName>();
            instanceComponentLCMBeans.put(this.mTarget, remoteComponentLCObjName);
        } else {
            instanceComponentLCMBeans = this.installComponentToCluster(this.mTarget);
        }
        this.addComponentToTarget();
        this.registerComponentExtensionMBean();
        this.registerComponentConfigurationMBean();
        return this.registerComponentLifeCycleMBean(this.mTarget, "loadNewInstaller", instanceComponentLCMBeans);
    }

    private ObjectName installComponentToInstance(String serverName) throws ManagementException {
        ObjectName remoteComponentLCObjName = null;
        if (this.isInstanceRunning(serverName)) {
            if (this.mInstallerConfig != null && this.mInstallerConfig.getAttributeCount() > 0) {
                this.configureInstanceInstaller(serverName);
            }
            String[] sign = new String[]{};
            Object[] params = new Object[]{};
            remoteComponentLCObjName = (ObjectName)this.invokeRemoteOperation(this.mInstanceInstallers.get(serverName), "install", params, sign, serverName);
        }
        return remoteComponentLCObjName;
    }

    private Map<String, ObjectName> installComponentToCluster(String clusterName) throws ManagementException {
        HashMap<String, ObjectName> componentLCMBeans = new HashMap<String, ObjectName>();
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    ObjectName componentLCMBean = null;
                    if (this.canPerformOperationOnInstanceCheck(instance, "install")) {
                        componentLCMBean = this.installComponentToInstance(instance);
                    }
                    componentLCMBeans.put(instance, componentLCMBean);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                    componentLCMBeans.put(instance, null);
                }
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("install", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_INSTALL_COMPONENT_TO_INSTANCE");
            }
        }
        return componentLCMBeans;
    }

    private ComponentType getComponentType() throws ManagementException {
        ComponentType compType;
        try {
            compType = this.getGenericQuery().getComponentType(this.mComponentName);
        }
        catch (Exception rex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("getComponentType", rex));
        }
        return compType;
    }

    private void uninstallComponentFromTarget(boolean force) throws JBIException {
        this.componentInstallationCheck(this.mComponentName, false);
        this.dependentServiceAssemblyCheck();
        this.mLog.fine(this.mTranslator.getString("JBI_ADMIN_UNINSTALLING_COMPONENT_FROM_TARGET", this.mComponentName, this.mTarget));
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            this.uninstallComponentFromInstance(this.mTarget, force);
        } else {
            this.uninstallComponentFromCluster(this.mTarget, force);
        }
        this.removeComponentFromTarget();
        this.unregisterComponentExtensionMBean(this.mTarget, this.mComponentName, this.mComponentType);
        this.unregisterComponentLifeCycleMBean(this.mTarget, this.mComponentName, this.mComponentType);
        this.unregisterComponentConfigurationMBean(this.mTarget, this.mComponentName, this.mComponentType);
    }

    private void uninstallComponentFromInstance(String serverName, boolean force) throws ManagementException {
        this.componentStartedCheck(this.mComponentName, serverName);
        if (this.isInstanceRunning(serverName)) {
            Object[] params;
            String[] sign;
            if (force) {
                sign = new String[]{"boolean"};
                params = new Object[]{force};
            } else {
                sign = new String[]{};
                params = new Object[]{};
            }
            this.invokeRemoteVoidOperation(this.mInstanceInstallers.get(serverName), "uninstall", params, sign, serverName);
        }
    }

    private void uninstallComponentFromCluster(String clusterName, boolean force) throws ManagementException {
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    if (!this.canPerformOperationOnInstanceCheck(instance, "uninstall")) continue;
                    this.uninstallComponentFromInstance(instance, force);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            if (exceptionMap.size() > 0) {
                this.handleClusteredInstanceFailures("uninstallComponent", exceptionMap, exceptionMap.size(), "JBI_ADMIN_FAILED_UNINSTALL_COMPONENT_FROM_INSTANCE");
            }
        }
    }

    private ObjectName createClusterConfigurationMBean() throws ManagementException {
        String instanceName = null;
        ObjectName facadeMBean = null;
        ObjectName configMBean = null;
        for (String instance : this.mPlatform.getServersInCluster(this.mTarget)) {
            if (!this.isInstanceRunning(instance)) continue;
            instanceName = instance;
            break;
        }
        if (instanceName != null) {
            configMBean = this.getConfigurationMBeanForInstance(instanceName);
            if (configMBean != null) {
                facadeMBean = this.createInstallerConfigurationMBean(instanceName, configMBean);
            }
        } else {
            facadeMBean = this.createInstallerConfigurationMBean(this.mTarget, null);
        }
        return facadeMBean;
    }

    private ObjectName createInstanceConfigurationMBean() throws ManagementException {
        ObjectName facadeMBean = null;
        ObjectName configMBean = null;
        if (this.isInstanceRunning(this.mTarget)) {
            configMBean = this.getConfigurationMBeanForInstance(this.mTarget);
            if (configMBean != null) {
                facadeMBean = this.createInstallerConfigurationMBean(this.mTarget, configMBean);
            }
        } else {
            facadeMBean = this.createInstallerConfigurationMBean(this.mTarget, null);
        }
        return facadeMBean;
    }

    private ObjectName getConfigurationMBeanForInstance(String instanceName) throws ManagementException {
        ObjectName configMBean = null;
        String op = "getInstallerConfigurationMBean";
        if (this.isInstanceRunning(instanceName)) {
            String[] sign = new String[]{};
            Object[] params = new Object[]{};
            configMBean = (ObjectName)this.invokeRemoteOperation(this.mInstanceInstallers.get(instanceName), op, params, sign, instanceName);
            if (configMBean != null && !this.isMBeanRegisteredOnInstance(configMBean, instanceName)) {
                Object[] msgParams = new String[]{configMBean.toString(), instanceName};
                String errMsg = this.mTranslator.getString("JBI_ADMIN_COMPONENT_INSTALLER_CONFIG_MBEAN_NOT_REGISTERED", msgParams);
                String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage(op, MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])msgParams, MessageBuilder.getMessageToken(errMsg));
                throw new ManagementException(jbiTaskMsg);
            }
        }
        return configMBean;
    }

    private void addComponentToTarget() throws ManagementException {
        try {
            if (!this.mTarget.equals(this.mPlatform.getAdminServerName())) {
                ComponentQuery compQuery = this.getRegistry().getComponentQuery("domain");
                ComponentInfoImpl compInfo = (ComponentInfoImpl)compQuery.getComponentInfo(this.mComponentName);
                compInfo.setStatus(ComponentState.SHUTDOWN);
                compInfo.setInstallRoot(this.getComponentInstallRoot());
                compInfo.setWorkspaceRoot(this.getComponentWorkspaceRoot());
                if (this.mInstallerConfig != null) {
                    for (Object obj : this.mInstallerConfig.getAttributeList()) {
                        Attribute attr = (Attribute)obj;
                        String attrValue = null;
                        if (attr.getValue() != null) {
                            attrValue = attr.getValue().toString();
                        }
                        compInfo.setProperty(attr.getName(), attrValue);
                    }
                }
                this.getUpdater().addComponent(this.mTarget, compInfo);
            }
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("addComponentToTarget", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    private void removeComponentFromTarget() throws ManagementException {
        try {
            if (!this.mTarget.equals(this.mPlatform.getAdminServerName())) {
                this.getUpdater().removeComponent(this.mTarget, this.mComponentName);
            }
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("removeComponentFromTarget", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    private String getComponentInstallRoot() throws RegistryException, ManagementException {
        Archive archive = this.getRegistry().getRepository().getArchive(ArchiveType.COMPONENT, this.mComponentName);
        String archivePath = archive.getPath();
        return new File(archivePath).getParent();
    }

    private String getComponentWorkspaceRoot() throws RegistryException, ManagementException {
        StringBuffer strBuf = new StringBuffer(this.getComponentInstallRoot());
        strBuf.append(File.separator);
        strBuf.append("workspace");
        return strBuf.toString();
    }

    private boolean canPerformOperationOnInstanceCheck(String instanceName, String taskId) {
        boolean canDo = true;
        ObjectName installer = this.mInstanceInstallers.get(instanceName);
        if (installer == null) {
            String warning = this.mTranslator.getString("JBI_ADMIN_CANNOT_PERFORM_COMPONENT_INSTALLATION_OP", taskId, this.mComponentName, instanceName);
            this.mLog.fine(warning);
            canDo = false;
        }
        return canDo;
    }

    private void dependentServiceAssemblyCheck() throws ManagementException {
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(this.mComponentName);
        List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
        ArrayList<String> sus = new ArrayList<String>();
        if (!suList.isEmpty()) {
            for (ServiceUnitInfo suInfo : suList) {
                sus.add(suInfo.getName());
            }
            Object[] params = new String[]{this.mComponentName, Installer.listToString(sus)};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_CANNOT_UNINSTALL_COMPONENT_WITH_DEPLOYED_SUS", params);
            String response = this.mMsgBuilder.buildFrameworkMessage("dependentServiceAssemblyCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(response);
        }
    }

    private ObjectName createInstallerConfigurationMBean(String instanceName, ObjectName configMBean) throws ManagementException {
        ObjectName mbName;
        MBeanInfo mbInfo = null;
        try {
            if (configMBean != null) {
                mbInfo = this.getMBeanServerConnection(instanceName).getMBeanInfo(configMBean);
            }
            mbName = this.mMBeanNames.getComponentMBeanName(this.mComponentName, this.mComponentType, MBeanNames.ComponentServiceType.InstallerConfiguration, this.mTarget);
            this.mInstallerConfig = new InstallerConfiguration(mbInfo, mbName);
            this.mMBeanSvr.registerMBean(this.mInstallerConfig, mbName);
        }
        catch (JMException jmEx) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(jmEx);
            throw new ManagementException("getInstallerConfigurationMBean", actualEx);
        }
        catch (IOException ioEx) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("getInstallerConfigurationMBean", ioEx));
        }
        return mbName;
    }

    private void configureInstanceInstaller(String instanceName) throws ManagementException {
        try {
            this.getMBeanServerConnection(instanceName).setAttributes(this.getConfigurationMBeanForInstance(instanceName), this.mInstallerConfig.getAttributeList());
        }
        catch (JMException jmEx) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(jmEx);
            throw new ManagementException("install", actualEx);
        }
        catch (IOException ioEx) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("install", ioEx));
        }
    }

    private void componentStartedCheck(String compName, String instanceName) throws ManagementException {
        ComponentState compState = this.getComponentState(compName, instanceName);
        if (ComponentState.STARTED == compState) {
            Object[] params = new String[]{compName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_COMPONENT_STARTED", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("componentStoppedCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiMsg);
        }
    }
}

