/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.DescriptorSupport;
import com.sun.jbi.management.config.NotificationListenerInfo;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.registry.xml.RegistryDocument;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.util.StringHelper;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.security.KeyStoreUtil;
import com.sun.jbi.util.Constants;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;

public class RuntimeConfiguration
extends RequiredModelMBean
implements NotificationEmitter,
Constants {
    protected static MessageBuilder sMsgBuilder;
    protected PlatformContext mPlatformCtx;
    private static EnvironmentContext sEnvCtx;
    private ManagementContext mMgtCtx;
    private static StringTranslator sTranslator;
    private static Logger sLog;
    protected ConfigurationCategory mCategory;
    protected String mTarget;
    private static boolean isGlobalAttribSetInited;
    protected List<NotificationListenerInfo> mListeners;
    protected static MBeanNotificationInfo[] sNotificationInfo;
    protected static HashMap<String, String> sTypeMap;
    private static String MASKED_ATTRIB_VALUE;
    private long mSeqNumber = 0L;

    public RuntimeConfiguration(ModelMBeanInfo mbeanInfo, ConfigurationCategory category, String target) throws Exception {
        super(mbeanInfo);
        sMsgBuilder = new MessageBuilder(RuntimeConfiguration.getTranslator());
        this.mCategory = category;
        this.mTarget = target == null ? this.getPlatformContext().getTargetName() : target;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object regValue = null;
        this.getPlatformContext();
        if (attribute.equalsIgnoreCase("com.sun.jbi")) {
            return this.getJbiLogLevel();
        }
        try {
            String strValue = null;
            if (RuntimeConfiguration.getEnvironmentContext().isFrameworkReady(false)) {
                strValue = this.getRegistry().getGenericQuery().getAttribute(this.mTarget, this.mCategory, attribute);
            } else {
                RegistryDocument regDoc = new RegistryDocument(RuntimeConfiguration.getEnvironmentContext().getReadOnlyRegistry());
                strValue = regDoc.getConfigurationAttribute(this.mTarget, this.mCategory, attribute);
            }
            ModelMBeanAttributeInfo attribInfo = this.getAttributeInfo(attribute);
            if (this.isPassword(attribute)) {
                regValue = MASKED_ATTRIB_VALUE;
            } else if (attribInfo != null && strValue != null) {
                regValue = StringHelper.convertStringToType(attribInfo.getType(), strValue);
            }
            if (regValue == null && attribInfo != null) {
                Descriptor descr = attribInfo.getDescriptor();
                regValue = descr.getFieldValue("default");
            }
            if (this.mCategory.equals((Object)ConfigurationCategory.Logger) && "DEFAULT".equals(regValue) && !this.getPlatformContext().isStandaloneServer(this.mTarget) && !this.getPlatformContext().isClusteredServer(this.mTarget)) {
                regValue = this.getJbiLogLevel();
            }
        }
        catch (Exception ex) {
            JBIException jbiEx;
            try {
                jbiEx = new JBIException(sMsgBuilder.buildExceptionMessage("getAttribute", ex));
            }
            catch (ManagementException mex) {
                jbiEx = new JBIException(ex.getMessage());
            }
            throw new MBeanException((Exception)((Object)jbiEx));
        }
        if (regValue == null) {
            throw new AttributeNotFoundException(attribute);
        }
        return regValue;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList updatedAttributes = new AttributeList();
        for (Object attribute : attributes) {
            Attribute attr = (Attribute)attribute;
            try {
                this.setAttribute(attr);
                updatedAttributes.add(attr);
            }
            catch (Exception ex) {
                String errMsg = RuntimeConfiguration.getTranslator().getString("CS_SET_ATTRIBUTE_FAILED", attr.getName(), attr.getValue(), ex.getMessage());
                RuntimeConfiguration.getLogger().warning(errMsg);
            }
        }
        return updatedAttributes;
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList list = new AttributeList();
        for (String attrName : attributeNames) {
            try {
                Object attrValue = this.getAttribute(attrName);
                list.add(new Attribute(attrName, attrValue));
            }
            catch (Exception ex) {
                String errMsg = RuntimeConfiguration.getTranslator().getString("CS_GET_ATTRIBUTE_FAILED", attrName, ex.getMessage());
                RuntimeConfiguration.getLogger().fine(errMsg);
            }
        }
        return list;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("persist")) {
            try {
                this.persist();
            }
            catch (Exception ex) {
                JBIException jbiEx;
                try {
                    jbiEx = new JBIException(sMsgBuilder.buildExceptionMessage("invoke", ex));
                }
                catch (ManagementException mex) {
                    jbiEx = new JBIException(ex.getMessage());
                }
                throw new MBeanException((Exception)((Object)jbiEx));
            }
            return new Object();
        }
        if (actionName.equals("deleteOverride")) {
            try {
                if (params.length < 1 || signature.length < 1) {
                    throw new Exception("Insufficient parameters");
                }
                if (!(params[0] instanceof String)) {
                    throw new Exception("Incorrect type " + params[0].getClass().getName());
                }
                if (params.length > 0) {
                    this.deleteOverride((String)params[0]);
                }
            }
            catch (Exception ex) {
                JBIException jbiEx;
                try {
                    jbiEx = new JBIException(sMsgBuilder.buildExceptionMessage("deleteOverride", ex));
                }
                catch (ManagementException mex) {
                    jbiEx = new JBIException(ex.getMessage());
                }
                throw new MBeanException((Exception)((Object)jbiEx));
            }
            return new Object();
        }
        throw new UnsupportedOperationException("invoke");
    }

    public static ModelMBeanInfo createMBeanInfo(ModelMBeanAttributeInfo[] attributeInfos) throws Exception {
        RuntimeConfiguration.checkMBeanAttributeInfos(attributeInfos);
        ModelMBeanInfoSupport mbeanInfo = null;
        ModelMBeanConstructorInfo[] constructorInfos = new ModelMBeanConstructorInfo[]{};
        ModelMBeanOperationInfo[] operationInfos = new ModelMBeanOperationInfo[]{};
        MBeanNotificationInfo[] mbeanNotInfos = RuntimeConfiguration.initNotificationInfos();
        ModelMBeanNotificationInfo[] notificationInfos = new ModelMBeanNotificationInfo[mbeanNotInfos.length];
        int i = 0;
        for (MBeanNotificationInfo mbeanNotInfo : mbeanNotInfos) {
            notificationInfos[i] = new ModelMBeanNotificationInfo(mbeanNotInfo.getNotifTypes(), mbeanNotInfo.getName(), mbeanNotInfo.getDescription());
            ++i;
        }
        mbeanInfo = new ModelMBeanInfoSupport("com.sun.jbi.management.facade.RuntimeConfigurationMBean.class", "Runtime Configuration MBean", attributeInfos, constructorInfos, operationInfos, notificationInfos);
        return mbeanInfo;
    }

    protected void checkIsValidAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException {
        String attrName = attribute.getName();
        Object attrValue = attribute.getValue();
        String type = this.getMatchingAttribute(attrName);
        if (type != null) {
            if (attrValue != null && !type.equals(attrValue.getClass().getName())) {
                String errMsg = RuntimeConfiguration.getTranslator().getString("CS_INVALID_ATTRIBUTE_VALUE", attrName, type, attrValue.getClass().getName());
                throw new InvalidAttributeValueException(errMsg);
            }
        } else {
            throw new AttributeNotFoundException(attrName);
        }
        this.checkIsWritable(attrName);
        this.checkLowerLimit(attrName, attrValue);
        this.checkUpperLimit(attrName, attrValue);
        this.checkEnumRange(attrName, attrValue);
    }

    protected String getMatchingAttribute(String name) {
        MBeanInfo mbeanInfo = this.getMBeanInfo();
        MBeanAttributeInfo[] attribInfos = mbeanInfo.getAttributes();
        String type = null;
        for (MBeanAttributeInfo attribInfo : attribInfos) {
            if (!attribInfo.getName().equals(name) || !sTypeMap.containsKey(type = attribInfo.getType())) continue;
            type = sTypeMap.get(type);
        }
        return type;
    }

    protected static StringTranslator getTranslator() {
        if (sTranslator == null) {
            EnvironmentContext envCtx = EnvironmentAccess.getContext();
            sTranslator = envCtx.getStringTranslator("com.sun.jbi.management");
        }
        return sTranslator;
    }

    protected static Logger getLogger() {
        if (sLog == null) {
            sLog = Logger.getLogger("com.sun.jbi.management");
        }
        return sLog;
    }

    protected ManagementContext getManagementContext() {
        if (this.mMgtCtx == null) {
            this.mMgtCtx = new ManagementContext(RuntimeConfiguration.getEnvironmentContext());
        }
        return this.mMgtCtx;
    }

    protected PlatformContext getPlatformContext() {
        if (this.mPlatformCtx == null) {
            this.mPlatformCtx = RuntimeConfiguration.getEnvironmentContext().getPlatformContext();
        }
        return this.mPlatformCtx;
    }

    protected static EnvironmentContext getEnvironmentContext() {
        if (sEnvCtx == null) {
            sEnvCtx = EnvironmentAccess.getContext();
        }
        return sEnvCtx;
    }

    protected void persist() throws Exception {
        Registry registry = this.getRegistry();
        if (registry != null) {
            ModelMBeanAttributeInfo[] attribInfos;
            Updater updater = registry.getUpdater();
            for (ModelMBeanAttributeInfo attribInfo : attribInfos = (ModelMBeanAttributeInfo[])this.getMBeanInfo().getAttributes()) {
                String value;
                Descriptor descr = attribInfo.getDescriptor();
                String persistAttrValue = value = descr.getFieldValue("default").toString();
                if (this.isPassword(attribInfo.getName())) {
                    KeyStoreUtil ksUtil = this.getPlatformContext().getKeyStoreUtil();
                    persistAttrValue = ksUtil.encrypt(value);
                }
                updater.setAttribute("domain", this.mCategory, attribInfo.getName(), persistAttrValue);
            }
        }
    }

    protected void deleteOverride(String attrName) throws Exception {
    }

    protected ModelMBeanAttributeInfo getAttributeInfo(String attribute) throws MBeanException {
        ModelMBeanInfo mbeanInfo = (ModelMBeanInfo)((Object)this.getMBeanInfo());
        ModelMBeanAttributeInfo attribInfo = null;
        if (mbeanInfo != null) {
            attribInfo = mbeanInfo.getAttribute(attribute);
        }
        return attribInfo;
    }

    protected Registry getRegistry() {
        return (Registry)RuntimeConfiguration.getEnvironmentContext().getRegistry();
    }

    protected void persistDomainConfig() throws MBeanException {
        try {
            GenericQuery query = this.getRegistry().getGenericQuery();
            ObjectName configMBeanFilter = new ObjectName("com.sun.jbi:Target=domain,ServiceName=ConfigurationService,*");
            if (!RuntimeConfiguration.getEnvironmentContext().getPlatformContext().isAdminServer()) {
                configMBeanFilter = new ObjectName("com.sun.jbi:JbiName=domain,ServiceName=ConfigurationService,*");
            }
            if (!query.isGlobalConfigurationDefined()) {
                ObjectName[] domainConfigMBeans;
                MBeanServerConnection mbns = this.getPlatformContext().getMBeanServerConnection(RuntimeConfiguration.getEnvironmentContext().getPlatformContext().getInstanceName());
                Set<ObjectName> nameSet = mbns.queryNames(configMBeanFilter, null);
                for (ObjectName domainConfigMBean : domainConfigMBeans = nameSet.toArray(new ObjectName[nameSet.size()])) {
                    mbns.invoke(domainConfigMBean, "persist", new Object[0], new String[0]);
                }
            }
        }
        catch (Exception ex) {
            String errMsg = RuntimeConfiguration.getTranslator().getString("JBI_ADMIN_GLOBAL_CFG_PERSIST_FAILED", this.mCategory.toString(), ex.getMessage());
            JBIException jbiEx = new JBIException(errMsg);
            throw new MBeanException((Exception)((Object)jbiEx), errMsg);
        }
    }

    protected boolean isPassword(String attrName) {
        boolean isPassword = false;
        ModelMBeanAttributeInfo attribInfo = null;
        try {
            attribInfo = this.getAttributeInfo(attrName);
        }
        catch (MBeanException ex) {
            sLog.log(Level.FINE, "Failed to get Attribute Info for " + attrName, ex);
        }
        if (attribInfo != null) {
            Descriptor descr = attribInfo.getDescriptor();
            Boolean isPwd = (Boolean)descr.getFieldValue(DescriptorSupport.RequiredFieldName.IS_PASSWORD.getFieldName());
            isPassword = isPwd;
        }
        return isPassword;
    }

    protected List<NotificationListenerInfo> getListeners() {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<NotificationListenerInfo>();
        }
        return this.mListeners;
    }

    protected void notifyListenersOfAttributeChange(Attribute attribute) throws Exception {
        RuntimeConfiguration.getLogger().log(Level.FINE, "Notifying listeners of attribute change {0}", attribute.toString());
        AttributeChangeNotification attribChangeNotif = new AttributeChangeNotification(this, this.mSeqNumber++, System.currentTimeMillis(), RuntimeConfiguration.getTranslator().getString("ATTRIBUTE_CHANGE_NOTIF_MSG"), attribute.getName(), this.getAttributeInfo(attribute.getName()).getType(), this.getAttribute(attribute.getName()), attribute.getValue());
        for (NotificationListenerInfo listener : this.getListeners()) {
            NotificationFilter filter = listener.getNotificationFilter();
            boolean sendNotif = true;
            if (filter != null && !filter.isNotificationEnabled(attribChangeNotif)) {
                RuntimeConfiguration.getLogger().log(Level.FINE, "Notification not enabled in listener {0}", attribute.toString());
                sendNotif = false;
            }
            if (!sendNotif) continue;
            RuntimeConfiguration.getLogger().log(Level.FINE, "Notifying a listener of attribute change {0}", attribute.toString());
            listener.getNotificationListener().handleNotification(attribChangeNotif, listener.getHandback());
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.getListeners().add(new NotificationListenerInfo(listener, filter, handback));
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        List<NotificationListenerInfo> listeners = this.getListeners();
        ArrayList<NotificationListenerInfo> listenersToRemove = new ArrayList<NotificationListenerInfo>();
        for (NotificationListenerInfo listenerInfo : listeners) {
            if (!listenerInfo.getNotificationListener().equals(listener)) continue;
            listenersToRemove.add(listenerInfo);
        }
        if (listenersToRemove.isEmpty()) {
            throw new ListenerNotFoundException();
        }
        listeners.removeAll(listenersToRemove);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        List<NotificationListenerInfo> listeners = this.getListeners();
        ArrayList<NotificationListenerInfo> listenersToRemove = new ArrayList<NotificationListenerInfo>();
        for (NotificationListenerInfo listenerInfo : listeners) {
            if (!listenerInfo.getNotificationListener().equals(listener)) continue;
            boolean filterMatches = false;
            boolean handbackMatches = false;
            filterMatches = filter == null ? listenerInfo.getNotificationFilter() == null : filter.equals(listenerInfo.getNotificationFilter());
            handbackMatches = handback == null ? listenerInfo.getHandback() == null : handback.equals(listenerInfo.getHandback());
            if (!filterMatches || !handbackMatches) continue;
            listenersToRemove.add(listenerInfo);
        }
        if (listenersToRemove.isEmpty()) {
            throw new ListenerNotFoundException();
        }
        listeners.removeAll(listenersToRemove);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return RuntimeConfiguration.initNotificationInfos();
    }

    private static MBeanNotificationInfo[] initNotificationInfos() {
        if (sNotificationInfo == null) {
            sNotificationInfo = new MBeanNotificationInfo[1];
            RuntimeConfiguration.sNotificationInfo[0] = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "javax.management.AttributeChangeNotification", RuntimeConfiguration.getTranslator().getString("ATTRIBUTE_CHANGE_NOTIF_MSG"));
        }
        return sNotificationInfo;
    }

    private static void initPrimitiveTypeMap() {
        sTypeMap = new HashMap();
        sTypeMap.put("int", "java.lang.Integer");
        sTypeMap.put("float", "java.lang.Float");
        sTypeMap.put("long", "java.lang.Long");
        sTypeMap.put("double", "java.lang.Double");
        sTypeMap.put("byte", "java.lang.Byte");
        sTypeMap.put("char", "java.lang.Character");
        sTypeMap.put("boolean", "java.lang.Boolean");
        sTypeMap.put("short", "java.lang.Short");
    }

    private static void checkMBeanAttributeInfos(ModelMBeanAttributeInfo[] mbeanAttrInfos) throws ManagementException {
        for (ModelMBeanAttributeInfo attribInfo : mbeanAttrInfos) {
            Descriptor descr = attribInfo.getDescriptor();
            if (descr == null) {
                Object[] params = new String[]{attribInfo.getName()};
                String errMsg = RuntimeConfiguration.getTranslator().getString("CS_ATTRIBUTE_DESCR_NULL", params);
                throw new ManagementException(sMsgBuilder.buildFrameworkMessage("checkMBeanAttributeInfos", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg)));
            }
            if (descr.isValid()) continue;
            Object[] params = new String[]{attribInfo.getName()};
            String errMsg = RuntimeConfiguration.getTranslator().getString("CS_ATTRIBUTE_DESCR_INVALID", params);
            throw new ManagementException(sMsgBuilder.buildFrameworkMessage("checkMBeanAttributeInfos", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg)));
        }
    }

    private boolean canValueBeNull(String type) {
        boolean canBeNull = false;
        if ("java.util.logging.Level".equals(type)) {
            canBeNull = true;
        }
        return canBeNull;
    }

    private String getJbiLogLevel() {
        Level level = this.getPlatformContext().getJbiLogLevel(this.mTarget);
        if (level != null) {
            return level.toString();
        }
        level = this.getPlatformContext().getJbiLogLevel("domain");
        if (level != null) {
            return level.toString();
        }
        return Level.INFO.toString();
    }

    private void checkLowerLimit(String attrName, Object attrValue) throws InvalidAttributeValueException, MBeanException {
        ModelMBeanAttributeInfo attribInfo = this.getAttributeInfo(attrName);
        Descriptor descr = attribInfo.getDescriptor();
        Object minValue = descr.getFieldValue(DescriptorSupport.OptionalFieldName.MIN_VALUE.getFieldName());
        if (minValue != null) {
            Comparable comparable;
            int comparison;
            Object minValueObj = null;
            try {
                minValueObj = StringHelper.convertStringToType(attribInfo.getType(), minValue.toString());
            }
            catch (Exception ex) {
                String errMsg;
                Object[] params = new String[]{minValue.toString(), attribInfo.getType().toString(), ex.toString()};
                String jbiMsg = errMsg = RuntimeConfiguration.getTranslator().getString("JBI_ADMIN_FAILED_MIN_VALUE_CONVERSION", params);
                try {
                    jbiMsg = sMsgBuilder.buildFrameworkMessage("checkLowerLimit", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                }
                catch (ManagementException mex) {
                    // empty catch block
                }
                throw new InvalidAttributeValueException(jbiMsg);
            }
            if (minValueObj != null && minValueObj instanceof Comparable && attrValue instanceof Comparable && (comparison = (comparable = (Comparable)minValueObj).compareTo(attrValue)) > 0) {
                String errMsg;
                Object[] params = new String[]{attrName, attrValue == null ? "null" : attrValue.toString(), minValueObj.toString()};
                String jbiMsg = errMsg = RuntimeConfiguration.getTranslator().getString("JBI_ADMIN_CONFIG_PARAM_LESS_THAN_MIN_VALUE", params);
                try {
                    jbiMsg = sMsgBuilder.buildFrameworkMessage("checkLowerLimit", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                }
                catch (ManagementException mex) {
                    // empty catch block
                }
                throw new InvalidAttributeValueException(jbiMsg);
            }
        }
    }

    private void checkUpperLimit(String attrName, Object attrValue) throws InvalidAttributeValueException, MBeanException {
        ModelMBeanAttributeInfo attribInfo = this.getAttributeInfo(attrName);
        Descriptor descr = attribInfo.getDescriptor();
        Object maxValue = descr.getFieldValue(DescriptorSupport.OptionalFieldName.MAX_VALUE.getFieldName());
        if (maxValue != null) {
            Comparable comparable;
            int comparison;
            Object maxValueObj = null;
            try {
                maxValueObj = StringHelper.convertStringToType(attribInfo.getType(), maxValue.toString());
            }
            catch (Exception ex) {
                String errMsg;
                Object[] params = new String[]{maxValue.toString(), attribInfo.getType().toString(), ex.toString()};
                String jbiMsg = errMsg = RuntimeConfiguration.getTranslator().getString("JBI_ADMIN_FAILED_MAX_VALUE_CONVERSION", params);
                try {
                    sMsgBuilder.buildFrameworkMessage("checkUpperLimit", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                }
                catch (ManagementException mex) {
                    // empty catch block
                }
                throw new InvalidAttributeValueException(jbiMsg);
            }
            if (maxValueObj != null && maxValueObj instanceof Comparable && attrValue instanceof Comparable && (comparison = (comparable = (Comparable)maxValueObj).compareTo(attrValue)) < 0) {
                String errMsg;
                Object[] params = new String[]{attrName, attrValue == null ? "null" : attrValue.toString(), maxValueObj.toString()};
                String jbiMsg = errMsg = sTranslator.getString("JBI_ADMIN_CONFIG_PARAM_MORE_THAN_MAX_VALUE", params);
                try {
                    jbiMsg = sMsgBuilder.buildFrameworkMessage("checkUpperLimit", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                }
                catch (ManagementException mex) {
                    // empty catch block
                }
                throw new InvalidAttributeValueException(jbiMsg);
            }
        }
    }

    private void checkEnumRange(String attrName, Object attrValue) throws InvalidAttributeValueException, MBeanException {
        ModelMBeanAttributeInfo attribInfo = this.getAttributeInfo(attrName);
        Descriptor descr = attribInfo.getDescriptor();
        String enumValue = (String)descr.getFieldValue(DescriptorSupport.OptionalFieldName.ENUM_VALUE.getFieldName());
        if (enumValue != null) {
            String[] values = this.convertEnumValuetoArray(enumValue);
            boolean found = false;
            for (String value : values) {
                if (!value.equals(attrValue)) continue;
                found = true;
            }
            if (!found) {
                String errMsg;
                Object[] params = new String[]{attrName, attrValue == null ? "null" : attrValue.toString(), enumValue};
                String jbiMsg = errMsg = sTranslator.getString("JBI_ADMIN_CONFIG_PARAM_OUT_OF_RANGE", params);
                try {
                    jbiMsg = sMsgBuilder.buildFrameworkMessage("checkEnumRange", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                }
                catch (ManagementException mex) {
                    // empty catch block
                }
                throw new InvalidAttributeValueException(jbiMsg);
            }
        }
    }

    private void checkIsWritable(String attrName) throws InvalidAttributeValueException, MBeanException {
        ModelMBeanAttributeInfo attribInfo = this.getAttributeInfo(attrName);
        if (!attribInfo.isWritable()) {
            String errMsg;
            Object[] params = new String[]{attrName};
            String jbiMsg = errMsg = sTranslator.getString("JBI_ADMIN_CONFIG_READ_ONLY_ATTRIBUTE", params);
            try {
                jbiMsg = sMsgBuilder.buildFrameworkMessage("checkIsWritable", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            }
            catch (ManagementException mex) {
                // empty catch block
            }
            throw new InvalidAttributeValueException(jbiMsg);
        }
    }

    private String[] convertEnumValuetoArray(String enumValue) {
        ArrayList<String> values = new ArrayList<String>();
        if (enumValue != null) {
            enumValue = enumValue.trim();
            int start = enumValue.indexOf("{") + 1;
            int end = enumValue.indexOf("}");
            String csl = enumValue.substring(start, end);
            StringTokenizer strTok = new StringTokenizer(csl, ",");
            while (strTok.hasMoreTokens()) {
                values.add(strTok.nextToken().trim());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    static {
        sNotificationInfo = null;
        MASKED_ATTRIB_VALUE = "*******";
        RuntimeConfiguration.initPrimitiveTypeMap();
        RuntimeConfiguration.initNotificationInfos();
    }
}

