/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.notification;

import com.sun.esb.management.api.notification.EventNotification;
import com.sun.esb.management.api.notification.EventNotificationListener;
import com.sun.esb.management.api.notification.NotificationService;
import com.sun.esb.management.base.services.BaseServiceImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.impl.notification.EventNotificationImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NotificationServiceImpl
extends BaseServiceImpl
implements NotificationListener,
NotificationService {
    static final long serialVersionUID = -1L;
    private ArrayList<EventNotificationListener> listeners = new ArrayList();
    private ExecutorService executorService;

    public NotificationServiceImpl() {
        super(null, false);
    }

    public NotificationServiceImpl(MBeanServerConnection serverConnection) {
        super(serverConnection, false);
    }

    public NotificationServiceImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        super(serverConnection, isRemoteConnection);
        this.executorService = Executors.newCachedThreadPool();
        this.registerForNotifications();
    }

    protected void registerForNotifications() {
        try {
            ObjectName mbeanName = this.getNotificationServiceMBeanObjectName();
            this.remoteConnection.addNotificationListener(mbeanName, this, null, new Object());
        }
        catch (InstanceNotFoundException e) {
        }
        catch (ManagementRemoteException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        EventNotificationImpl event = new EventNotificationImpl(notification.getSource());
        event.setNotification(notification);
        this.executorService.execute(new NotificationSender(this.listeners, event));
    }

    @Override
    public void addNotificationEventListener(EventNotificationListener aListener) throws ManagementRemoteException {
        this.listeners.add(aListener);
    }

    @Override
    public void removeNotificationEventListener(EventNotificationListener aListener) {
        this.listeners.remove(aListener);
    }

    class NotificationSender
    implements Runnable {
        private ArrayList<EventNotificationListener> listeners = new ArrayList();
        EventNotification eventNotification;

        NotificationSender(ArrayList<EventNotificationListener> en, EventNotification notif) {
            this.listeners = en;
            this.eventNotification = notif;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList list = null;
            NotificationSender notificationSender = this;
            synchronized (notificationSender) {
                list = (ArrayList)this.listeners.clone();
            }
            for (EventNotificationListener aListener : list) {
                aListener.processNotification(this.eventNotification);
            }
        }
    }
}

