/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.base.services;

import com.sun.esb.management.base.services.AbstractServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class AbstractListStateServiceMBeansImpl
extends AbstractServiceMBeansImpl
implements Serializable {
    static final long serialVersionUID = -1L;
    protected static final int ANY_FRAMEWORK_COMPONENT_STATE = -1;
    protected static final String FRAMEWORK_SA_STARTED_STATE = "Started";
    protected static final String FRAMEWORK_SA_STOPPED_STATE = "Stopped";
    protected static final String FRAMEWORK_SA_SHUTDOWN_STATE = "Shutdown";
    protected static final String FRAMEWORK_SA_ANY_STATE = "any";
    protected static final String FRAMEWORK_SU_STARTED_STATE = "started";
    protected static final String FRAMEWORK_SU_STOPPED_STATE = "stopped";
    protected static final String FRAMEWORK_SU_SHUTDOWN_STATE = "shutdown";
    protected static final String FRAMEWORK_SU_UNKNOWN_STATE = "unknown";
    protected static final String COMPONENT_VERSION_NS = "http://www.sun.com/jbi/descriptor/identification";
    protected static final String COMPONENT_VERSION_NS_NEW = "http://www.sun.com/jbi/descriptor/identification/V1.0";
    protected static final String COMPONENT_VERSION_XPATH_QUERY = "/jbi:jbi/jbi:component/jbi:identification/identification:VersionInfo";
    protected static final String SHARED_LIBRARY_VERSION_XPATH_QUERY = "/jbi:jbi/jbi:shared-library/jbi:identification/identification:VersionInfo";

    public AbstractListStateServiceMBeansImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    protected ObjectName getComponentLifeCycleMBeanObjectName(String componentName, String targetName) throws ManagementRemoteException {
        if (!this.isExistingComponent(componentName, targetName)) {
            String[] args = new String[]{componentName, targetName};
            Exception exception = this.createManagementException("ui.mbean.lifecycle.mbean.not.found.with.query", args, null);
            throw new ManagementRemoteException(exception);
        }
        ObjectName lifecycleObjectNamePattern = null;
        try {
            lifecycleObjectNamePattern = JBIJMXObjectNames.getComponentLifeCycleMBeanObjectNamePattern(componentName, targetName);
        }
        catch (MalformedObjectNameException ex) {
            throw new ManagementRemoteException(ex);
        }
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(lifecycleObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            String[] args = new String[]{componentName, targetName};
            Exception exception = this.createManagementException("ui.mbean.lifecycle.mbean.not.found.with.query", args, null);
            throw new ManagementRemoteException(exception);
        }
        if (objectNames.size() > 1) {
            String[] args = new String[]{componentName, targetName};
            Exception exception = this.createManagementException("ui.mbean.multiple.lifecycle.mbeans.found.with.query", args, null);
            throw new ManagementRemoteException(exception);
        }
        ObjectName lifecyleObjectName = objectNames.iterator().next();
        AbstractListStateServiceMBeansImpl.logDebug("LifecyleMBean : " + lifecyleObjectName);
        return lifecyleObjectName;
    }

    protected String listComponents(ComponentType type, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiJBIComponentInfoState(state);
        ComponentState frameworkCompState = ComponentState.UNKNOWN;
        if (state != null) {
            frameworkCompState = AbstractListStateServiceMBeansImpl.toFrameworkComponentInfoState(state);
        }
        String result = "";
        try {
            result = JBIComponentInfo.writeAsXmlText(this.toUiComponentInfoList(this.getFrameworkComponentInfoListForEnginesAndBindings(type, frameworkCompState, sharedLibraryName, serviceAssemblyName, targetName), targetName));
        }
        catch (ManagementRemoteException e) {
            throw new ManagementRemoteException(e);
        }
        return result;
    }

    protected void validateUiJBIComponentInfoState(String state) throws ManagementRemoteException {
        if (state == null || state.length() == 0) {
            return;
        }
        String stateValue = state.toString();
        if (!(FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(stateValue) || FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(stateValue) || FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(stateValue) || "Unknown".equalsIgnoreCase(stateValue))) {
            String[] args = new String[]{state};
            Exception exception = this.createManagementException("ui.mbean.list.error.invalid.state", args, null);
            throw new ManagementRemoteException(exception);
        }
    }

    protected void validateUiServiceAssemblyInfoState(String state) throws ManagementRemoteException {
        if (state == null || state.length() == 0) {
            return;
        }
        String stateValue = state;
        if (!(FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(stateValue) || FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(stateValue) || FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(stateValue) || "Unknown".equalsIgnoreCase(stateValue))) {
            String[] args = new String[]{state};
            Exception exception = this.createManagementException("ui.mbean.list.error.invalid.state", args, null);
            throw new ManagementRemoteException(exception);
        }
    }

    protected static ComponentState toFrameworkComponentInfoState(String uiCompState) {
        if (uiCompState == null) {
            return ComponentState.UNKNOWN;
        }
        String compState = uiCompState.trim();
        if (compState.length() <= 0) {
            return ComponentState.UNKNOWN;
        }
        if (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.SHUTDOWN;
        }
        if (FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.STARTED;
        }
        if (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(compState)) {
            return ComponentState.STOPPED;
        }
        return ComponentState.UNKNOWN;
    }

    protected List getFrameworkComponentInfoListForEnginesAndBindings(ComponentType frameworkCompType, ComponentState frameworkCompState, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        String slibName = null;
        String saName = null;
        if (sharedLibraryName != null && sharedLibraryName.trim().length() > 0) {
            slibName = sharedLibraryName.trim();
        }
        if (serviceAssemblyName != null && serviceAssemblyName.trim().length() > 0) {
            saName = serviceAssemblyName.trim();
        }
        AbstractListStateServiceMBeansImpl.logDebug("getFrameworkComponentInfoForEnginesAndBindings : Params : " + (Object)((Object)frameworkCompType) + ", " + (Object)((Object)frameworkCompState) + ", " + slibName + ", " + saName);
        Collection componentNames = new HashSet();
        componentNames = slibName == null && saName == null ? this.getComponentNamesWithStatus(frameworkCompType, frameworkCompState, targetName) : (slibName == null && saName != null ? this.getComponentNamesDependentOnServiceAssembly(frameworkCompType, frameworkCompState, saName, targetName) : (slibName != null && saName == null ? this.getComponentNamesDependentOnSharedLibrary(frameworkCompType, frameworkCompState, slibName, targetName) : (slibName != null && saName != null ? this.getComponentNamesDependentOnSharedLibraryAndServiceAssembly(frameworkCompType, frameworkCompState, slibName, saName, targetName) : new HashSet())));
        return this.getFrameworkComponentInfoList(componentNames, targetName);
    }

    protected List getFrameworkComponentInfoList(Collection compNameList, String targetName) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        try {
            ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                Iterator itr = compNameList.iterator();
                while (itr.hasNext()) {
                    ComponentInfo componentInfo = componentQuery.getComponentInfo((String)itr.next());
                    if (componentInfo == null) continue;
                    compInfoList.add(componentInfo);
                }
            }
        }
        catch (Exception ex) {
            AbstractListStateServiceMBeansImpl.logDebug(ex);
        }
        return compInfoList;
    }

    protected List getFrameworkComponentInfoListForSharedLibraries(String componentName, String targetName) throws ManagementRemoteException {
        String compName = null;
        if (componentName != null && componentName.trim().length() > 0) {
            compName = componentName.trim();
        }
        AbstractListStateServiceMBeansImpl.logDebug("getFrameworkComponentInfoForSharedLibraries: Params : " + compName);
        List<Object> slibNames = new ArrayList();
        List frameworkCompInfoList = new ArrayList();
        ComponentQuery componentQuery = null;
        if (compName == null) {
            AbstractListStateServiceMBeansImpl.logDebug("Listing All Shared Libraries in the schemaorg_apache_xmlbeans.system");
            componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                slibNames = componentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
            }
        } else {
            AbstractListStateServiceMBeansImpl.logDebug("Listing Shared Libraries for the component " + compName);
            componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                ComponentInfo componentInfo = componentQuery.getComponentInfo(compName);
                if (componentInfo == null) {
                    String[] args = new String[]{compName};
                    Exception exception = this.createManagementException("ui.mbean.component.id.does.not.exist", args, null);
                    throw new ManagementRemoteException(exception);
                }
                slibNames = componentInfo.getSharedLibraryNames();
            }
        }
        frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraryNames(slibNames, targetName);
        return frameworkCompInfoList;
    }

    protected List getFrameworkComponentInfoListForSharedLibraryNames(Collection slibNameList, String targetName) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        try {
            ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                Iterator itr = slibNameList.iterator();
                while (itr.hasNext()) {
                    ComponentInfo componentInfo = componentQuery.getSharedLibraryInfo((String)itr.next());
                    if (componentInfo == null) continue;
                    compInfoList.add(componentInfo);
                }
            }
        }
        catch (Exception ex) {
            AbstractListStateServiceMBeansImpl.logDebug(ex);
        }
        return compInfoList;
    }

    protected List getUiComponentInfoList(ComponentType frameworkCompType, String targetName) throws ManagementRemoteException {
        Set compNameSet = this.getComponentNamesWithStatus(frameworkCompType, ComponentState.UNKNOWN, targetName);
        List frameworkCompList = this.getFrameworkComponentInfoList(new ArrayList(compNameSet), targetName);
        ArrayList<JBIComponentInfo> uiCompList = new ArrayList<JBIComponentInfo>();
        for (ComponentInfo frameworkCompInfo : frameworkCompList) {
            JBIComponentInfo uiCompInfo = this.toUiComponentInfo(frameworkCompInfo, targetName);
            uiCompList.add(uiCompInfo);
        }
        return uiCompList;
    }

    protected List toUiComponentInfoList(List frameworkCompList, String targetName) throws ManagementRemoteException {
        ArrayList<JBIComponentInfo> uiCompList = new ArrayList<JBIComponentInfo>();
        for (ComponentInfo frameworkCompInfo : frameworkCompList) {
            JBIComponentInfo uiCompInfo = this.toUiComponentInfo(frameworkCompInfo, targetName);
            uiCompList.add(uiCompInfo);
        }
        return uiCompList;
    }

    protected JBIComponentInfo toUiComponentInfo(ComponentInfo frameworkCompInfo, String targetName) throws ManagementRemoteException {
        String state = "Unknown";
        String componentName = frameworkCompInfo.getName();
        String componentDescription = frameworkCompInfo.getDescription();
        ComponentState componentStatus = ComponentState.UNKNOWN;
        ComponentType componentType = frameworkCompInfo.getComponentType();
        if (!(ComponentType.BINDING.equals((Object)componentType) || ComponentType.ENGINE.equals((Object)componentType) || ComponentType.BINDINGS_AND_ENGINES.equals((Object)componentType))) {
            componentStatus = frameworkCompInfo.getStatus();
            state = AbstractListStateServiceMBeansImpl.toUiComponentInfoState(componentStatus);
        } else {
            try {
                ObjectName lifeCycleMBeanObjectName = null;
                lifeCycleMBeanObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
                state = (String)this.getMBeanAttribute(lifeCycleMBeanObjectName, "CurrentState");
            }
            catch (ManagementRemoteException exception) {
                componentStatus = ComponentState.UNKNOWN;
                state = "Unknown";
            }
        }
        if ("Running".equals(state)) {
            state = FRAMEWORK_SA_STARTED_STATE;
        }
        String type = AbstractListStateServiceMBeansImpl.toUiComponentInfoType(componentType);
        String componentVersion = "";
        String buildNumber = "";
        try {
            String descriptorXml = frameworkCompInfo.getInstallationDescriptor();
            InputSource inputSource = new InputSource(new StringReader(descriptorXml));
            String queryString = "";
            if (ComponentType.BINDING.equals((Object)componentType) || ComponentType.ENGINE.equals((Object)componentType) || ComponentType.BINDINGS_AND_ENGINES.equals((Object)componentType)) {
                queryString = COMPONENT_VERSION_XPATH_QUERY;
            } else if (ComponentType.SHARED_LIBRARY.equals((Object)componentType)) {
                queryString = SHARED_LIBRARY_VERSION_XPATH_QUERY;
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new IdentificationNSContext());
            Node rtnNode = (Node)xpath.evaluate(queryString, inputSource, XPathConstants.NODE);
            if (rtnNode != null) {
                Node buildAttr;
                NamedNodeMap attrs = rtnNode.getAttributes();
                Node verAttr = attrs.getNamedItem("specification-version");
                if (verAttr != null) {
                    componentVersion = verAttr.getNodeValue();
                }
                if ((buildAttr = attrs.getNamedItem("build-number")) != null) {
                    buildNumber = buildAttr.getNodeValue();
                }
            } else {
                inputSource = new InputSource(new StringReader(descriptorXml));
                xpath.setNamespaceContext(new IdentificationNewNSContext());
                rtnNode = (Node)xpath.evaluate(queryString, inputSource, XPathConstants.NODE);
                if (rtnNode != null) {
                    Node buildAttr;
                    NamedNodeMap attrs = rtnNode.getAttributes();
                    Node verAttr = attrs.getNamedItem("component-version");
                    if (verAttr != null) {
                        componentVersion = verAttr.getNodeValue();
                    }
                    if ((buildAttr = attrs.getNamedItem("build-number")) != null) {
                        buildNumber = buildAttr.getNodeValue();
                    }
                }
            }
        }
        catch (Exception exp) {
            String[] args = new String[]{""};
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.get.attrs.error", args, null);
            throw new ManagementRemoteException(exception);
        }
        JBIComponentInfo compInfo = new JBIComponentInfo(type, state, componentName, componentDescription);
        compInfo.setComponentVersion(componentVersion);
        compInfo.setBuildNumber(buildNumber);
        return compInfo;
    }

    protected static String toFrameworkServiceAssemblyState(String uiState) {
        if (uiState == null) {
            return FRAMEWORK_SA_ANY_STATE;
        }
        String saState = uiState.trim();
        if (saState.length() <= 0) {
            return FRAMEWORK_SA_ANY_STATE;
        }
        if (FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_STARTED_STATE;
        }
        if (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_STOPPED_STATE;
        }
        if (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(saState)) {
            return FRAMEWORK_SA_SHUTDOWN_STATE;
        }
        return FRAMEWORK_SA_ANY_STATE;
    }

    protected static String toUiServiceAssemblyState(String frameworkState) {
        String uiState = "Unknown";
        if (frameworkState == null) {
            return "Unknown";
        }
        String saState = frameworkState.trim();
        if (saState.length() <= 0) {
            return "Unknown";
        }
        uiState = FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_STARTED_STATE : (FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_STOPPED_STATE : (FRAMEWORK_SA_SHUTDOWN_STATE.equalsIgnoreCase(saState) ? FRAMEWORK_SA_SHUTDOWN_STATE : "Unknown"));
        return uiState;
    }

    protected static String toUiServiceUnitState(String frameworkState) {
        String uiState = "Unknown";
        if (frameworkState == null) {
            return "Unknown";
        }
        String suState = frameworkState.trim();
        if (suState.length() <= 0) {
            return "Unknown";
        }
        uiState = FRAMEWORK_SU_STARTED_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_STARTED_STATE : (FRAMEWORK_SU_STOPPED_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_STOPPED_STATE : (FRAMEWORK_SU_SHUTDOWN_STATE.equalsIgnoreCase(suState) ? FRAMEWORK_SA_SHUTDOWN_STATE : "Unknown"));
        return uiState;
    }

    protected static String toUiComponentInfoState(ComponentState frameworkCompState) {
        String uiState = "Unknown";
        switch (frameworkCompState) {
            case SHUTDOWN: {
                uiState = FRAMEWORK_SA_SHUTDOWN_STATE;
                break;
            }
            case STARTED: {
                uiState = FRAMEWORK_SA_STARTED_STATE;
                break;
            }
            case STOPPED: {
                uiState = FRAMEWORK_SA_STOPPED_STATE;
                break;
            }
            default: {
                uiState = "Unknown";
            }
        }
        return uiState;
    }

    protected static ComponentType toFrameworkComponentInfoType(String uiCompType) {
        if ("binding-component".equalsIgnoreCase(uiCompType)) {
            return ComponentType.BINDING;
        }
        if ("service-engine".equalsIgnoreCase(uiCompType)) {
            return ComponentType.BINDING;
        }
        if ("shared-library".equalsIgnoreCase(uiCompType)) {
            return ComponentType.SHARED_LIBRARY;
        }
        return ComponentType.BINDINGS_AND_ENGINES;
    }

    protected static String toUiComponentInfoType(ComponentType frameworkCompType) {
        String uiType = FRAMEWORK_SU_UNKNOWN_STATE;
        switch (frameworkCompType) {
            case BINDING: {
                uiType = "binding-component";
                break;
            }
            case ENGINE: {
                uiType = "service-engine";
                break;
            }
            case SHARED_LIBRARY: {
                uiType = "shared-library";
                break;
            }
            default: {
                uiType = FRAMEWORK_SU_UNKNOWN_STATE;
            }
        }
        return uiType;
    }

    protected Set getComponentNamesWithStatus(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String targetName) {
        List<Object> componentIdList = new ArrayList();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        if (componentQuery != null) {
            componentIdList = frameworkCompStatus == ComponentState.UNKNOWN ? componentQuery.getComponentIds(frameworkCompType) : componentQuery.getComponentIds(frameworkCompType, frameworkCompStatus);
        }
        return new HashSet(componentIdList);
    }

    protected Collection getComponentNamesDependentOnServiceAssembly(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String saName, String targetName) {
        HashSet compNameSet = new HashSet(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus, targetName));
        HashSet saNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnServiceAssembly(saName, targetName));
        compNameSet.retainAll(saNameDepCompNameSet);
        return compNameSet;
    }

    protected Collection getComponentNamesDependentOnSharedLibrary(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String slibName, String targetName) {
        HashSet compNameSet = new HashSet(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus, targetName));
        HashSet slibNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnSharedLibrary(slibName, targetName));
        compNameSet.retainAll(slibNameDepCompNameSet);
        return compNameSet;
    }

    protected Collection getComponentNamesDependentOnSharedLibraryAndServiceAssembly(ComponentType frameworkCompType, ComponentState frameworkCompStatus, String slibName, String saName, String targetName) {
        HashSet compNameSet = new HashSet(this.getComponentNamesWithStatus(frameworkCompType, frameworkCompStatus, targetName));
        HashSet slibNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnSharedLibrary(slibName, targetName));
        HashSet saNameDepCompNameSet = new HashSet(this.getComponentNamesDependentOnServiceAssembly(saName, targetName));
        slibNameDepCompNameSet.retainAll(saNameDepCompNameSet);
        compNameSet.retainAll(slibNameDepCompNameSet);
        return compNameSet;
    }

    protected Collection getComponentNamesDependentOnSharedLibrary(String slibName, String targetName) {
        List<Object> componentNames = new ArrayList();
        try {
            ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
            if (componentQuery != null) {
                componentNames = componentQuery.getDependentComponentIds(slibName);
            }
        }
        catch (Exception ex) {
            AbstractListStateServiceMBeansImpl.logDebug(ex);
        }
        return componentNames;
    }

    protected Collection getComponentNamesDependentOnServiceAssembly(String saId, String targetName) {
        try {
            String[] componentNames = (String[])this.invokeMBeanOperation(this.getDeploymentServiceMBeanObjectName(targetName), "getComponentsForDeployedServiceAssembly", saId);
            if (componentNames == null) {
                componentNames = new String[]{};
            }
            return new HashSet<String>(Arrays.asList(componentNames));
        }
        catch (Exception ex) {
            AbstractListStateServiceMBeansImpl.logDebug(ex);
            return new HashSet();
        }
    }

    protected ComponentQuery getFrameworkComponentQuery(String targetName) {
        ComponentQuery componentQuery = null;
        componentQuery = this.environmentContext.getComponentQuery(targetName);
        return componentQuery;
    }

    protected boolean isExistingComponent(String componentName, String targetName) {
        List list = new ArrayList();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        if (componentQuery != null) {
            list = componentQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        }
        return list.contains(componentName);
    }

    protected boolean isExistingSharedLibrary(String sharedLibraryName, String targetName) {
        List list = new ArrayList();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        if (componentQuery != null) {
            list = componentQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        }
        return list.contains(sharedLibraryName);
    }

    protected List getServiceAssemblyInfoList(String frameworkState, String componentName, String targetName) throws ManagementRemoteException {
        String compName = null;
        if (componentName != null) {
            compName = componentName.trim();
        }
        String[] saNames = new String[]{};
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        if (compName == null || compName.length() <= 0) {
            AbstractListStateServiceMBeansImpl.logDebug("getting all the deployed service assemblies with state " + frameworkState);
            saNames = (String[])this.getMBeanAttribute(deploymentServiceObjectName, "DeployedServiceAssemblies");
        } else {
            AbstractListStateServiceMBeansImpl.logDebug("getting all the deployed service assemblies for the comp " + compName);
            if (!this.isExistingComponent(compName, targetName)) {
                String[] args = new String[]{compName};
                Exception exception = this.createManagementException("ui.mbean.component.id.does.not.exist", args, null);
                throw new ManagementRemoteException(exception);
            }
            saNames = (String[])this.invokeMBeanOperation(deploymentServiceObjectName, "getDeployedServiceAssembliesForComponent", compName);
        }
        ArrayList<ServiceAssemblyInfo> saInfoByCompNameList = new ArrayList<ServiceAssemblyInfo>();
        for (int i = 0; i < saNames.length; ++i) {
            String saName = saNames[i];
            AbstractListStateServiceMBeansImpl.logDebug("getting deployment descriptor for " + saName);
            String saDDText = (String)this.invokeMBeanOperation(deploymentServiceObjectName, "getServiceAssemblyDescriptor", saName);
            ServiceAssemblyInfo saInfo = ServiceAssemblyInfo.createFromServiceAssemblyDD(new StringReader(saDDText));
            this.updateServiceAssemblyInfoState(saInfo, targetName);
            saInfoByCompNameList.add(saInfo);
        }
        ArrayList<ServiceAssemblyInfo> saInfoList = new ArrayList<ServiceAssemblyInfo>();
        if (frameworkState.equalsIgnoreCase(FRAMEWORK_SA_ANY_STATE)) {
            saInfoList.addAll(saInfoByCompNameList);
        } else {
            String uiState = AbstractListStateServiceMBeansImpl.toUiServiceAssemblyState(frameworkState);
            for (ServiceAssemblyInfo saInfo : saInfoByCompNameList) {
                if (!uiState.equalsIgnoreCase(saInfo.getState())) continue;
                saInfoList.add(saInfo);
            }
        }
        for (ServiceAssemblyInfo saInfo : saInfoList) {
            this.updateEachServiceUnitInfoStateInServiceAssemblyInfo(saInfo, targetName);
        }
        return saInfoList;
    }

    protected void updateServiceAssemblyInfoState(ServiceAssemblyInfo saInfo, String targetName) throws ManagementRemoteException {
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        String saName = saInfo.getName();
        String frameworkState = FRAMEWORK_SA_ANY_STATE;
        try {
            frameworkState = (String)this.invokeMBeanOperation(deploymentServiceObjectName, "getState", saName);
        }
        catch (Exception ex) {
            AbstractListStateServiceMBeansImpl.logDebug("issue 30: state invalid: " + ex.getMessage());
            frameworkState = "Unknown";
        }
        AbstractListStateServiceMBeansImpl.logDebug("Framework State = " + frameworkState + " for Service Assembly = " + saName);
        String uiState = AbstractListStateServiceMBeansImpl.toUiServiceAssemblyState(frameworkState);
        saInfo.setState(uiState);
    }

    protected void updateEachServiceUnitInfoStateInServiceAssemblyInfo(ServiceAssemblyInfo saInfo, String targetName) throws ManagementRemoteException {
        List list = saInfo.getServiceUnitInfoList();
        if (list == null) {
            return;
        }
        ObjectName deploymentServiceMBean = this.getDeploymentServiceMBeanObjectName(targetName);
        for (ServiceUnitInfo suInfo : list) {
            this.updateServiceUnitInfoState(suInfo, deploymentServiceMBean);
        }
    }

    protected void updateServiceUnitInfoState(ServiceUnitInfo suInfo, ObjectName deploymentServiceMBean) {
        suInfo.setState("Unknown");
        String compName = suInfo.getDeployedOn();
        String suName = suInfo.getName();
        try {
            if (deploymentServiceMBean == null) {
                AbstractListStateServiceMBeansImpl.logDebug("DeployerMBean not found for component " + compName);
                return;
            }
            Object[] params = new Object[]{compName, suName};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            String frameworkState = (String)this.invokeMBeanOperation(deploymentServiceMBean, "getServiceUnitState", params, signature);
            AbstractListStateServiceMBeansImpl.logDebug("Framework State = " + frameworkState + " for Service UNIT = " + suName);
            String uiState = AbstractListStateServiceMBeansImpl.toUiServiceUnitState(frameworkState);
            suInfo.setState(uiState);
        }
        catch (Exception ex) {
            AbstractListStateServiceMBeansImpl.log(AbstractListStateServiceMBeansImpl.getI18NBundle().getMessage("ui.mbean.exception.getting.service.unit.state", suName, compName, ex.getMessage()));
            AbstractListStateServiceMBeansImpl.logDebug(ex);
        }
    }

    protected ObjectName[] getSystemLoggerMBeans(String instanceName) {
        MBeanNames mbn = this.environmentContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":JbiName=" + instanceName;
        tmp = tmp + ",ComponentType=System";
        tmp = tmp + ",ControlType=Logger";
        tmp = tmp + ",*";
        ObjectName mbeanPattern = null;
        try {
            mbeanPattern = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException mex) {
            AbstractListStateServiceMBeansImpl.logDebug(mex.getMessage());
            return new ObjectName[0];
        }
        Set<ObjectName> resultSet = this.environmentContext.getMBeanServer().queryNames(mbeanPattern, null);
        ObjectName[] names = new ObjectName[]{};
        if (!resultSet.isEmpty()) {
            names = resultSet.toArray(names);
        } else {
            AbstractListStateServiceMBeansImpl.logDebug("Logger MBeans with ObjectName pattern " + tmp + " not found.");
        }
        return names;
    }

    protected Map<String, Descriptor> getConfigurationDescriptors(ObjectName objectName) throws ManagementRemoteException {
        HashMap<String, Descriptor> descrMap = new HashMap<String, Descriptor>();
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanInfo = null;
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo)) continue;
                ModelMBeanAttributeInfo modelAttrInfo = (ModelMBeanAttributeInfo)attributeInfo;
                descrMap.put(modelAttrInfo.getName(), modelAttrInfo.getDescriptor());
            }
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException(e);
        }
        catch (IntrospectionException e) {
            throw new ManagementRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException(e);
        }
        return descrMap;
    }

    protected String getComponentState(String componentName, String targetName) throws ManagementRemoteException {
        String result = "Unknown";
        String xmlText = null;
        List infoList = null;
        String state = null;
        String sharedLibraryName = null;
        String serviceAssemblyName = null;
        try {
            xmlText = this.listComponents(ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText(xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!info.getName().equals(componentName)) continue;
                    return info.getState();
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        try {
            xmlText = this.listComponents(ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText(xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!info.getName().equals(componentName)) continue;
                    return info.getState();
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return result;
    }

    protected void targetUpCheck(String target) throws ManagementRemoteException {
        String targetName = target;
        if (this.getPlatformContext().isClusteredServer(targetName)) {
            targetName = this.getPlatformContext().getTargetName(target);
        }
        if (!this.isTargetUp(targetName)) {
            Exception exception = this.createManagementException("ui.mbean.target.down", new String[]{targetName}, null);
            throw new ManagementRemoteException(exception);
        }
    }

    protected void componentStartedOnTargetCheck(String componentName, String target) throws ManagementRemoteException {
        String state;
        String targetName = target;
        if (this.getPlatformContext().isClusteredServer(targetName)) {
            targetName = this.getPlatformContext().getTargetName(target);
        }
        if (!FRAMEWORK_SA_STARTED_STATE.equalsIgnoreCase(state = this.getComponentState(componentName, targetName)) && !FRAMEWORK_SA_STOPPED_STATE.equalsIgnoreCase(state)) {
            Exception exception = this.createManagementException("ui.mbean.component.configuration.not.started.not.stopped.on.target.error", new String[]{componentName, targetName}, null);
            throw new ManagementRemoteException(exception);
        }
    }

    protected void componentInstalledOnTargetCheck(String componentName, String target) throws ManagementRemoteException {
        boolean isInstalled;
        String targetName = target;
        if (this.getPlatformContext().isClusteredServer(targetName)) {
            targetName = this.getPlatformContext().getTargetName(target);
        }
        if (!(isInstalled = this.isExistingComponent(componentName, targetName))) {
            Exception exception = this.createManagementException("ui.component.not.installed.on.target.error", new String[]{componentName, targetName}, null);
            throw new ManagementRemoteException(exception);
        }
    }

    class IdentificationNewNSContext
    implements NamespaceContext {
        IdentificationNewNSContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("identification")) {
                return AbstractListStateServiceMBeansImpl.COMPONENT_VERSION_NS_NEW;
            }
            return "http://java.sun.com/xml/ns/jbi";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }

    class IdentificationNSContext
    implements NamespaceContext {
        IdentificationNSContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("identification")) {
                return AbstractListStateServiceMBeansImpl.COMPONENT_VERSION_NS;
            }
            return "http://java.sun.com/xml/ns/jbi";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

