/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.AlertPersistenceDBType;
import com.sun.esb.eventmanagement.impl.AlertLevelType;
import com.sun.esb.eventmanagement.impl.AlertRemovalPolicyType;
import com.sun.esb.eventmanagement.impl.AlertUtil;
import com.sun.esb.eventmanagement.impl.ConnectionConfigurationImpl;
import com.sun.esb.eventmanagement.impl.DBEventStore;
import com.sun.esb.eventmanagement.impl.DBSchemaCreation;
import com.sun.esb.eventmanagement.impl.EventManagementConstants;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.I18NBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class AlertPersistenceConfiguration
implements EventManagementConstants {
    public static final String ONE_OF_GLASSFISH_DOMAIN_NAMES = "com.sun.appserv";
    public static final String DEFAULT_PERSISTENCE_JNDI_NAME = "AlertPersistenceDB";
    private I18NBundle I18NPACKAGEBUNDLE;
    private Boolean mPersistedAlertRemovalPolicyExecEnabled = false;
    private Long mPersistenceAlertAgePolicyValue;
    private Long mPersistenceAlertCountPolicyValue;
    private Long mPersistenceAlertPolicyExecInterval;
    private AlertLevelType mPersistenceAlertLevelPolicyValue;
    private List<AlertRemovalPolicyType> mAlertRemovalPolicyTypeList = new ArrayList<AlertRemovalPolicyType>();
    private AlertPersistenceDBType mAlertPersistenceDBType;
    private String mDataSourceJndiName;
    private Boolean mPersistenceEnabled = false;
    private Boolean mJournalEnabled = false;
    private boolean isDBSetup;
    private MBeanServerConnection mMBeanServer;
    private DBEventStore mDBEventStore;
    private static AlertPersistenceConfiguration mAlertPersistenceConfiguration;
    private String mAlertTableName;
    private boolean isAdminServer;

    public static synchronized AlertPersistenceConfiguration getInstance(MBeanServerConnection aMBeanServer) {
        if (mAlertPersistenceConfiguration == null) {
            mAlertPersistenceConfiguration = new AlertPersistenceConfiguration(aMBeanServer);
        }
        return mAlertPersistenceConfiguration;
    }

    private AlertPersistenceConfiguration(MBeanServerConnection aMBeanServer) {
        this.mMBeanServer = aMBeanServer;
    }

    public Boolean getPersistedAlertRemovalPolicyExecEnabled() {
        return this.mPersistedAlertRemovalPolicyExecEnabled;
    }

    public void setPersistedAlertRemovalPolicyExecEnabled(Boolean persistedAlertRemovalPolicyExecEnabled) {
        this.mPersistedAlertRemovalPolicyExecEnabled = persistedAlertRemovalPolicyExecEnabled;
        if (this.mDBEventStore != null) {
            this.mDBEventStore.enablePolicyExecution(persistedAlertRemovalPolicyExecEnabled);
        }
    }

    public Long getPersistenceAlertAgePolicyValue() {
        return this.mPersistenceAlertAgePolicyValue;
    }

    public void setPersistenceAlertAgePolicyValue(Long persistenceAlertAgePolicyValue) {
        this.mPersistenceAlertAgePolicyValue = persistenceAlertAgePolicyValue;
    }

    public Long getPersistenceAlertCountPolicyValue() {
        return this.mPersistenceAlertCountPolicyValue;
    }

    public void setPersistenceAlertCountPolicyValue(Long persistenceAlertCountPolicyValue) {
        this.mPersistenceAlertCountPolicyValue = persistenceAlertCountPolicyValue;
    }

    public Long getPersistenceAlertPolicyExecInterval() {
        return this.mPersistenceAlertPolicyExecInterval;
    }

    public void setPersistenceAlertPolicyExecInterval(Long persistenceAlertPolicyExecInterval) {
        this.mPersistenceAlertPolicyExecInterval = persistenceAlertPolicyExecInterval;
        if (this.mDBEventStore != null) {
            this.mDBEventStore.UpdatePolicyExecutionInterval(this.mPersistenceAlertPolicyExecInterval);
        }
    }

    public AlertLevelType getPersistenceAlertLevelPolicyValue() {
        return this.mPersistenceAlertLevelPolicyValue;
    }

    public void setPersistenceAlertLevelPolicyValue(AlertLevelType persistenceAlertLevelPolicyValue) {
        this.mPersistenceAlertLevelPolicyValue = persistenceAlertLevelPolicyValue;
    }

    public List<AlertRemovalPolicyType> getAlertRemovalPolicyTypeList() {
        return this.mAlertRemovalPolicyTypeList;
    }

    public void setAlertRemovalPolicyTypeList(List<String> alertRemovalPolicyTypeList) {
        this.mAlertRemovalPolicyTypeList.clear();
        for (String alertRemovalPolicyTypeList1 : alertRemovalPolicyTypeList) {
            this.mAlertRemovalPolicyTypeList.add(AlertRemovalPolicyType.valueOf(alertRemovalPolicyTypeList1));
        }
    }

    public void setAlertRemovalPolicyTypeList(String alertEnforcedPolicyList) {
        this.mAlertRemovalPolicyTypeList.clear();
        if (alertEnforcedPolicyList == null || alertEnforcedPolicyList.length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(alertEnforcedPolicyList, ",");
        while (tokenizer.hasMoreTokens()) {
            String enforcedPolicy = tokenizer.nextToken();
            this.mAlertRemovalPolicyTypeList.add(AlertRemovalPolicyType.valueOf(enforcedPolicy));
        }
    }

    public String getDataSourceJndiName() {
        return this.mDataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.mDataSourceJndiName = dataSourceJndiName;
    }

    public AlertPersistenceDBType getAlertPersistenceDBType() {
        return this.mAlertPersistenceDBType;
    }

    public void setAlertPersistenceDBType(AlertPersistenceDBType alertPersistenceDBType) {
        this.mAlertPersistenceDBType = alertPersistenceDBType;
    }

    public Properties getPersistenceProperties() {
        Properties policyProps = new Properties();
        if (this.isAdminServer) {
            policyProps.setProperty("PersistencePolicyExecEnabled", this.mPersistedAlertRemovalPolicyExecEnabled.toString());
            policyProps.setProperty("PersistencePolicyExecInterval", this.mPersistenceAlertPolicyExecInterval.toString());
            policyProps.setProperty("PersistenceAlertAge", this.mPersistenceAlertAgePolicyValue.toString());
            policyProps.setProperty("PersistenceAlertCount", this.mPersistenceAlertCountPolicyValue.toString());
            policyProps.setProperty("PersistenceAlertLevel", this.mPersistenceAlertLevelPolicyValue.getAlertLevel());
            policyProps.setProperty("journalEnabled", this.mJournalEnabled.toString());
            int enforcedPolicySize = this.mAlertRemovalPolicyTypeList.size();
            if (enforcedPolicySize > 0) {
                StringBuffer enforcedPolicy = new StringBuffer();
                for (int index = 0; index < enforcedPolicySize; ++index) {
                    String policyEntry = this.mAlertRemovalPolicyTypeList.get(index).getPolicyType();
                    enforcedPolicy.append(policyEntry);
                    if (index == enforcedPolicySize - 1) continue;
                    enforcedPolicy.append(",");
                }
                policyProps.setProperty("PolicyEnforced", enforcedPolicy.toString());
            }
        }
        policyProps.setProperty("DatabaseType", this.mAlertPersistenceDBType.getDatabasetype());
        policyProps.setProperty("DBJndiName", this.mDataSourceJndiName);
        policyProps.setProperty("PersistenceEnabled", this.mPersistenceEnabled.toString());
        policyProps.setProperty("AlertTableName", this.mAlertTableName);
        return policyProps;
    }

    public Boolean getPersistenceEnabled() {
        return this.mPersistenceEnabled;
    }

    public void setPersistenceEnabled(Boolean persistenceEnabled) throws ManagementRemoteException {
        boolean currentPersistenceEnabledValue = this.mPersistenceEnabled;
        boolean newPersistenceEnabledValue = persistenceEnabled;
        if (!currentPersistenceEnabledValue && newPersistenceEnabledValue && this.isAdminServer && !this.isDBSetup && this.createDatabase()) {
            this.isDBSetup = true;
        }
        this.mPersistenceEnabled = persistenceEnabled;
        if (!this.mPersistenceEnabled.booleanValue()) {
            this.mJournalEnabled = this.mPersistenceEnabled;
        }
    }

    public boolean createDatabase() throws ManagementRemoteException {
        boolean done = true;
        ConnectionConfigurationImpl connectionConfig = new ConnectionConfigurationImpl(this.mDataSourceJndiName, this.mMBeanServer);
        try {
            if (this.isGlassfishAppSever() && this.mAlertPersistenceDBType == AlertPersistenceDBType.DERBY) {
                connectionConfig.createConnectionsPools();
            }
            InitialContext ic = null;
            DataSource aDataSource = null;
            try {
                ic = new InitialContext();
                aDataSource = (DataSource)ic.lookup(this.mDataSourceJndiName);
            }
            catch (NamingException e) {
                Exception exp = AlertUtil.createManagementException("caps.management.server.alert.configuration.initialContext.error", null, e);
                throw new ManagementRemoteException(exp);
            }
            if (aDataSource == null) {
                throw new ManagementRemoteException(this.getPackageBundle().getMessage("caps.management.server.alert.configuration.invalidDataSource.error", new Object[]{this.mDataSourceJndiName}));
            }
            DBSchemaCreation dbschema = new DBSchemaCreation();
            if (this.isGlassfishAppSever() && this.mAlertPersistenceDBType == AlertPersistenceDBType.DERBY) {
                dbschema.setUniqueTableName(this.getAlertTableName());
                dbschema.checkAndCreateTables(this.mAlertPersistenceDBType, aDataSource);
            }
            if (this.mDBEventStore != null) {
                this.mDBEventStore.initializeDataSource();
            }
        }
        catch (ManagementRemoteException e) {
            this.mPersistenceEnabled = false;
            this.mJournalEnabled = false;
            done = false;
            throw new ManagementRemoteException(e);
        }
        return done;
    }

    private I18NBundle getPackageBundle() {
        if (this.I18NPACKAGEBUNDLE == null) {
            this.I18NPACKAGEBUNDLE = new I18NBundle("com.sun.esb.eventmanagement.impl");
        }
        return this.I18NPACKAGEBUNDLE;
    }

    public void setDBEventStore(DBEventStore eventStore) {
        this.mDBEventStore = eventStore;
    }

    private boolean isGlassfishAppSever() {
        boolean isGlassFish = false;
        try {
            String[] registeredDomains;
            for (String domain : registeredDomains = this.mMBeanServer.getDomains()) {
                if (domain.indexOf(ONE_OF_GLASSFISH_DOMAIN_NAMES) == -1) continue;
                isGlassFish = true;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isGlassFish;
    }

    public String getAlertTableName() {
        return this.mAlertTableName;
    }

    public void setAlertTableName(String alertTableName) {
        this.mAlertTableName = alertTableName;
    }

    public void setAdminServer(boolean isAdminServer) {
        this.isAdminServer = isAdminServer;
    }

    public Boolean isJournalEnabled() {
        return this.mJournalEnabled;
    }

    public void setJournalEnabled(Boolean journalEnabled) {
        this.mJournalEnabled = journalEnabled;
    }
}

