/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.plugins;

import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openesb.standalone.Lifecycle;
import net.openesb.standalone.env.Environment;
import net.openesb.standalone.plugins.Plugin;
import net.openesb.standalone.settings.Settings;

public class PluginsService {
    private static final Logger LOGGER = Logger.getLogger(PluginsService.class.getName());
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private final Settings settings;
    private final Environment environment;
    private final Set<Plugin> plugins;

    public PluginsService(Settings settings, Environment environment) {
        this.settings = settings;
        this.environment = environment;
        this.loadPluginsIntoClassLoader();
        this.plugins = this.loadPluginsFromClasspath();
    }

    private void loadPluginsIntoClassLoader() {
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) {
            return;
        }
        ClassLoader classLoader = this.getCurrentClassloader();
        Class<?> classLoaderClass = classLoader.getClass();
        Method addURL = null;
        while (!classLoaderClass.equals(Object.class)) {
            try {
                addURL = classLoaderClass.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException e) {
                classLoaderClass = classLoaderClass.getSuperclass();
            }
        }
        if (addURL == null) {
            LOGGER.log(Level.INFO, "failed to find addURL method on classLoader [{0}] to add methods", classLoader);
            return;
        }
        for (File pluginFile : pluginsFile.listFiles()) {
            if (!pluginFile.isDirectory()) continue;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "--- Adding plugin [{0}]", pluginFile.getAbsolutePath());
            }
            try {
                File libLocation;
                addURL.invoke((Object)classLoader, pluginFile.toURI().toURL());
                ArrayList<File> libFiles = new ArrayList<File>();
                if (pluginFile.listFiles() != null) {
                    libFiles.addAll(Arrays.asList(pluginFile.listFiles()));
                }
                if ((libLocation = new File(pluginFile, "lib")).exists() && libLocation.isDirectory() && libLocation.listFiles() != null) {
                    libFiles.addAll(Arrays.asList(libLocation.listFiles()));
                }
                for (File libFile : libFiles) {
                    if (!libFile.getName().endsWith(".jar") && !libFile.getName().endsWith(".zip")) continue;
                    addURL.invoke((Object)classLoader, libFile.toURI().toURL());
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Failed to add plugin [" + pluginFile + "]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Plugin> loadPluginsFromClasspath() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        try {
            ClassLoader classLoader = this.getCurrentClassloader();
            Enumeration<URL> pluginUrls = classLoader.getResources(PLUGIN_PROPERTIES);
            while (pluginUrls.hasMoreElements()) {
                URL pluginUrl = pluginUrls.nextElement();
                Properties pluginProps = new Properties();
                InputStream is = null;
                try {
                    is = pluginUrl.openStream();
                    pluginProps.load(is);
                    String pluginClassName = pluginProps.getProperty("plugin");
                    String pluginVersion = pluginProps.getProperty("version", "NA");
                    Plugin plugin = this.loadPlugin(pluginClassName, this.settings);
                    plugins.add(plugin);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Failed to load plugin from [" + pluginUrl + "]", e);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to find plugins from classpath", e);
        }
        return plugins;
    }

    private Plugin loadPlugin(String className, Settings settings) {
        try {
            Plugin plugin;
            Class<?> pluginClass = this.getCurrentClassloader().loadClass(className);
            try {
                plugin = (Plugin)pluginClass.getConstructor(Settings.class).newInstance(settings);
            }
            catch (NoSuchMethodException e) {
                try {
                    plugin = (Plugin)pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException("No constructor for [" + pluginClass + "]. A plugin class must " + "have either an empty default constructor or a single argument constructor accepting a " + "Settings instance");
                }
            }
            return plugin;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load plugin class [" + className + "]", e);
        }
    }

    private ClassLoader getCurrentClassloader() {
        return PluginsService.class.getClassLoader();
    }

    public Set<Plugin> plugins() {
        return this.plugins;
    }

    public Collection<Class<? extends Lifecycle>> services() {
        ArrayList<Class<? extends Lifecycle>> services = new ArrayList<Class<? extends Lifecycle>>();
        for (Plugin plugin : this.plugins) {
            services.addAll(plugin.services());
        }
        return services;
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList<Class<? extends Module>> modules = new ArrayList<Class<? extends Module>>();
        for (Plugin plugin : this.plugins) {
            modules.addAll(plugin.modules());
        }
        return modules;
    }
}

