/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.plugins;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import net.openesb.standalone.plugins.PluginsService;
import net.openesb.standalone.settings.Settings;

public class PluginsModule
extends AbstractModule {
    private final Settings settings;
    private final PluginsService pluginsService;

    public PluginsModule(Settings settings, PluginsService pluginsService) {
        this.settings = settings;
        this.pluginsService = pluginsService;
    }

    public Iterable<? extends Module> childModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        Collection<Class<? extends Module>> modulesClasses = this.pluginsService.modules();
        for (Class<? extends Module> moduleClass : modulesClasses) {
            modules.add(PluginsModule.createModule(moduleClass, this.settings));
        }
        return modules;
    }

    protected void configure() {
        this.bind(PluginsService.class).toInstance((Object)this.pluginsService);
    }

    public static Module createModule(Class<? extends Module> moduleClass, Settings settings) {
        try {
            Constructor<? extends Module> constructor = moduleClass.getConstructor(Settings.class);
            try {
                return constructor.newInstance(settings);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create module [" + moduleClass + "]", e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends Module> constructor = moduleClass.getConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Failed to create module [" + moduleClass + "]", e);
                }
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException("No constructor for [" + moduleClass + "]");
            }
        }
    }
}

