/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.http.grizzly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import net.openesb.rest.api.OpenESBApplication;
import net.openesb.security.SecurityProvider;
import net.openesb.standalone.LifecycleException;
import net.openesb.standalone.env.Environment;
import net.openesb.standalone.http.HttpServer;
import net.openesb.standalone.http.handlers.AdminConsoleHandler;
import net.openesb.standalone.http.handlers.SitePluginHandler;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.utils.I18NBundle;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ContainerFactory;

public class EmbeddedHttpServer
implements HttpServer {
    private static final Logger LOG = Logger.getLogger(HttpServer.class.getPackage().getName());
    private static final String HTTP_LISTENER_NAME = "openesb-http-server";
    private static final String HTTP_PORT_PROPERTY = "http.port";
    private static final String HTTP_ENABLED_PROPERTY = "http.enabled";
    private static final String HTTP_BINDING_PROPERTY = "http.binding";
    private static final int DEFAULT_HTTP_PORT = 4848;
    private static final boolean DEFAULT_HTTP_ENABLED = true;
    private org.glassfish.grizzly.http.server.HttpServer httpServer = null;
    private final Settings settings;
    private final Environment environment;
    private boolean enabled;
    private final SecurityProvider securityProvider;

    @Inject
    public EmbeddedHttpServer(Settings settings, Environment environment, SecurityProvider securityProvider) {
        this.settings = settings;
        this.environment = environment;
        this.securityProvider = securityProvider;
        this.init();
    }

    private void init() {
        this.enabled = this.settings.getAsBoolean(HTTP_ENABLED_PROPERTY, true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("HTTP_SERVER_ENABLED", this.enabled));
        }
        if (this.enabled) {
            this.httpServer = this.createHttpServer();
            ServerConfiguration config = this.httpServer.getServerConfiguration();
            AdminConsoleHandler consoleHandler = new AdminConsoleHandler();
            config.addHttpHandler(consoleHandler.getHandler(), new String[]{consoleHandler.path()});
            SitePluginHandler pluginHandler = new SitePluginHandler(this.environment);
            config.addHttpHandler(pluginHandler.getHandler(), new String[]{pluginHandler.path()});
            RuntimeDelegate.setInstance(null);
            OpenESBApplication app = new OpenESBApplication();
            app.register((Object)new SecurityBridgeProvider());
            HttpHandler handler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)app);
            config.addHttpHandler(handler, new String[]{"/api"});
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (this.enabled) {
            try {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("HTTP_START_SERVER"));
                }
                this.httpServer.start();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("HTTP_START_SERVER_FAILED"), ex);
            }
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (this.enabled && this.httpServer != null) {
            this.httpServer.shutdownNow();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("HTTP_STOP_SERVER"));
            }
        }
    }

    private org.glassfish.grizzly.http.server.HttpServer createHttpServer() {
        int port = this.settings.getAsInt(HTTP_PORT_PROPERTY, 4848);
        String binding = this.settings.get(HTTP_BINDING_PROPERTY, "0.0.0.0");
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("HTTP_SERVER_PORT", port));
        }
        org.glassfish.grizzly.http.server.HttpServer server = new org.glassfish.grizzly.http.server.HttpServer();
        NetworkListener listener = new NetworkListener(HTTP_LISTENER_NAME, binding, port);
        ThreadPoolConfig threadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(5).setMaxPoolSize(5);
        listener.getTransport().setWorkerThreadPoolConfig(threadPoolConfig);
        server.addListener(listener);
        return server;
    }

    @Override
    public void addRestHandler(Application application, String rootURI) {
        if (this.enabled) {
            ServerConfiguration config = this.httpServer.getServerConfiguration();
            HttpHandler handler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)application);
            config.addHttpHandler(handler, new String[]{rootURI});
        }
    }

    class SecurityBridgeProvider
    extends AbstractBinder {
        SecurityBridgeProvider() {
        }

        protected void configure() {
            this.bind(EmbeddedHttpServer.this.securityProvider).to(SecurityProvider.class);
        }
    }
}

